/*******************************************************************************************************************************************
 *  正式考试
 *  
 *  细节： 每个题目的选项都以 {题库ID}_{题目ID} 做 id , 并且在题目主体前有一个id=headof_{题库ID}_{题目ID}的对象
 *                在1 调取试卷和答卷纸 2 保存 3 做每道题时， 同步设置题目定位按钮的状态，
 *
 *
 *
****************************************************************************************************************************************** */
 
 //全局对象
 $G={  paper:null ,                         //试卷的内容及考试设置
             canSave:false,                 //是否可以保存
             canSubmit:false ,              // 允许交卷吗
             autoSaveFunctionId:0,   //自动保存的任务句柄
             timeoutCheckFunctionId:0 ,  // 剩余时间检测的函数句柄
             timeoutCheckFrequence:1 ,  //  剩余时间检测周期，以秒为单位
             timeoutCheckTimes:0 ,  //  剩余时间检测次数
             autosaveafterminute:5,    // 自动保存时间间隔，以分钟为单位
             firstLoginDate:null,       // 最早的登录时间
             leftMinute:0,                     //剩余时间
             
             autoScroll:true   // 点击某个题目后，自动把这个题目置顶显示
          } ;
 
/**
 * 调取试卷及答卷纸
 */

if( ! gs_justTest )
{
       //$(document).ready( load );
    window.onload=load;
}

function  load ()
{
 
    
    $.blockUI("正在加载试卷...");
  
    $("#paperContainer").css("display","none");
    
     $rpc( 'educ.exam.Exam', 'getMyDoingPaper' , 
                                   {
                                     'id'          :   $('#id').val() ,
                                     'userid'          :   $('#userid').val()
                                     
                                    },
                                   function( ret)
                                   {
                                    
                                      
                                      var pw=DomUtil.parentWindow( );  
                                       var  data=  JSON.parse(ret);
                                       //如果调取试卷不成功，或者不允许，那么直接警告，并把标记canSave 设置成false,禁止保存
                                       if ( !data.success)
                                       {
										    pw.cb_submit.disable();
                                            pw.cb_save.disable();
                                            pw.cb_autoScroll.disable();
                                            $.unblockUI();
                                            alert (data.message);
                                            $G.canSave=false;
                                           
                                            return;
                                       }
                                       //保存一些数据，后面会用到
                                       $G.canSave=data.canSave; //是否允许保存
                                       $G.paper=data;//放在全局变量里，备用
                                       $G.firstLoginDate=data.firstlogindate; // 最初的登录时间
                                       $G.leftMinute = data.leftminute; //最后一次保存后，考试在多少分钟后结束
                                       DomUtil.parentWindow().setInfo2("在" +data.leftminute+"分钟后考试结束");
                                       if ( data.leftminute<=0) DomUtil.parentWindow().setInfo2("考试已结束");
                                       
                                       var typeConfig= data.typeConfig;
                                       var itemConfig=data.itemConfig;
                                       
                                       
                                        //用于定位题目的HTML
                                       var navigate="<div>";
                                       
                                       var html="<div class=examName>"+data.config.name+"</div><br><div style='text-align:center; color:blue;'>[ 应试时间："+data.config.totalminute+
                                                     "分钟 ]&nbsp;&nbsp;&nbsp;&nbsp;考生姓名：【"+data.usershowname+"】<span id=escapedscore></span></div> <br>";
                                         //如果已经交卷，那么显示评分情况
                                      
                                       $("#paper").append(  (html));//大类名称
                                       
                                       //乱序
                    
                                      if ( data.randlistsubject)  itemConfig.sort(function(){return Math.random()>0.5?-1:1;});
                                       
                                        if( data.issubmitted ) DomUtil.parentWindow().setInfo2 (  buildScoreTip(data)  ); 
                                       
                                       for( var i=0;i<typeConfig.length;i++)//题目大类循环
                                       {
                                            var tc= typeConfig[i];
                                           
                                            var html = TrimPath.processDOMTemplate("template/educ/testPaperItemType", tc);
                                          
                                             navigate+='<div>'+tc.typename+'</div>';
                                            $("#paper").append(  (html));//大类名称
                                            var itemtype= tc.itemtype;
                                            var c=0;
                                            
                                            if ( i==3) 
                                            {
                                                
                                                var debug;
                                                debug=true;
                                            }
                                           
                                            for( var jj=0;jj< itemConfig.length;jj++)//对每道题进行判断
                                            {
                                                
                                                var item= itemConfig[jj];
                                                if ( item.itemtype!=itemtype) continue;
                                                c ++;
                                                //如果是选择题，如果是题目候选项需要乱序
                                                if( item.itemtype == 'DX' || item.itemtype == 'FX' )
                                                {
                                                    if ( data.randlistcandidate)
                                                    {
	                                                    item.candidate.sort(function(){return Math.random()>0.5?-1:1;});
	                                                    var candidate= item.candidate;
	                                                    //序号重新设置
	                                                    for( var ci=0;ci< candidate.length;ci++)
	                                                    {
	                                                        candidate[ci].no= ci+1;
	                                                    }
                                                    }
                                                }
                                                
                                                item.no=c; //计算当前题在当前大类中的题号
                                                var a='headof_'+item.libraryid+'_'+item.itemid;
                                                navigate+='<span id='+a+'  class=asbutton style="font-size:11px;border:1px solid #efefef;background-color:#c2ff48; " onclick="jumpTo(\''+a+'\' )" >'+c+"</span> ";//最后要留一个空格
                                                item.typename=tc.typename;
                                                var html = TrimPath.processDOMTemplate("template/educ/testPaperItem", item);
                                                $("#paper").append(  (html));
                                                 //显示标准答案,如果已经交卷
                                                 if( data.issubmitted ) $G.onShowAnswer(item );
                                            }
                                         
                                           navigate+='<br>';
                            
                                   }
                             
                                  //题目定位
                                  navigate+='</div>';
                        
                                  pw.setNavigateHTML( navigate);     
                                       
                                     
                                  
                                  $.unblockUI();
                                  $.blockUI("正在还原答卷纸...");
                                  $("#paperContainer").css("display","");
                                  //重新调取答卷纸
                                  try
                                  {
		                                  var  s=data.answer;
		                                  if ( s.length>0)
		                                  {
		                                      var answers= JSON.parse( s);
		                                      for ( var key  in  answers )
		                                      {
		                                          var answer= answers[key]; //得到的是一个包含了更多信息的包，其中的useranswer才是考生的答案
		                                          var flag=AnswerUtil.restoreAnswer( key , answer);
		                                          pw.setNavigateFlag( key , flag); // 同步设置题目导航按钮的状态
		                                      }
		                                
		                                  }
                                  }catch(err)
                                  {
                                    
                                  }
		                                  
                                  $.unblockUI();
                                  //注册自动保存
                                  
                              
                                    
                                  
                                  if ( data.isViewing ) //如果是在查看考卷，比如老师查卷子，那么是只读的
                                  {
                                       $G.canSave = false;
                                       $G.canSubmit = false;
                                       
                                        
                                  }else
                                  {
                                
		                                   if ( data.issubmitted) //如果已经交卷了 
		                                   {
		                                       $G.canSave = false;
		                                       $G.canSubmit = false;
		                                       //alert('已经交卷了，您只允许查看，而不能修改'); 
		                                   }else//没有交卷
		                                   {
		                                       if( data.timeout)//但时间已经到了
		                                       {
			                                           $G.canSave = false;
			                                           $G.canSubmit = true;
			                                           alert('考试已经结束，但您尚未交卷，系统将自动交卷');
			                                           $G.onSubmit( true,false ); //强制提交,提交前不需要保存，因为刚调出来
			                                           
			                                     
			                                  }else //如果没有到时间，那么可以保存，可以提交
			                                  {
			                                           $G.canSave = true;
			                                           $G.canSubmit = true;
			                                  }
		                                  }
                                      }
                                    
                                  //允许保存时才注册这些任务
                                  if ( $G.canSave)
                                  {
	                                  $G.autosaveafterminute= data.config.autosaveafterminute;
	                                  if ( $G.autosaveafterminute<=0) $G.autosaveafterminute=5;
	                                  $G.autoSaveFunctionId = setTimeout( "$G.onSave(false)" , $G.autosaveafterminute*60*1000);
	                                  //定时检测是否考试结束了 
	                                  $G.timeoutCheckFunctionId=setInterval("$G.timeoutCheck( ) ",$G.timeoutCheckFrequence*1000);
                                  }
                                  
                                  //更新父窗口的按钮的使能状态
                                  var pw=DomUtil.parentWindow( );
                                  if (! $G.canSave )
                                  {
                                    pw.cb_save.disable();
                                    pw.cb_autoScroll.disable();
                                    //不能保存时，把考试中的INPUT都设置成readonly
                                    var objs=$('input');
                                    for( var i=0;i<objs.length;i++)
                                    {
                                        objs[i].disabled=true;
                                    }
                                    
                                    objs=$('textarea');
                                    for( var i=0;i<objs.length;i++)
                                    {
                                        objs[i].readOnly=true;
                                    }
                                    
                                  }
                                  
                                  if (! $G.canSubmit ) pw.cb_submit.disable();
                       
                                  if (data.issubmitted )
                                  {
	                                   $.blockUI("正在还原历史评分情况...");
	                                    for( var jj=0;jj< itemConfig.length;jj++)//对每道题进行判断
	                                    {
	                                        
	                                        var item= itemConfig[jj];
	                                        //显示评分情况
	                                        $G.showEvalInfo(item ,  data.evalResult );
	                                        
	                                    }  
	                                   $.unblockUI();
                                 }      
                                   
                               
                                    
                            }
                 ) ;             
                 
  
        
}



function  buildScoreTip( data)
{
      if ( data.allEvaled)
    {
        var id="escapedscore";
        var  obj= document.getElementById(id);
        var s= ''+data.scoreshow;
       
       obj.innerHTML="&nbsp;&nbsp;&nbsp;得分：<font color=red size=6>"+ s +"</div>";
         
    }
    return "<img src='image/avi_baba.gif' align='absmiddle'><font color=red>"+ (data.allEvaled ?(  "最终卷面得分：" +data.totalScore +" ，折合标准分："+data.escapedscore+" ，及格线："+data.passscore) : 
                                               ( "有 "+data.unEvalCount+" 题未评分，当前卷面得分：" +data.totalScore ))+"</font>" ;
}




/**
 * 显示标准答案
 */
$G.onShowAnswer =function( item)
{
    
     
     var html="<br><div style='padding:10px; border:1px #80ff80 solid ; background-color:#f0fff0'>&nbsp;<font color=green>【标准答案提示】 </font>"+AnswerUtil.buildStandardAnswerHTML( item , item.answer) +"</div><br><br>";
     var key= item.libraryid+"_"+item.itemid;
     var obj=$('#'+key+'_answerContainer');
    obj.html(  html );
  
}
　

$G.showEvalInfo=function (  item  , evalResult  )
{
    
        var key= item.libraryid+"_"+item.itemid;
        var resultItem=null;
        //定位到评分结果
        for( var i=0;i< evalResult.length; i++)
        {
            var ei= evalResult[i];
            if ( ei.libraryid+"_"+ei.itemid ==key) 
            {
                resultItem= ei;
                break;
            }
        }
        
        if( resultItem!=null)   showEvalHistory( resultItem); 
        
        if ( item.itemtype=="DX" ||  item.itemtype=="FX" || item.itemtype=="PD"   ) return; //主观题不需要手工评分
        
          
}


function  showEvalHistory( resultItem)
{
       var key= resultItem.libraryid+'_'+resultItem.itemid;
        //调取评分信息
            try
            {
                
                var  evaltips=JSON.parse( resultItem.evaltip );
                var html="";
                if ( evaltips.length>0) 
                {
                    html=html+"【评分过程】<br>";
                    var img="image/ok.gif";
                    if ( resultItem.rightpercent>0 && resultItem.rightpercent<100.0) img="image/okhalf.gif"; 
                    if (  resultItem.rightpercent==0) img="image/cancel.gif"; 
                    
                    html= html+"<br><img src='"+img +"' > &nbsp;&nbsp;本题正确率：&nbsp;<font color=red>"+resultItem.rightpercent+"%</font>&nbsp;&nbsp;&nbsp;实际得分：&nbsp;<font color=red>"+resultItem.userscore+"</font>";
                    for( var i=0;i<evaltips.length;i++)
                    {
                        
                        html=html+'<br><font color=black>评分人：</font>' +evaltips[i].teachername+"&nbsp;<font color=black>评语：</font>"+ evaltips[i].tip +"&nbsp;<font color=black>评分日期：</font>"+ evaltips[i].date;
                    }
                    //最后拼一个div 用来放手工评分界面
                    html="<div style='color:green'>"+html+"</div><br><br>";
                    $('#'+key+'_evalContainer').html( $(html));
                }
            }catch(err)
            {
                
            }
}




/**
 * 保存答卷纸
 */
$G.onSave=function( needTip)
{
    if (needTip==undefined) needTip=true;
    //不允许保存时，直接提示并退出
    if ( ! $G.canSave)
    {
        if (needTip) alert("禁止本操作。");
        return;
    }
    
    
   //if( needTip) $.blockUI("正在保存"); 2008.01.31 当试卷很大时，保存时会提示脚本引进IE慢并提示是否继续，把这个去掉后，好象要好一点
    var answer=$G.getAnswerPaper( );
    var s=   JSON.toString( answer) ;
    
 
    
    $rpc( 'educ.exam.Exam', 'saveAnswerPaper' , 
                                   {
                                     'id'                           :   $('#id').val() , //考试的ID
                                     'firstLoginDate'   :   $G.firstLoginDate,   //最初进入考场时间
                                     'totalminute'          :   $G.paper.config.totalminute,   //可个应考时间
                                     'answer'                  :   s   //答卷内容
                                    },
                                   function( ret)
                                   {
                                         var  data=  JSON.parse(ret);
                                         
                  //                        if( needTip) $.unblockUI( );
 
                                         if ( data.success )
                                         {
                                            DomUtil.parentWindow().setInfo1("最后保存于：" +data.savedate);
                                            DomUtil.parentWindow().setInfo2("在" +data.leftminute+"分钟后考试结束");
                                            if ( data.leftminute<=0) DomUtil.parentWindow().setInfo2("考试已结束");
                                       
                                            $G.leftMinute= data.leftminute;
                                            $G.timeoutCheckTimes=0;
                                         
                                            if (needTip)
                                            {
                                                alert("保存成功" );
                     
                                            }
                                         }else
		                                 {
		                                    //Ext.MessageBox.alert("提示",data.message);)
		                                    alert ( data.message);
		                                }
                                  }         
           );                
     
     //没有放在RPC的回调函数里，是防止RPC失败引起不再自动保存
     clearTimeout($G.autoSaveFunctionId); //先清除延时器
     $G.autoSaveFunctionId = setTimeout( "$G.onSave(false)" , $G.autosaveafterminute*60*1000);     
     
      
     
}


/**
 * 交卷
 *   force:是不是强制提交，如果是，那么不需要交卷确认
 *   needSave:需不需要在交卷前先保存
 */
$G.onSubmit=function( force,needSave)
{
    
    if ( force==undefined) force=false;
    if ( needSave==undefined) needSave=true;
    
    
    if (!force)
    {
        if ( ! confirm("在定位栏中背景为绿色的题号是尚未做答的题目，请确信您对所有题目都做了回答。\n交卷后将不再允许修改，确信要交卷吗")) return;
    }
    
    //如果需要保存，那么先保存，使用同步保存
    if ( needSave)
    {
         $.blockUI("正在保存");
        var answer=$G.getAnswerPaper( );
        var s=   JSON.toString( answer) ;
        var ret=$rpc( 'educ.exam.Exam', 'saveAnswerPaper' , 
                                   {
                                     'id'                           :   $('#id').val() , //考试的ID
                                     'firstLoginDate'   :   $G.firstLoginDate,   //最初进入考场时间
                                     'totalminute'          :   $G.paper.config.totalminute,   //可个应考时间
                                     'answer'                  :   s   //答卷内容
                                    }
                                );
                                
       $.unblockUI( );
       if ( ! ret.success )
       {
            alert ( ret.message+"\r\n\r\n保存失败，无法交卷。");
            return ;
       }
       
    }
    
   
    
    $rpc( 'educ.exam.Exam', 'submitAnswerPaper' , 
			               {
			                 'id'                           :   $('#id').val()    //考试的ID
			                },
			               function( ret)
			               {
			                     var  data=  JSON.parse(ret);
                                 if ( data.success)
                                 {
                                     clearTimeout($G.autoSaveFunctionId); // 清除延时器
                                     clearInterval($G.timeoutCheckFunctionId) ; //停止到时检测
                                     
                                      
                                      //保存，提交按钮灰掉
                                      DomUtil.parentWindow().cb_save.disable( );
                                      DomUtil.parentWindow().cb_submit.disable( );
                                      
                                      if (gb_isSimulate) //测试交卷后，提示是否进行评分
                                      {  
                                            if ( confirm("交卷成功，现在进行评分吗?"))  DomUtil.parentWindow().location.href='edu_exameval_do.jsp?id='+ $('#id').val()  ;
                                      }else
                                      {
                                            alert('交卷成功。');   
                                      }
                                      
                                 }else
                                 {
                                     alert( data.message);
                                 }
                           }
              );
                                         
}

/**
 * 得到答卷纸 
 */
$G.getAnswerPaper=function( )
{
       var answerPaper={ };
       answerPaper.examid=$G.paper.examid; //是哪场考试
           　 
       var itemConfig=$G.paper.itemConfig;
         
       var   pw= DomUtil.parentWindow() ;
       
    for( var j=0;j< itemConfig.length;j++)
    {
        var item= itemConfig[j];
        var key= item.libraryid+"_"+item.itemid;
        var answer= AnswerUtil.buildAnswer(item,key);
   
        if ( answer!=null) //没有做答的题目不要记录
        {  
            var IT=item.itemtype.toUpperCase( );
            var answerInfo={ };
            answerInfo.itemtype=IT; //大写的类型
            answerInfo.libraryid=item.libraryid; // 记下来便于评卷
            answerInfo.itemid= item.itemid;
            answerInfo.standardanswer={ };
            //  {注070924}
            //为什么要整这么复杂，而不是直接使用answerInfo.standardanswer=item.answer
            //是因为在Exam.submitAnswerPaper中将standardanswer看作是记录答案对象的对象，而
            //不是直接的答案对象，这样做的意思是保证答卷纸中的useranswer , itemanswer 与试题库中的
            // answer 字段保存相同的格式，
            answerInfo.standardanswer.answer=item.answer; //把题目的标准答案也保存下来
       
            answerInfo.score= item.itemscore;
            answerInfo.answer = answer;
            answerPaper[key]=answerInfo;
            pw.setNavigateFlag( key , true);
        }else
        {
            pw.setNavigateFlag( key , false);
        }
    }
        
     return answerPaper;    
    
}

/**
 * 每做一道题后，同步显示题目导航按钮的状态
 */
$G.setNavigateFlag=function(key , flag)
{
    var   pw= DomUtil.parentWindow() ;
    pw.setNavigateFlag( key , flag);
    // 自动定位
    if ( $G.autoScroll) $G.jumpTo('headof_'+key); 
}

              
            



$G.jumpTo=function(a)
{
      $('#'+a).get(0).scrollIntoView();  
}


/**
 * 考试到时检测
 */
$G.timeoutCheck=function( )
{
    
    $G.timeoutCheckTimes++;
    var s=$G.leftMinute * 60 - $G.timeoutCheckFrequence * $G.timeoutCheckTimes ; //剩余多少秒
    var m=(s - s % 60)/60;
    s=s- m*60;
    DomUtil.parentWindow().setInfo2("剩余时间：" +m+'分'+s+'秒');
     
}


 

