


var $G= 
{
    tb:null, //工具栏
    cm:null, //列定义
    ds:null , // 数据来源
    grid: null  //界面
 }
    
 $G.init =function()
  {
	    //工具栏
	 this.tb = new Ext.Toolbar('toolbar');
     var tb=this.tb;
     tb.addButton( new Ext.Toolbar.Button({text: '新增课程',  handler: newCourse } )  );
     tb.addSeparator();
　tb.addButton( new Ext.Toolbar.Button({text: '删除课程',  handler: delCourse} )  );
     tb.addSeparator();
     tb.addButton( new Ext.Toolbar.Button({text: '修改课程',  handler: editCourse} )  );
     tb.addSeparator();    
     tb.addButton( new Ext.Toolbar.Button({text: '关联题库',  handler: linkLibrary} )  );
     tb.addSeparator();    
 
     tb.addButton( new Ext.Toolbar.Button({text: '课程子栏目检测',  handler: checkCourse} )  );
     tb.addSeparator();    
 
     AutoHeight.add('grid');
     
     //把编辑面板藏起来
     $('#course-dlg').css("display","none");
     
    // create the Data Store
    $G.ds = new Ext.data.Store(
    	{ 
    	proxy: new Ext.data.HttpProxy({url: 'zrpc.jsp' }),
         
        reader: new Ext.data.JsonReader(
        	{
	            root: 'courses',
	            totalProperty: 'totalCount',
	            id: 'id'
	        },
	        [
	            {name: 'name', mapping: 'name'},
	            {name: 'id', mapping: 'id', type:'int'},
	            {name: 'username', mapping: 'username' },
	            {name: 'showname', mapping: 'showname' },
	            {name: 'createdate', mapping: 'createdate' , type: 'date' ,dateFormat:'Y-m-d h:i:s.0'},
	            {name: 'summary', mapping: 'summary'}
	        ]),

        // turn on remote sorting
        remoteSort: false
    });

    var ds= $G.ds;
    
    // pluggable renders
    function renderName(value, p, record){
        return String.format('{0} <br><font color=#4848ff>{1}</font>', value, record.data['summary']);
    }
    function renderNamePlain(value){
        return String.format('{0}', value);
    }
    
    function renderRowNo(value,p,r)
    {
        var s=p.cellId;
        var p= s.lastIndexOf('-');
        s=s.substring(0, p);
        p= s.lastIndexOf('-');
        s=s.substring(p+1);
     
        var page=paging.field.dom.value  ;  //不能正确得到当前的页码
        
        
        s=parseInt( s , 10) +1 ; //+ (page -1)*paging.pageSize;
        return s;
        
    }
    
    function renderCreateDate(value, p, r)
    {
    	 if ( ! value) return ""; 
    	 
        return String.format('{0}', value.dateFormat('Y.m.d h:i'));
    }
    function renderUserName(value,p,record){
        return String.format('[{0}]{1}', value, record.data['showname']);
    }

    // the column model has information about grid columns
    // dataIndex maps the column to the specific data field in
    // the data store
    var cm = new Ext.grid.ColumnModel([
    {
            id: 'rowno', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "序号",
           dataIndex: '',
           width: 40,
           renderer: renderRowNo,
           sortable:false
    },
            {
           id: 'name', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "课程名称",
           dataIndex: 'name',
           width: 400,
           renderer: renderNamePlain,
           css: 'white-space:normal;' ,
           sortable:true
        },
        	{
        	id:'username',
           header: "创建人",
           dataIndex: 'username',
           width: 100,
           renderer:renderUserName,
           sortable:true
        },{
           id: 'createdate',
           header: "创建时间",
           dataIndex: 'createdate',
           width: 120,
           renderer: renderCreateDate,
           sortable:true
        }]);

    

    // create the editor grid
    $G.grid = new Ext.grid.Grid('grid', {
        ds: ds,
        cm: cm,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        enableColLock:false,
        loadMask: true
    });

    var grid= $G.grid;
   
    // render it
    grid.render();

    var gridFoot = grid.getView().getFooterPanel(true);

    // add a paging toolbar to the grid's footer
    var paging = new Ext.PagingToolbar(gridFoot, ds, {
        pageSize: 25,
        beforePageText:'页码',
        afterPageText : "/ {0}",
        displayInfo: true,
        displayMsg: '当前列出了第 {0} 到 {1}门课程，共 {2} 门课程',
        emptyMsg: "没有符合条件的课程"
    });
    // add the detailed view button
    paging.add('-', {
        pressed: false,
        enableToggle:true,
        text: '查看详情',
        
        toggleHandler: toggleDetails
    });

    // trigger the data store load
    
   
     
     //ds.load会触发此事件，因此可以在此事件中准备更多的参数
     ds.events['beforeload'].addListener( 
               function (scope , param)
		        {
                     // 分页工具条会拼装一个 {params:{  'start': 0, 'limit' : this.pageSize}}的参数，
                    //因此请扩展 param.params，加上更多的参数 
                     //在此前准备所需的RPC参数
                     var s=JSON.toString( param.params ); 
		             param.params.classname='educ.course.Course';  //rpc的类
                     param.params.methodname='getCourseList'; // rpc的方法
                     param.params.parameter = s;  //rpc的参数
                 
		        }
      );
 
     
    ds.load({ params:{  'start': 0, 'limit' : paging.pageSize }});

    function toggleDetails(btn, pressed){
        cm.getColumnById('name').renderer = pressed ? renderName : renderNamePlain;
        grid.getView().refresh();
    }
}  





//声明一个包，封装起相关的变量的函数
var dlg = function()
	
{
   // 包内的全局变量
    var dialog ;  
     
    return {
 
    hide : function()
    {
          dialog.hide( );
     },
     
     show:function()
     {
        
         dialog.show( );
     } ,
        
    showDialog : function(  initFunc , okFunc )
    {
            if(!dialog)
           { // lazy initialize the dialog and only create it once
                dialog = new Ext.BasicDialog("course-dlg", { 
                        autoTabs:false,
                        width:400,
                        height:200,
                        shadow:true,
                        minWidth:300,
                        minHeight:200,
                        proxyDrag: true
                });
                
              
                dialog.addKeyListener(27, dialog.hide, dialog);
                dialog.addButton('确定', okFunc, dialog) ;
                dialog.addButton('退出',  dialog.hide , dialog);
            }
            
             initFunc( );
             dialog.show( );
        }
    };
}();



//关联题库
var dlgLibrary = function()
    
{
   // 包内的全局变量
    var dialog ;  
     
    return {
 
    hide : function()
    {
          dialog.hide( );
     },
     
     show:function()
     {
        
         dialog.show( );
     } ,
        
    showDialog : function(  initFunc , okFunc )
    {
            if(!dialog)
           { // lazy initialize the dialog and only create it once
                dialog = new Ext.BasicDialog("library-dlg", { 
                        autoTabs:false,
                        width:400,
                        height:375,
                        shadow:true,
                        minWidth:300,
                        minHeight:200,
                        proxyDrag: true
                });
                
              
                dialog.addKeyListener(27, dialog.hide, dialog);
                dialog.addButton('确定', okFunc, dialog) ;
                dialog.addButton('退出',  dialog.hide , dialog);
            }
            
             initFunc( );
             dialog.show( );
        }
    };
}();


// using onDocumentReady instead of window.onload initializes the application
// when the DOM is ready, without waiting for images and other resources to load


$(document).ready( function()
{
        
    $G.init();
 
});

//Ext.onReady( $G.init );
//Ext.onReady(dlg.init, dlg, true);

 


function refreshWhole  ( )
{
    history.go(0);
}  
    
 /**
  * 新建一门课程
  */
function newCourse()
{
    
    dlg.showDialog( 
        function ()
        {
            $('#name').val('');
            $('#summary').val('');
        } , 
        
        function()
        {
            
            var name= $('#name').val( );
            var summary= $('#summary').val( );
           
            if ( name=='') return ;
 
            dlg.hide ( );
            $.blockUI("正在创建课程");
           $rpc( 'educ.course.Course', 'newCourse' , 
                                       { 'name'                       :  name, 
                                         'summary'        :   summary 
                                       } ,
                       function ( data)
                       {
                           var ret= JSON.parse( data);
                           
                           $.unblockUI( );
				            if ( ret.success)
				            {
				                Ext.MessageBox.alert("提示", "增加课程成功"); 
				                
				                refreshWhole( );
				                
				            }else
				            {
				                Ext.MessageBox.alert("提示", ret.message);
                                dlg.show ( );
				            }
                      });     
            
        }
      );
    
}

function linkLibrary()
{
       var record=$G.grid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一门课程"); 
            return ;
        }
        
        dlgLibrary.showDialog( 
             function()
            {
                $('#librarylistcontainer').get(0).src="edu_course_linkto_library.jsp?id="+record.data.id;
            } ,
            function()
            {
                  DomUtil.iframeWindow('librarylistcontainer').save();
                  dlgLibrary.hide();
            } ); 
}


function delCourse()
{
        var record=$G.grid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一门课程"); 
            return ;
        }
        
        Ext.MessageBox.confirm('请确认', '确信要删除吗?', 
           function( btn)
           { 
         
                if ( btn!='yes') return;
                
                 var ret = $rpc( 'educ.course.Course', 'deleteCourse' , 
                                           { 'id'                       :   record.data.id  
                                           }
                                       );
                if ( ret.success)
                {
                    $G.ds.remove(  record);  // 从界面上删除该记录
                }else
                {
                    Ext.MessageBox.alert("提示", ret.message);
                }
           });
        
}


function checkCourse()
{
        var record=$G.grid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一门课程"); 
            return ;
        }
        
        Ext.MessageBox.alert("提示", "课程在创建时会自动创建一组子栏目，当系统升级，或者其它原因导致某些子栏目不存在时，可以通过本检测自动创建它们。");
        
        ret = $rpc( 'educ.course.Course', 'checkCourse' , 
                                           { 'id'                       :   record.data.id  
                                           }
                                       );
        if ( ret.success)
        {
            Ext.MessageBox.alert("提示", "检测完成");
        }else
        {
            Ext.MessageBox.alert("提示", ret.message);
        }
           
}


function editCourse()
{
        var record=$G.grid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一门课程"); 
            return ;
        }
        
        dlg.showDialog( 
        function ()
        {
            $('#id').val( record.data.id );
            $('#name').val(record.data.name);
            //$('#name').get(0).focus( );
            $('#summary').val(record.data.summary);
        } , 
        
        function()
        {
            var id= $('#id').val( );
            var name= $('#name').val( );
            var summary= $('#summary').val( );
           
            if ( name=='') return ;
 
            dlg.hide ( );
            $.blockUI("正在修改课程");
           $rpc( 'educ.course.Course', 'editCourse' , 
                                       {'id':          id, 
                                         'name'                       :  name, 
                                         'summary'        :   summary 
                                       } ,
                       function ( data)
                       {
                           var ret= JSON.parse( data);
                           
                           $.unblockUI( );
                            if ( ret.success)
                            {
                                Ext.MessageBox.alert("提示", "修改成功"); 
                                 refreshWhole( );
                                
                            }else
                            {
                                Ext.MessageBox.alert("提示", ret.message);
                                dlg.show ( );
                            }
                      });     
            
        }
      );
        
}



        