/**
 *  * 本功能包提供如下功能：
 *
 *　　采集用户答案，把用户答案恢复到题目中 
 * 
 *　本功能包在如下地方使用：
 *
 * 　１　考试　　２　自由练习
 * 
 */
   
var AnswerUtil={ };

//pd' , 'dx', 'fx', 'tk', 'js', 'gc', 'mc', 'jd', 'ls', 'al'];

AnswerUtil.buildAnswer=function(item,key)
{
    var IT=item.itemtype.toUpperCase( );
 
    if( IT=='PD') return AnswerUtil.buildAnswer_PD(item,key);
    if( IT=='DX') return AnswerUtil.buildAnswer_DX(item,key);
    if( IT=='FX') return AnswerUtil.buildAnswer_FX(item,key);
    if( IT=='TK') return AnswerUtil.buildAnswer_TK(item,key);  //填空题比较特别
    if( IT=='GC') return AnswerUtil.buildAnswer_GC(item,key);//改错题比较特别
    if( IT=='JS') return AnswerUtil.buildAnswer_JS(item,key);//计算题比较特别
    if( IT=='JD' || IT=='MC' || IT=='LS' || IT=='AL'  ) return AnswerUtil.buildAnswer_COMMON(item,key);
    
    
    
    alert ("buildAnswer不支持的类型"+IT);
    return null; 
      
}


AnswerUtil.buildAnswer_FX=function(item,key)
{
    
       var ret={ };
       ret.answer=[ ];
       var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            if ( objs[i].checked) ret.answer[ ret.answer.length]= objs[i].value;
        }
        
        if ( ret.answer.length==0) return null;
        return ret;
    
}




AnswerUtil.buildAnswer_DX=function(item,key)
{
        var answer=undefined;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            if ( objs[i].checked)  answer= objs[i].value;
        }
        
        if ( answer!=undefined) return {answer:answer};
        return null;
}
　


AnswerUtil.buildAnswer_PD=function(item,key)
{
         
        var answer=undefined;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            if ( objs[i].checked)  answer= objs[i].value;
        }
        
        if ( answer!=undefined) return {answer:answer};
       
        return null;
}


/**
 * 改错题
 */
AnswerUtil.buildAnswer_GC=function(item,key)
{
         
        var answer=undefined;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            if ( objs[i].checked)  answer= objs[i].value;
        }
        
        
        if ( answer==undefined) return null;
       
        var reason= AnswerUtil.getObject ( key+"_reason").value;
        
        if ( reason.length==0) return null;
        
        return {answer : {answer:answer , reason: reason} };
        
}

/**
 * 填空题取答案
 */
AnswerUtil.buildAnswer_TK=function(item,key)
{
       var ret={ };
       ret.answer=[ ];
        var objs= $('#'+ key+'_body  input');
        var notNullCount=0; 
        for( var i=0;i<objs.length;i++)
        {
            var s= objs[i].value;
            if (s!='') notNullCount=notNullCount+1;
             ret.answer[ ret.answer.length]= s;
        }
        
        if ( ret.answer.length==0 || notNullCount==0 ) return null;
        //alert ( JSON.toString( ret));
        return ret;
        
}


/**
 *计算题取答案
 */
AnswerUtil.buildAnswer_JS=function(item,key)
{
       var ret={ };
       ret.result=[ ];
        var objs= $('#'+ key+'_body  input');
       for( var i=0;i<objs.length;i++)
        {
            var s= objs[i].value;
             ret.result[ ret.result.length]= s;
        }
        
        
        var obj =AnswerUtil.getObject ( key);
        ret.answer = obj.value;
        if ( ret.answer=='') return null;  
        return ret;
        
}


AnswerUtil.buildAnswer_COMMON=function(item,key)
{
         
        var answer=undefined;
        var obj =AnswerUtil.getObject ( key);
        answer= obj.value;
        if ( answer.length==0) return null; 
        if ( answer!=undefined) return {answer:answer};
       
        return null;
}


AnswerUtil.getObjects=function(name) 
{
    return document.getElementsByName(name); 
}

AnswerUtil.getObject=function(name) 
{
    return document.getElementById(name); 
}






/**
 * 调取答案，如果增加了题型，请修改本函数
 */
AnswerUtil.restoreAnswer=function( key , answer) 
{
    var IT=answer.itemtype;
    var  useranswer= answer.answer;
    if ( IT=='PD')  return AnswerUtil.restoreAnswer_PD( key , useranswer);
    if ( IT=='DX')  return AnswerUtil.restoreAnswer_DX( key , useranswer);
    if ( IT=='FX')  return AnswerUtil.restoreAnswer_FX( key , useranswer);
    if ( IT=='GC')  return AnswerUtil.restoreAnswer_GC( key , useranswer);
    if ( IT=='TK')  return AnswerUtil.restoreAnswer_TK( key , useranswer);
    if ( IT=='JS')  return AnswerUtil.restoreAnswer_JS( key , useranswer);
    
    if( IT=='JD' || IT=='MC' || IT=='LS' || IT=='AL'  )  return AnswerUtil.restoreAnswer_COMMON( key , useranswer);
    
    alert ("restoreAnswer不支持的类型"+IT);
    return false;
}

/**
 * 判断题恢复答案
 */
AnswerUtil.restoreAnswer_PD=function( key , answer)
{
        var val=answer.answer;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            objs[i].checked=false;
            if (   val == objs[i].value )  objs[i].checked=true; 
        }
         
        return true;
}

/**
 * 改错题
 */
AnswerUtil.restoreAnswer_GC=function( key , answer)
{
        var val=answer.answer.answer;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            objs[i].checked=false;
            if (   val == objs[i].value )  objs[i].checked=true; 
        }
        
        AnswerUtil.getObject( key+"_reason").innerHTML=answer.answer.reason;
        
        return true;
}

/**
 * 简答题恢复答案
 */
AnswerUtil.restoreAnswer_COMMON=function( key , answer)
{
        var val=answer.answer ;
        var obj=AnswerUtil.getObject( key);
       obj.innerHTML=val; 
         
        return true;
}

/**
 * 单选题恢复答案
 */
AnswerUtil.restoreAnswer_DX=function( key , answer)
{
        var val=answer.answer;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            objs[i].checked=false;
            if (   val == objs[i].value )  objs[i].checked=true; 
        }
         
        return true;
    
}

/**
 * 多选题恢复答案
 */
AnswerUtil.restoreAnswer_FX=function( key , answer)
{
        var vals=answer.answer;
        var objs=AnswerUtil.getObjects( key);
        for( var i=0;i<objs.length;i++)
        {
            objs[i].checked=false;
            var v=objs[i].value;
            for( var j=0;j<vals.length;j++)
            {
                if (   vals[j] == v )  objs[i].checked=true;
            }
        }
         
        return true;
    
}

/**
 * 填空题
 */
AnswerUtil.restoreAnswer_TK=function( key , answer)
{
        var vals=answer.answer;
        var objs= $('#'+ key+'_body  input');
        for( var i=0;i<objs.length;i++)
        {
                  
            if( i<vals.length) objs[i].value=vals[i]; 
        }
         
        return true;
    
}


/**
 * 演算题
 */
AnswerUtil.restoreAnswer_JS=function( key , answer)
{
        var vals=answer.result;
        if ( vals==undefined) vals=[];
        var objs= $('#'+ key+'_body  input');
        for( var i=0;i<objs.length;i++)
        {
            if( i<vals.length) objs[i].value=vals[i]; 
        }
        //演算过程
        var obj =AnswerUtil.getObject ( key);
        var s=answer.answer;
        if ( s==undefined) s="";
 
        obj.value =s;
         
        return true;
    
}


AnswerUtil.buildStandardAnswerHTML=function( item  , answer )
{
    var IT= item.itemtype;
    if ( IT=='PD')  return AnswerUtil.buildStandardAnswerHTML_PD( item, answer);
    if ( IT=='DX')  return AnswerUtil.buildStandardAnswerHTML_DX( item, answer);
    if ( IT=='FX')  return AnswerUtil.buildStandardAnswerHTML_FX( item, answer);
    if ( IT=='GC')  return AnswerUtil.buildStandardAnswerHTML_GC( item, answer);
    if ( IT=='TK')  return AnswerUtil.buildStandardAnswerHTML_TK( item, answer);
    if ( IT=='JS')  return AnswerUtil.buildStandardAnswerHTML_JS( item, answer);
    
    
    if( IT=='JD' ||IT=='MC' || IT=='LS' || IT=='AL'  )  return AnswerUtil.buildStandardAnswerHTML_COMMON( item, answer);
    return  ("buildStandardAnswerHTML尚未支持"+IT);
      
}


AnswerUtil.buildStandardAnswerHTML_PD=function( item , answer )
{
	answer=  ''+answer=='true';
	 
    var ret= "<input type=radio checked>"+(answer?"正确":"错误");
 
    return ret;
      
}

AnswerUtil.buildStandardAnswerHTML_GC=function( item , answer )
{
    
     return "<input type=radio checked>"+( ''+answer.answer=='true'?"正确":"错误")+"&nbsp;&nbsp;依据是："+answer.reason;
 
}


AnswerUtil.buildStandardAnswerHTML_DX=function( item  , answer )
{
 
    var s= answer ; 
    var candidate= item.candidate;
    for( var i=0;i< candidate.length;i++ )
    {
        var c= candidate[i];
        if ( s== c.candidateId)  return  "<font color=red>"+String.fromCharCode( c.no+64)+"</font>"; 
    }
}
    
AnswerUtil.buildStandardAnswerHTML_COMMON=function( item  , answer )
{
 
    var s= answer ; 
    return  "<font color=red>"+answer+"</font>"; 
     
}
    
  
AnswerUtil.buildStandardAnswerHTML_FX=function( item  , answer )
{
    var ret="";
    var s= answer; 
    var candidate= item.candidate;
    for( var i=0;i< candidate.length;i++ )
    {
        var c= candidate[i];
        for( var j=0;j<s.length;j++)
        {
            if ( s[j]== c.candidateId)   ret=ret+" "+  String.fromCharCode( c.no+64);
        }
    }
    return  "<font color=red>"+ret+"</font>";
}

/**
 * 填空题
 */
AnswerUtil.buildStandardAnswerHTML_TK=function( item  , answer )
{
    var html="";
    if ( answer.tk !=undefined)
    {
      for( var i=0;i< answer.tk.length; i++)
      {
          html=html+'<div>第'+(i+1)+"个空："+ answer.tk[i]+"</div>";　
      }
    
    
        //直接在题目上显示答案
        var key= item.libraryid+"_"+item.itemid;
        var objs= $('#'+ key+'_body  input');
        for( var i=0;i<objs.length;i++)
        {
                  
            if( i<answer.tk[i].length) objs[i].title="标准答案是："+answer.tk[i]; 
        }
    }    
    
    return    "<div>"+ html+"</div>";
}

/**
 * 演算题 , 题目中的答案仅有演算过程，结构是：{answer:'....' }
 */
AnswerUtil.buildStandardAnswerHTML_JS=function( item  , answer )
{
    var s= answer ;
    if ( s==undefined) s={};
    if ( typeof(s.reason)=="undefined") s.reason="";  //当没有设置答案时，系统会构造一个空的Object , 所以这里要判断一下
  //为什么不直接构造一个字符串呢，因为其它类型的题目的答案可能是一个组合对象。　
    return AnswerUtil.buildStandardAnswerHTML_TK( item, answer)+ "<div style='color:green;'>演算过程是：</div>"+s.reason;
}

