// 录音

var AudioRecord = function(param)
{

	param=param||{};
	
	var progress_interval = 0;
	var recorded_times = 0;
	var progress_step = 200;
	var record_modal = 0;

 

	// 录音进度
	var recordPanel = '<div  id=record_state_container style="padding-bottom:10px;height:48px; -webkit-user-select:none;-webkit-user-callout:none;" class=select-nothing >'
			+ '<img src="image/touch.png" id=record_touch style="width:64px;height:64px;">'
			+ '	<div  id=record_progress_container   style="display:none;padding-left:30px; padding-right:30px; -webkit-user-select:none;-webkit-user-callout:none;">'
			+ '	<div class="player select-nothing"  >'
			+ '				<div class="progress select-nothing">'
			+ '					<div class="slider select-nothing">'
			+ '						<div class="loaded select-nothing"></div>'
			+ '						<div class="pace select-nothing"></div>'
			+ '					</div>'
			+ '					<div class="timer select-nothing"></div>' + '				</div>' + '		</div>' + '	</div>' + '</div>';

	this.record = function()
	{
		AudioRecord.record_modal = $.modal({	title : '<table border=0 cellspacing=0 cellpadding=0><tr><td width="99%"></td>'+
						'<td align="right"><img id=closeRecordPanel '+
						' onclick="  $.closeModal(AudioRecord.record_modal);" src="image/close48.png" width="24"></td></tr></table>',
					text : recordPanel,
					buttons : [ {
						text : '点击开始录音(勿需按住)',
						id:'cb_wx_record',
						bold : false,
						close : false,
						// onTouchStart : record_start ,
						// onTouchEnd : record_end
						onClick : record_start
					}

					]
				});
		//自动开始
		if( param.autoStart)   record_start( AudioRecord.record_modal  );
			 
		
	};

	var isRecording = false;

	var record_start = function(modal, e)
	{
		
		if (isRecording)
		{
			record_end(modal, e);
			return;
		}

		wx.startRecord({
			success : function()
			{
				$('#cb_wx_record').text("停止录音");
			 
				isRecording = true;
				$.cookie("isRecording", "true");

				$('#record_touch').css("display", "none");
				$('#record_progress_container').css("display", "");

				$('#closeRecordPanel').css("visibility","hidden" );
				

				recorded_times = 0;
				progress_interval = setInterval(setRecordingProgress, progress_step);

			},

			fail : function()
			{

			},
			cancel : function()
			{
				alert('用户拒绝授权录音');
			}

		});

	};

	var setRecordingProgress = function()
	{
		recorded_times += progress_step;
		if (recorded_times > 60000)
			recorded_times = 60000;
		var ratio = recorded_times / 60000 * 100;
		$('.timer').html("还剩" + (60 - parseInt(recorded_times / 1000)) + "秒");
		$('.progress .pace').css('width', ratio + '%');
		$('.progress .slider a').css('left', ratio + '%');
	};

	var record_end = function(modal, e)
	{

		if (!isRecording)
			return;
		isRecording = false;
		$.cookie("isRecording", null);

		$.closeModal(modal);

		// 终止进度条更新
		clearInterval(progress_interval);
		// 停止录音
		wx
				.stopRecord({
					success : function(res)
					{

						if (recorded_times < 2000)
						{
							$.alert("录音时间如果小于2秒将被忽略");
							return;
						}

						localId = res.localId;
						$.showIndicator();
						wx
								.uploadVoice({
									localId : localId,
									isShowProgressTips : 1, // 默认为1，显示进度提示
									success : function(res)
									{
										$.hideIndicator();
										var serverId = res.serverId; // 返回音频的服务器端ID
										$rpc(
												'weixin.WX_RPC',
												'downloadAudioFromWX',
												{
													serverId : serverId
												},
												function(ret)
												{

													var data = JSON.parse(ret);
													if (!data.success)
													{
														$.alert("错误：" + data.message);
														return;
													}
													
													AudioRecord.addAudioResult (localId, data.urlPath , data.duraing);

												});

									}

								});

					}
				});

	};

	
	
	// 下面的不生效，暂时留着
	document.body.onbeforeunload = window.onbeforeunload = function()
	{
		if (isRecording)
			wx.stopRecord({});
	};

	return this;
};


/**
 * 静态函数
 */

AudioRecord.addAudioResult=function(localId,urlPath , duraing)
{
	var id = new Date().getTime();
	var html = ' <li  id=answer'
			+ id
			+ '  class=record_result_container >'
			+ '<table border=0 cellspaceing=0 cellpading=0 width="">'
			+ '<tr>'
			+ '<td width="150"><div '
			+ ' class=redbutton><div class=buttonTextWithIconLeft   id="playProgressContainer'
			+ id
			+ '">'
			+ '<input type="hidden" class=answer_audio_file value="'
			+ urlPath
			+ '"  title="'
			+ duraing
			+ '">'
			+ '<div onclick="AudioPlay.play(\'playProgressContainer'
			+ id
			+ '\', \'qa_listen_question?type=file&file='
			+ urlPath
			+ '\','
			+ duraing
			+ ');">试听&nbsp;&nbsp;['
			+ duraing
			+ '"]</div></div></div>'
			+ '</td>'

			+ '<td align="right"><a   id="removeAudio'
			+ id
			+ '" href="javascript:AudioRecord.deleteRecord(\''
			+ id
			+ '\');" class="external button    color-green button-round " style="width:56px;line-height:32px;height:32px;">删除</a>'
			+ '</td></tr></table>' + '</div></li>';

	//console.log(html);

	$('#answer-list').css("display", "");
	$('#answer-list ul').append(html);

	if (window['onRecordOver'])
		onRecordOver(localId, 'answer' + id); // 第一个参数是localId
	// ,
	// 第二个是DOM的id

	 
	var results = $('.answer_audio_file');
 
	if (results.length >0)
	{
		$('.content').animate({
			scrollTop :  $('.content')[0].scrollTop + $( '#answer-list').position().top-10
		}, 1000);
	}
};

AudioRecord.record = function(param)
{
	if ($.cookie("isRecording") == 'true')
	{

		wx.stopRecord({});// 不能依赖这个closeRecord中的回调，回调可能不执行，直接延时后执行
		$.cookie("isRecording", null);

		showInfo('正在初始化，准备录音...', 2000, function()
		{
			var record = new AudioRecord(param);
			record.record();
		});

		return;

	}

	var record = new AudioRecord(param);
	record.record();
};

AudioRecord.deleteRecord = function(id)
{

	$.confirm("确信要清除录音吗 ?", function()
	{

		var question_audio_file = $('#answer' + id + ' .answer_audio_file').val();

		$rpc('weixin.WX_RPC', 'deleteTempAudio', {
			file : question_audio_file
		}, function(ret)
		{
			$('#answer' + id).remove();
			if ($('.record_result_container').length == 0)
			{
				$('#answer-list').css("display", "none");
			}
			 
			if (window['onRecordRemove']) onRecordRemove(  ($('.record_result_container').length == 0)); // 回调

		});

	});

};

AudioRecord.getRecordResult = function()
{

	var results = $('.answer_audio_file');

	var ret = [];
	for (var i = 0; i < results.length; i++)
	{

		ret.push({
			file : $(results[i]).val(),
			length : $(results[i]).attr("title")
		});
	}
	// alert( JSON2.toString(ret));
	return ret;

};
