var AudioPlay = function(domID, duration_ , justTry_)
{

	var id = domID;

	var justTry= justTry_;
	var audio = null;
	var duration = duration_ ;
	var isPlaying = false;
	var playCounts = 0;
	var autoplay = false;
	var volume = localStorage.volume || 1; // 初始音量
	var handle = 0;

	var handle_timeout = 0;
	this.record_modal=0;

	this.restoreUI = function()
	{
		if (window['lastAudioPlayDomId'])
		{

			window['lastAudioPlayer'].pause();
			var restoreHTML = window['lastAudioPlayDomRestoreHTML'];
			var lastID = window['lastAudioPlayDomId'];
			$('#' + lastID).html(restoreHTML);
			delete window['AudioPlayer-' + lastID]; // 删除domID到autioplay的映射
			delete window['lastAudioPlayDomId'];

		}
	};

	this.playNext=function( )
	{
		 
			var currentContainer=$('#'+id);
			var objs=$('.mp3PlayButtonContainer');
			if( objs.length>1)
			{
				for(var i=0; i<objs.length;i++)
				{
					obj=$(objs[i]);
					// alert( obj.attr("id")+" / "+ currentContainer.attr("id"));
					if( obj.attr("id")==currentContainer.attr("id"))
						{
						   if( i+1< objs.length )
							   {
							   		var nextObj= $(objs[i+1]);
							   		
							   		if(! nextObj.isOnScreen(0,45)) //下面有工具栏，所以要扣除
							   			{ 
							   			$('.page-content').animate({
							   				scrollTop :  nextObj.position().top-30
							   			}, 1000);
							   			}
							   	       //如果不这样卡一下，那么在手机上，会播放失败，用setTimeout也不行
								   		$.confirm("继续下一段播放吗?" ,function()
												{  
								   					nextObj.find(".mp3PlayButton").click();
												});
							   			 
							   		return;
							   }else
								   {
								   return
								   }
						}
				}
			}
		 
		
	};
	
	// 恢复UI
	this.restoreUI();

	// 记下当前正在播放的容器对象ID及它的innerHTML,用于恢复
	window['lastAudioPlayDomId'] = domID;
	window['lastAudioPlayDomRestoreHTML'] = $('#' + id).html();
	window['lastAudioPlayer'] = this;

	window['AudioPlayer-' + id] = this;

	var buttonRight= $('#'+id).is('.buttonTextWithIconLeft');
	$('#' + id)
			.html(
					'<div class="player" >'
							+ '<table  border=0 cellspacein=0 cellpadding=0 width="100%" height="100%">'
							+'  <tr>'
							+ (buttonRight?"":'<td  id="popUpAudioPlayContainer"><img  id="popUpAudioPlay" src="image/selecProgress.png"  style="width:32px;height:32px;"></td>')
							+'<td class="progressContainer" width="90%">'
							+ '	<div class="progress">'
							+ '		<div class="slider  ">'
							+ '			<div class="loaded"></div>'
							+ '			<div class="pace"></div>'
							+ '		</div>'
							+ '	</div>'
							+ '	</td>'
							+ (buttonRight?'<td  id="popUpAudioPlayContainer"><img  id="popUpAudioPlay" src="image/selecProgress.png"  style="width:32px;height:32px;"></td>':'')
							+'</tr></table>'
							+ '</div>');

	$('#' + id + ' .progressContainer').bind('click', {
		player : this
	}, function(event)
	{
		var player = event.data.player;
		player.isPlaying() ? player.pause() : player.play();
	});

	if( duration<20)
	{
		$('#' + id + ' #popUpAudioPlayContainer').html("&nbsp;&nbsp;"); 
		$('#' + id + ' #popUpAudioPlay').css("display","none"); 
	}
	
	$('#' + id + ' #popUpAudioPlay')
			.bind(
					'click',
					{
						player : this
					},
					function(event)
					{
						var player = event.data.player;

						var ratio = (player.getAudio().currentTime / player.getDuration() * 100).toFixed(0);

						var html = '<table border=0 width="100%"><tr><td width="99%"><div  id=popUpAudioPlayInfo class=introduce></div><div class="range-slider"><input id="popUpAudioPlayRange"   type="range" min="0" max="100" value="'
								+ ratio
								+ '" step="0.1"/></div></td>'
								+ '<td><img   id=popUpAudioPlayClose  src="image/close48.png" width="24"></td></tr></table>';
						player.record_modal = $.modal({
							title : html,
							text : '',
							buttons : []
						});

						$('#popUpAudioPlayClose').bind('click', {
							player : player
						}, function(event)
						{
							var player = event.data.player;
							$.closeModal( player.record_modal);
						});
						
						$('#popUpAudioPlayRange').bind('input', {
							player : player
						}, function(event)
						{
							var player = event.data.player;
							var v = $(this).val();

							v = player.getDuration() * v * 1.0 / 100.0;
							$('#popUpAudioPlayInfo').html( v+'" / '+ player.getDuraing()+'"');
							player.setCurrentTime(v, false);

						});

						$('#popUpAudioPlayRange').bind('mouseup', {
							player : player
						}, function(event)
						{
							var player = event.data.player;
							var v = $(this).val();
							v = player.getDuration() * v * 1.0 / 100.0;
							
							player.setCurrentTime(v, true);
						});
						
						$('#popUpAudioPlayRange').bind('touchend', {
							player : player
						}, function(event)
						{
							var player = event.data.player;
							var v = $(this).val();
							v = player.getDuration() * v * 1.0 / 100.0;
							player.setCurrentTime(v, true);
						});
						
						
					});

	$('#' + id + ' .progressContainer').bind('taphold', {
		player : this
	}, function(event)
	{
		//alert("hold");
	});

	
	this.getDomId=function()
	{
		return id;
	};
	
	this.getDuration = function()
	{
		return  duration;
	};
	
	this.setDuration=function(v)
	{
		if (duration==undefined &&  !isNaN(v) &&v != Infinity) duration=v;
		
	};

	this.getAudio = function()
	{
		return audio;
	};

	/**
	 * 开放接口：播放
	 */
	this.play = function()
	{
	 
		if( justTry)
		{ 
			var ratio = audio.currentTime / duration * 100;
	
		  	 
			if( ratio>30 ||  audio.currentTime>10)
			{
				tryListenOver();
			    return 
			}
		}
		
		
		audio.play();
	 
		
		$('#' + id + ' .playback').addClass('playing');
		$('#' + id + ' .pace').css('background', '#0f0');
 
		handle = setInterval(updateProgress, 500);
 
		isPlaying = true;
	};

	/**
	 * 开放接口：暂停
	 */
	this.pause = function()
	{
		clearInterval(handle);

		$('#' + id + ' .playback').removeClass('playing');
		$('#' + id + ' .pace').css('background', '#e0e0e0');
		isPlaying = false;
		audio.pause();
	};

	this.isPlaying = function()
	{
		return isPlaying;
	};

	/**
	 * 开放接口：设置播放进度
	 */
	this.setCurrentTime = function(value, reallySet)
	{
		clearInterval(handle);
		$setProgress(value, false);

		if (reallySet)
		{

			audio.currentTime = value;
			handle = setInterval(updateProgress, 500);
		}
	};

	var $setProgress = function(value, popSync)
	{
		
		if( duration==undefined) return;
		
		if (popSync == undefined)
			popSync = true;

		var currentSec = parseInt(value % 60) < 10 ? '0' + parseInt(value % 60) : parseInt(value % 60);
		var ratio = value / duration * 100;

		if (ratio > 100)
			ratio = 100; // 因为duration 可能不是很准，如果是传入的，那么它可能省掉了小数

		 
		
		if ($('#' + id + ' .timer'))
			$('#' + id + ' .timer').html(parseInt(value / 60) + ':' + currentSec);
		$('#' + id + ' .progress .pace').css('width', ratio + '%');
		$('#' + id + ' .progress .slider a').css('left', ratio + '%');

		if (popSync)
		{
			var popAudio = $('#popUpAudioPlayRange');
			if (popAudio)
				popAudio.val(ratio);
		}
	};

	/**
	 * 私有函数：更新播放进度
	 */
	var updateProgress = function()
	{
		$setProgress(audio.currentTime);
		 
		if( justTry)
		{ 
			var ratio = audio.currentTime / duration * 100;
			if( ratio>30 || audio.currentTime>10)
			{
				tryListenOver();
			}
		}
		
	};

	 //试听结束
	var tryListenOver=function()
	{
		var player=window['lastAudioPlayer'];
		player.pause();

		// 恢复UI
		$.closeModal( player.record_modal);
		player.restoreUI();
		
		showInfo( "试听结束" , 1000,   function(){ player.playNext();}   );
	};
 
 
  

	
	// 加载音乐
	this.loadMusic = function(mp3)
	{
		var newaudio = $('<audio class=audioPlayer>').html('<source src="' + mp3 + '">').appendTo('#' + id);

		audio = newaudio[0];

	 
	 
		
		$(audio).bind('progress', {player : this}, function(event)
		{
			try
			{ 
			var player=event.data.player;
			var id=player.getDomId();
			
			var timeRanges = this.buffered;
			 // 获取以缓存的时间
			
			var timeBuffered = timeRanges.end(timeRanges.length - 1);
			 // 获取缓存进度，值为0到1
			var bufferPercent = timeBuffered / player.getDuration()*100;
			if(bufferPercent>100 ) bufferPercent=100;
			 
			$('#' + id + ' .progress .loaded').css('width', bufferPercent+'%');
			}catch(err)
			{
				// alert ( JSON2.toString( err));
			}
		});
		
		
		 
		
		$(audio).bind('canplay', {player : this}, function(event)
		{
		 
			var player=event.data.player;
			
			$('#' + player.getDomId() + ' .loaded').css('background-image', 'url()'); // 去掉加载中的3个点
		 
		 
		});
		 
		 
		$(audio).bind('ended', {player : this}, function(event)
				{
				 
					var player=event.data.player;
					player.pause();
					// 恢复UI
					$.closeModal( player.record_modal);
					player.restoreUI();
					player.playNext( );
					
				}
		);
 
		 
		$(audio).bind('loadedmetadata', {player : this}, function(event)
		{
			var player=event.data.player;
			player.setDuration( this.duration);
			$('#' + player.getDomId() + ' .loaded').css('background-image', 'url()'); // 去掉加载中的3个点
		}
		);
  
		this.play();
		 
	};

	return this;
};

/**
 * 静态函数
 */
AudioPlay.play = function(domid, mp3URL, duration, justTry)
{
	
	 
	var audio = new AudioPlay(domid, duration,justTry);
 
	audio.loadMusic(mp3URL);
	 
};
