var tabs = [];
var activeTabId = "";


$(document).bind("touchmove", function (e) {
    e.preventDefault();
});


function addTab(img, title, url, id) {
    if (tabs.length > ci_maxTabCount) {
        alert("打开了太多的标签页，请先关闭一些标签页面");
        return;
    }

    for (var i = 0; i < tabs.length; i++) {
        if (tabs[i].url == url) {
            // if( confirm(title+"已经打开，激活该标签页请点击是，再次打开它请点击否?"))
            {
                activeTab(tabs[i].id);
                return;
            }
            break;
        }

    }
    if (!id) id = newGuid();
    var one = {img: img, title: title, url: url, id: id};
    tabs.push(one);

    if (url != '') {
        var iframe = document.createElement("iframe");
        iframe.id = "iframe_" + id;
        iframe.style.display = "none";
        iframe.src = url;
        iframe.frameBorder = 0;
        iframe.style.border = "0 ";
        iframe.style.width = "100%";
        iframe.style.height = "100%";

        $E('iframeContainer').appendChild(iframe);

    }
    rebuildTabHTML();
    activeTab(id);

}

//刷新 页面
function refreshTab(id) {
    var iframe = $('#iframe_' + id)[0];
    var src = iframe.src;
    iframe.src = '';
    iframe.src = src;


}

function mouseOver(td) {
    var id = td.id;
    var obj = $E(id + '_close');
    if (obj) obj.style.visibility = "visible";

    obj = $E(id + '_favorite');
    if (obj) obj.style.visibility = "visible";

}

function mouseOut(td) {
    var id = td.id;
    var obj = $E(id + '_close');
    if (obj) obj.style.visibility = "hidden";
    obj = $E(id + '_favorite');
    if (obj) obj.style.visibility = "hidden";

}

var sendMessageToFrame = function (frameid, msg) {
    var f = window.frames[frameid];
    if (f.postMessage) {
        f.postMessage(JSON.stringify(msg), '*');
    } else {
        f.contentWindow.postMessage(JSON.stringify(msg), '*');
    }
}

function activeTab(id) {

    //if (id == activeTabId) return; 不能这样直接返回，因为它可能不处于可见区

    var lastTab = $E(activeTabId);
    if (lastTab) {
        $(lastTab).addClass('normalTab');
        $(lastTab).removeClass('activeTab');

        $E("iframe_" + activeTabId).style.display = "none";
        sendMessageToFrame("iframe_" + activeTabId, {action: 'pageDeactive'}, '*');
    }

    $('#' + id).removeClass('normalTab');
    $('#' + id).addClass('activeTab');

    activeTabId = id;
    $E("iframe_" + activeTabId).style.display = "";


    //注意：当tab是新加的，此时pageActive不会被执行，可能在原因是页面还没有加载好
    //不过这样也好，打开时，执行 formOpen ,再激活时执行 pageActive

    sendMessageToFrame("iframe_" + activeTabId, {action: 'pageActive'}, '*');


    //放到屏幕可见区域

    var index = parseInt($('#' + id).attr("index"));

    if (index < gi_firstTabIndex) {
        gi_firstTabIndex = index;
        moveTab();
    }

    if (index > gi_canScrollToTabIndex) {
        gi_firstTabIndex = gi_canScrollToTabIndex;
        moveTab();
    }

    //如果在 gi_firstTabIndex 与 gi_canScrollToTabIndex之间，就要判断一下，是不是在当前可见区，如果在，直接返回，如果不在，卷到它这里
    var x1 = $('#tabContainer  .TAB' + gi_firstTabIndex).position().left;
    //得到 tab容器的宽度
    var totalWidth = $('#tabContainerMainArea').width();
    if ($('#tabContainer  .TAB' + index).position().left + $('#tabContainer  .TAB' + index).width() - x1 > totalWidth) {
        gi_firstTabIndex = Math.min(index, gi_canScrollToTabIndex); //把它设置为第一个可见Tab，确保它可见

        moveTab();

    }


    resizeMe();

}

/**
 * 弹出显示
 * @param id
 */
function popup(id) {

    var iframe = document.getElementById("iframe_" + id);
    var url = iframe.src;
    var a = parent.$('#openInNewWindow')[0];
    a.href = url;
    a.click();

}

function resizeMe() {

    // setTimeout( resizeFrame  ,500);

    //  setTimeout( resizeFrame  ,1500);

}

function resizeFrame() {
    $E("iframe_" + activeTabId).style.height = "99%";
    $E("iframe_" + activeTabId).style.height = "100%";

}

function favoriteTab(img) {

    var id = img.id;
    id = id.substring(0, id.length - 9);

    $confirm("提示", "确信要将本页加入工作台收藏夹吗", function () {
        $rpc("", "workspace.WorkSpace", "addWorkspaceToFavorite",
            {workspaceid: id},
            function (retValue) {

                var ret = JSON.parse(retValue);
                if (ret.success) {
                    toastr.success("成功加入收藏夹");
                } else {
                    toastr.error(ret.message);
                }

            });

    });


}

function closeTab(img) {
    var id = img.id;
    id = id.substring(0, id.length - 6);

    var deletedIndex;
    for (var i = 0; i < tabs.length; i++) {
        if (tabs[i].id == id) {
            sendMessageToFrame("iframe_" + id, {action: 'pageClose'}, '*');
            tabs.removeAt(i);

            var iframe = $E("iframe_" + id);
            iframe.src = "";
            $E('iframeContainer').removeChild(iframe);
            deletedIndex = i;

            break;
        }
    }


    rebuildTabHTML();
    if (id == activeTabId) {
        activeTab(tabs[Math.max(0, deletedIndex - 1)].id);
    } else {
        activeTab(activeTabId);
    }

}

function rebuildTabHTML() {
    var html = [];
    for (var i = 0; i < tabs.length; i++) {
        var tab = tabs[i];
        tab.index = i; //加一个序号
        html.push(`<span  id="${tab.id}"   index="${i}" onmouseover="mouseOver(this) " 
                                                onmouseout="mouseOut(this) "
                                                class=" TAB  TAB${i}  normalTab" >&nbsp;`);

        if(tab.img.startsWith('img:')) //定制的小图标
        {
            let img=tab.img.substring(4);
            html.push(`<img  id="${tab.id}_refresh" class="mainFrameMenuItemImg"
                                                      src="${img}"    title="刷新本页" 
                                                    onmouseenter="this.src='img/refresh.png'; "
                                                    onmouseout="this.src='${img}'; "
                                                    onclick="refreshTab('${tab.id}');"           
                                                >&nbsp;`);
        }else //字符图标
        {
            html.push(`<i  id="${tab.id}_refresh" class="asbutton fa fa-fw ${tab.img}    "  title="刷新本页" 
                                                    onmouseenter="this.className='asbutton fa  fa-fw fa-refresh '; "
                                                    onmouseout="this.className='asbutton  fa fa-fw ${tab.img} '; "
                                                    onclick="refreshTab('${tab.id}');"           
                                                ></i>`);
        }

        if (i > 0) html.push(`<i id="${tab.id}_favorite"  class="asbutton   fa fa-star-o" title="收藏"
                                                        onclick="favoriteTab( this);"
                                                        style="visibility:hidden;  color:green;" >
                                                        </i>`);
        html.push(`<span class=asbutton  title="双击在新的窗口打开本页"
                                                 ondblclick="popup('${tab.id}');"
                                                 onclick="activeTab('${tab.id}');">${tab.title}&nbsp;</span>`);

        if (i > 0) html.push(` 
                                                        <i id="${tab.id}_close"  class="asbutton   fa fa-times" title="关闭"
                                                        onclick="closeTab( this);"
                                                        style="visibility:hidden; vertical-align: top;" ></i>
                                   
                                                        
                                                        `);

        html.push('</span>');

    }

    $E('tabContainer').innerHTML = html.join('');

    //重新计算总卷滚
    calculateTabScroll();

}


//重新计算总卷滚
function calculateTabScroll() {

    //得到 tab容器的宽度
    var totalWidth = $('#tabContainerMainArea').width();

    var delta = 50; //在计算宽度时， 某些情况下，最后一个tab会显示不全，原因肯定是有的，头搞晕了，算了，加一个误差，可以解决问题
    //从最右边的Tab开始计算，往左计算，看到哪个Tab时，它及它右边的Tab把totalWidth占满了
    var tabs = $('#tabContainer  .TAB');
    gi_canScrollToTabIndex = 0;
    var tabCount = tabs.length;
    var tabsWidth = 0;
    for (var i = tabCount - 1; i >= 0; i--) {
        tabsWidth += $('#tabContainer  .TAB' + i).width();
        if (tabsWidth > totalWidth - delta) {
            gi_canScrollToTabIndex = i + 1;
            break;
        }
    }

    if (gi_canScrollToTabIndex == 0) {
        $('#cb_first')[0].disabled = true;
        $('#cb_left')[0].disabled = true;
        $('#cb_right')[0].disabled = true;
        $('#cb_last')[0].disabled = true;
    } else {
        $('#cb_first')[0].disabled = false;
        $('#cb_left')[0].disabled = false;
        $('#cb_right')[0].disabled = false;
        $('#cb_last')[0].disabled = false;
    }


}

var gi_firstTabIndex = 0;
var gi_canScrollToTabIndex = 0;

function moveToFirstTab() {
    gi_firstTabIndex = 0;
    moveTab();
}

function moveToPriorTab() {
    if (gi_firstTabIndex > 0) {
        gi_firstTabIndex--;
        moveTab();
    }

}

function moveToNextTab() {
    if (gi_firstTabIndex < gi_canScrollToTabIndex) {
        gi_firstTabIndex++;
        moveTab();
    }

}

function moveToLastTab() {
    gi_firstTabIndex = gi_canScrollToTabIndex;
    moveTab();
}

function moveTab() {
    var left = $('#tabContainer  .TAB' + gi_firstTabIndex).position().left;
    $('#tabContainer').css('left', "-" + left + 'px');


    $('#cb_showTabListLeft').css("display", gi_firstTabIndex == 0 ? "none" : "");
    $('#cb_showTabListRight').css("display", gi_canScrollToTabIndex > 0 && gi_firstTabIndex < gi_canScrollToTabIndex ? "" : "none");

    if (gi_canScrollToTabIndex == 0) {

        $('#cb_first')[0].disabled = true;
        $('#cb_left')[0].disabled = true;
    } else {

        $('#cb_first')[0].disabled = false;
        $('#cb_left')[0].disabled = false;
    }

    if (gi_canScrollToTabIndex == gi_canScrollToTabIndex) {

        $('#cb_right')[0].disabled = true;
        $('#cb_last')[0].disabled = true;
    } else {

        $('#cb_right')[0].disabled = false;
        $('#cb_last')[0].disabled = false;
    }


}

$(document).ready(function () {
    var url = "desktop.jsp";
    //addTab('fa-star', '收藏', "favorite.jsp");

    addTab('fa-th', '桌面', url);

    $('#cb_showTabListLeft').click(cb_showTabListLeft_onClick);
    $('#cb_showTabListRight').click(cb_showTabListRight_onClick);

});


$(window).resize(function () {
    rebuildTabHTML();
    activeTab(activeTabId);

});


//接收其它窗口用postMessage发送过来的命令
window.addEventListener('message', function (e) {
    //转给主窗口
    window.parent.postMessage(e.data, '*');

});

function broadcastMessage(msg) {
    msg.action = 'broadcastMessage';
    sendMessageToFrame("iframe_" + activeTabId, msg, '*');

}


function cb_showTabListLeft_onClick(e) {
    var items = [];

    for (var i = 0; i < gi_firstTabIndex; i++) {
        var tab = tabs[i];
        var menu = {
            title: ` <i  class="asbutton fa ${tab.img} " ></i>&nbsp;${tab.title}`,
            fn: function (tab) {

                activeTab(`${tab.id}`);
            }.bind(window, tab)
        };

        items.push(menu);

    }


    basicContext.show(items, e);
}


function cb_showTabListRight_onClick(e) {

    //找到右边第一个不可见的Tab

    //得到 tab容器的宽度
    var totalWidth = $('#tabContainerMainArea').width();
    var w = 0;
    var firstUnvisibleTabIndex = 0;
    for (var i = gi_firstTabIndex; i < tabs.length; i++) {
        w = w + $('#tabContainer .TAB' + i).width();
        if (w > totalWidth) {
            firstUnvisibleTabIndex = i;
            break;
        }
    }

    if (firstUnvisibleTabIndex == 0) {
        $('#cb_showTabListRight').css("display", "none");
        return;
    }
    var items = [];

    for (var i = firstUnvisibleTabIndex; i < tabs.length; i++) {
        var tab = tabs[i];
        var menu = {
            title: ` <i  class="asbutton fa ${tab.img} " ></i>&nbsp;${tab.title}`,
            fn: function (tab) {
                activeTab(`${tab.id}`);
            }.bind(window, tab)
        };

        items.push(menu);

    }
    basicContext.show(items, e);
}
