/*
 * FCKeditor - The text editor for internet
 * Copyright (C) 2003-2005 Frederico Caldeira Knabben
 * 
 * Licensed under the terms of the GNU Lesser General Public License:
 * 		http://www.opensource.org/licenses/lgpl-license.php
 * 
 * For further information visit:
 * 		http://www.fckeditor.net/
 * 
 * File Name: fck_image.js
 * 	Scripts related to the Link dialog window (see fck_link.html).
 * 
 * File Authors:
 * 		Frederico Caldeira Knabben (fredck@fckeditor.net)
 
  <embed src="/_userfiles/Flash/banner.swf" type="application/x-shockwave-flash"></embed>
  
  
 */

var oEditor		= window.parent.InnerDialogLoaded() ;
var FCK			= oEditor.FCK ;
var FCKConfig	= oEditor.FCKConfig ;

var bMediaButton = ( document.location.search.length > 0 && document.location.search.substr(1) == 'Media' ) ;

//#### Dialog Tabs

// Set the dialog tabs.
window.parent.AddTab( 'Info', oEditor.FCKLang.Media ) ;
 

// Function called when a dialog tag is selected.
function OnDialogTabChange( tabCode )
{
	ShowE('divInfo'		, ( tabCode == 'Info' ) ) ;
  
}

// Get the selected image (if available).
var oImage = FCK.Selection.GetSelectedElement() ;
 
if ( oImage && oImage.tagName != 'EMBED' && !( oImage.tagName == 'OBJECT'   ) )
	oImage = null ;

// Get the active link.
var oLink = FCK.Selection.MoveToAncestorNode( 'A' ) ;

var oImageOriginal ;

function UpdateOriginal( resetSize )
{
	oImageOriginal = document.createElement( 'EMBED' ) ;	// new Image() ;

	if ( resetSize )
	{
		oImageOriginal.onload = function()
		{
			this.onload = null ;
			ResetSizes() ;
		}
	}

	oImageOriginal.src = GetE('imgPreview').src ;
}

window.onload = function()
{
	// Translate the dialog box texts.
	oEditor.FCKLanguageManager.TranslatePage(document) ;

	 
	// Load the selected element information (if any).
	LoadSelection() ;

	// Show/Hide the "Browse Server" button.
	 
	UpdateOriginal() ;

	window.parent.SetAutoSize( true ) ;

	// Activate the "OK" button.
	window.parent.SetOkButton( true ) ;
}

function LoadSelection()
{
	if ( ! oImage ) return ;

	var sUrl = GetAttribute( oImage, 'src', '' ) ;

 

	GetE('txtUrl').value    = sUrl ;
	GetE('txtAlt').value    = GetAttribute( oImage, 'alt', '' ) ;
	 
	if ( oImage.style.pixelWidth > 0 )
		GetE('txtWidth').value  = oImage.style.pixelWidth ;
	else
		GetE('txtWidth').value  = GetAttribute( oImage, "width", '' ) ;

	if ( oImage.style.pixelHeight > 0 )
		GetE('txtHeight').value  = oImage.style.pixelHeight ;
	else
		GetE('txtHeight').value = GetAttribute( oImage, "height", '' ) ;

	  

	UpdatePreview() ;
}

//#### The OK button was hit.
function Ok()
{
	if ( GetE('txtUrl').value.length == 0 )
	{
		window.parent.SetSelectedTab( 'Info' ) ;
		GetE('txtUrl').focus() ;

		alert( oEditor.FCKLang.DlgImgAlertUrl ) ;

		return false ;
	}

	var bHasMedia = ( oImage != null ) ;

 
	 
	if ( !bHasMedia )
	{
		if ( bMediaButton )
		{
			oImage = FCK.EditorDocument.createElement( 'EMBED' ) ;
			oImage.type = 'embed' ;
			oImage = FCK.InsertElementAndGetIt( oImage ) ;
		}
		else
			oImage = FCK.CreateElement( 'EMBED' ) ;
	}
	else
		oEditor.FCKUndo.SaveUndoStep() ;
	
	UpdateImage( oImage ) ;

	var sLnkUrl = GetE('txtLnkUrl').value.trim() ;

	if ( sLnkUrl.length == 0 )
	{
		if ( oLink )
			FCK.ExecuteNamedCommand( 'Unlink' ) ;
	}
	else
	{
		if ( oLink )	// Modifying an existent link.
			oLink.href = sLnkUrl ;
		else			// Creating a new link.
		{
			if ( !bHasMedia )
				oEditor.FCKSelection.SelectNode( oImage ) ;

			oLink = oEditor.FCK.CreateLink( sLnkUrl ) ;

			if ( !bHasMedia )
			{
				oEditor.FCKSelection.SelectNode( oLink ) ;
				oEditor.FCKSelection.Collapse( false ) ;
			}
		}

		SetAttribute( oLink, 'target', GetE('cmbLnkTarget').value ) ;
	}

	return true ;
}

function UpdateImage( e, skipId )
{
	e.src = GetE('txtUrl').value ;
	SetAttribute( e, "alt"   , GetE('txtAlt').value ) ;
	SetAttribute( e, "width" , GetE('txtWidth').value ) ;
	SetAttribute( e, "height", GetE('txtHeight').value ) ;
 
	 
}

function UpdatePreview()
{
	if ( GetE('txtUrl').value.length == 0 )
		GetE('lnkPreview').style.display = 'none' ;
	else
	{
		UpdateImage( GetE('imgPreview'), true ) ;

		if ( GetE('txtLnkUrl').value.trim().length > 0 )
			GetE('lnkPreview').href = 'javascript:void(null);' ;
		else
			SetAttribute( GetE('lnkPreview'), 'href', '' ) ;

		GetE('lnkPreview').style.display = '' ;
	}
}

var bLockRatio = false ;

function SwitchLock( lockButton )
{
	bLockRatio = !bLockRatio ;
	lockButton.className = bLockRatio ? 'BtnLocked' : 'BtnUnlocked' ;
	lockButton.title = bLockRatio ? 'Lock sizes' : 'Unlock sizes' ;

	if ( bLockRatio )
	{
		if ( GetE('txtWidth').value.length > 0 )
			OnSizeChanged( 'Width', GetE('txtWidth').value ) ;
		else
			OnSizeChanged( 'Height', GetE('txtHeight').value ) ;
	}
}

// Fired when the width or height input texts change
function OnSizeChanged( dimension, value )
{
	// Verifies if the aspect ration has to be mantained
	if ( oImageOriginal && bLockRatio )
	{
		if ( value.length == 0 || isNaN( value ) )
		{
			GetE('txtHeight').value = GetE('txtWidth').value = '' ;
			return ;
		}

		if ( dimension == 'Width' )
			GetE('txtHeight').value = Math.round( oImageOriginal.height * ( value  / oImageOriginal.width ) ) ;
		else
			GetE('txtWidth').value  = Math.round( oImageOriginal.width  * ( value / oImageOriginal.height ) ) ;
	}

	UpdatePreview() ;
}

// Fired when the Reset Size button is clicked
function ResetSizes()
{
	if ( ! oImageOriginal ) return ;

	GetE('txtWidth').value  = oImageOriginal.width ;
	GetE('txtHeight').value = oImageOriginal.height ;

	UpdatePreview() ;
}
  

var sActualBrowser ;

function SetUrl( url, width, height, alt )
{
	if ( sActualBrowser == 'Link' )
	{
		GetE('txtLnkUrl').value = url ;
		UpdatePreview() ;
	}
	else
	{
		GetE('txtUrl').value = url ;
		GetE('txtWidth').value = width ? width : '' ;
		GetE('txtHeight').value = height ? height : '' ;

		if ( alt )
			GetE('txtAlt').value = alt;

		UpdatePreview() ;
		UpdateOriginal( true ) ;
	}
}