<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page language="java" import="java.util.*" %>
<%

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" >
<html>
<head><meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title> </title>
    <META http-equiv="pragma" content="no-cache">
    <META http-equiv="cache-control" content="no-cache">
    <META http-equiv="expires" content="0">
     <LINK rel="StyleSheet" href="css/normal.css" type="text/css" />
     <style type="text/css">
<!--
.style1 {
	font-size: 16px;
	font-weight: bold;
}
.style3 {color: #FF0000} 
.style4 {color: #0000FF}
.style5 {color: #006600}
.style7 {color: #006600; font-weight: bold; }
.style8 {font-family: "Courier New", Courier, mono}
-->

body { font-size:12px}
table { font-size:12px}
.style11 {color: #0000FF; font-weight: bold; }
     </style>
</head>

<body>
<p class="style1">结构化模板中的数据定义</p>
<hr>
<p class="style1">&nbsp;</p>
<p>在结构化模板中，模板需要操作的数据库的定义放在 db.xml文件中，下而详细描述该文件的格式， </p>
<p class="style1">数据源定义 datasource</p>
<p>在定义中，一个datasource定义为一个数据源。数据源是对数据的描述。数据源定义有如下属性</p>
<table  border="1" cellspacing="0" cellpadding="3" width="92%">
  <tr bgcolor="#CCCCCC">
    <td nowrap><div align="center">属性</div></td>
    <td nowrap><div align="center">是否必须</div></td>
    <td><div align="center">说明 </div></td>
  </tr>
  <tr>
    <td nowrap>name</td>
    <td nowrap><div align="center">必须</div></td>
    <td>数据源的名称。在整个定义中，各个数据源的名称都必须是唯一的</td>
  </tr>
  <tr>
    <td nowrap>connection</td>
    <td nowrap><div align="center">必须</div></td>
    <td>使用哪个数据库连接，它对应于数据连接池配置中的jdbc/jndi定义中的名称</td>
  </tr>
  <tr>
    <td nowrap>type</td>
    <td nowrap><div align="center">必须</div></td>
    <td><p>数据源的类型：</p>
      <ul>
        <li>table 表明数据源是针对一个表进行的定义</li>
        <li>sql 表明数据源是由一个Select语句定义</li>
    </ul></td>
  </tr>
  <tr>
    <td nowrap>rowcount</td>
    <td nowrap><div align="center">必须</div></td>
    <td><p>数据源的数据行数：</p>
      <ul>
        <li>“single”表示数据源仅有一条记录</li>
        <li>“multi”表示数据源是可以有多条记录</li>
    </ul></td>
  </tr>
  <tr>
    <td nowrap>autoretrieve</td>
    <td nowrap><div align="center">必须</div></td>
    <td><p>数据源是否立即检索数据，仅对type=&quot;sql&quot;类型的数据源有效</p>
        <ul>
          <li>false 表示不检索，</li>
          <li>true 表示立即检索</li>
      </ul></td>
  </tr>
  <tr>
    <td nowrap>comment</td>
    <td nowrap><div align="center">可选</div></td>
    <td>对该数据源的说明</td>
  </tr>
  <tr>
    <td height="66" nowrap>defaultrowcount</td>
    <td><div align="center">可选</div></td>
    <td>数据源的数据行数为&quot;multi&quot;即(rowcount=&quot;multi&quot;)时，指定缺省插入几行</td>
  </tr>
</table>
<p class="style1">表定义 table </p>
<p>当数据源datasource类型是table 时，需要进一步对数据的表结构进行定义，表定义有如下属性</p>
<table  border="1" cellpadding="3" cellspacing="0"  width="91%">
  <tr bgcolor="#CCCCCC">
    <td nowrap><div align="center">属性</div></td>
    <td nowrap><div align="center">是否必须</div></td>
    <td><div align="center">说明 </div></td>
  </tr>
  <tr>
    <td nowrap>name</td>
    <td><div align="center">必须</div></td>
    <td>表的名称，它指明表在数据库中的名称，它必须是合法的“<a href="#&#26631;&#35782;&#31526;">标识符</a>”定义，在整个数据源定义中，各个表的名称都必须是唯一的</td>
  </tr>
  <tr>
    <td nowrap>updatable</td>
    <td><div align="center">必须</div></td>
    <td><p>表是否可更新 </p>
        <ul>
          <li>true表示允许更新</li>
          <li>false表示不能更新</li>
      </ul></td>
  </tr>
  <tr>
    <td nowrap>primarykey</td>
    <td><div align="center">必须</div></td>
    <td>定义表的主键，如果是多个字段组成的组合主键，多个字段名之间用逗号分隔，例如： primarykey=&quot;name,code&quot;</td>
  </tr>
  <tr>
    <td nowrap>updatablecolumns</td>
    <td><div align="center">必须</div></td>
    <td>定义允许更新的字段和不允许更新的字段。当想表明某个字段不允许更新时，在字段名前加上&quot;<span class="style3">~</span>&quot; ,多个字段间用竖线分隔，例如：updatablecolumns=&quot;*&quot;表示所有字段都允许更新。 updatablecolumns=&quot;*|~id&quot;表示id不允许更新，其它字段都允许更新;updatablecolumns=&quot;name|code|~tel&quot; 表示name, code允许更新，tel不允许更新 </td>
  </tr>
  <tr>
    <td height="66" nowrap>whereclause</td>
    <td><div align="center">必须</div></td>
    <td><p><FONT color=#008000><B>多用户环境</B></FONT>下对数据的<FONT 
color=#008000><B><a href="#&#22810;&#29992;&#25143;&#30340;&#24182;&#21457;&#26356;&#26032;&#25511;&#21046;">并发更新</a></B></FONT>策略<br>(即出现在Where子句中的列 ，它通常=primarykey )</p>
    </td>
  </tr>
  <tr>
    <td height="66" nowrap>orderby</td>
    <td><div align="center">可选</div></td>
    <td>指定排序规则 ，例如： orderby=&quot; xh asc , no desc&quot; </td>
  </tr>
</table>
<p class="style1">SQL定义</p>
<p>当数据源datasource类型是sql 时，需要进一步对数据的取数语句进行定义，直接将取数语句放在&lt;sql&gt;&lt;/sql&gt;之间，就可以了。示例：</p>
<p>&lt;datasource name=&quot;demo1&quot; connection=&quot;default&quot; type=&quot;sql&quot; rowcount=&quot;multi&quot; autoretrieve=&quot;false&quot; &gt;<br>

<strong><span class="style4">&lt;sql&gt;</span> <span class="style5">select  * from test</span> <span class="style4">&lt;/sql&gt;</span></strong><br> 
&lt;<span class="style11">column</span> name=&quot;id&quot; label=&quot;主键&quot; /&gt;
<br>
&lt;/datasource&gt;</p>
<p>其中的column是对SQL语句中字段的说明</p>
<p class="style1">字段字义 column </p>
<p>用column 对数据源的各个字段进行详细的定义。注意：当datasource的type=&quot;table&quot;时，进行column定义是必须的。当datasource的type=&quot;sql&quot;时,可以不用定义column ,系统会自动分析其中的字段。但如果想对字段作详细的描述，也可以进行column定义<br>
  <br>
特别值得注意的是，如果datasource的type=&quot;table&quot;时，必须存在如下的两个字段定义，这两个字段是每个可更新的表必须的。</p>
<p>&nbsp;  </p>
<table width="80%"  border="0" cellpadding="3" cellspacing="1" bgcolor="#FFFFCC">
  <tr>
    <td nowrap><span class="style8">&lt;column <strong>name</strong>=&quot;id&quot; <strong>type</strong>=&quot;varchar(40)&quot; <strong>label</strong>=&quot;id&quot; <strong>defaultvalue</strong>=&quot;=<span class="style3">RandomGuid</span>()&quot;/&gt;<br>
&lt;column <strong>name</strong>=&quot;gguid&quot; <strong>type</strong>=&quot;varchar(40)&quot; <strong>label</strong>=&quot;gguid&quot; /&gt;</span></td>
  </tr>
</table>
<p>字段定义定义有如下属性 </p>
<table width="682"  border="1" cellpadding="3" cellspacing="0" >
  <tr bgcolor="#CCCCCC">
    <td width="72" nowrap><div align="center">属性</div></td>
    <td width="33"><div align="center">是否必须</div></td>
    <td width="551"><div align="center">说明 </div></td>
  </tr>
  <tr>
    <td nowrap>name</td>
    <td><div align="center">必须</div></td>
    <td>字段的名称，它指明该字段在表中的名称，它必须是合法的“<a href="#&#26631;&#35782;&#31526;">标识符</a>”定义。在一个表定义中，各个计算列及字段的名称都必须是唯一的</td>
  </tr>
  <tr>
    <td nowrap>type</td>
    <td><div align="center">必须</div></td>
    <td><p>字段类型。即字段在数据库中的类型。它需要符合相应数据库字段类型的定义，常用类型如下：</p>
      <ul>
        <li class="style7">int </li>
        <li><span class="style7">numeric(20,4)</span> 表示是精确小数，其中小数位是4位，整数位最20-4=16位</li>
        <li><span class="style7">varchar(255)</span> 变长字符串，不同数据库允许的最大长度是不同的。其中MS-SQLServer允许最长8000</li>
        <li><span class="style7">datetime</span> 日期型</li>
        <li><span class="style7">text </span>大文本型 （当需要保存图片，大量文字等数据时，使用该类型)</li>
    </ul></td>
  </tr>
  <tr>
    <td nowrap>label</td>
    <td><div align="center">可选</div></td>
    <td>对该字段的说明</td>
  </tr>
  <tr>
    <td nowrap>search</td>
    <td><div align="center">可选</div></td>
    <td><p>表示当该数据是否参与智能搜索匹配：</p>
      <ul>
        <li>true表示参与智能搜索匹配</li>
        <li>false表示参不与智能搜索匹配</li>
    </ul></td>
  </tr>
  <tr>
    <td nowrap>modifylog</td>
    <td><div align="center">可选</div></td>
    <td><p>表示是否需在记录对该字段的修改日志。比如在工作流中某些重要数据需要记录每个人对它的修改日志。</p>
      <ul>
        <li>true表示每次修改后都记下修改日志</li>
        <li>false表示不需要记录修改日志</li>
    </ul></td>
  </tr>
  <tr>
    <td nowrap>defaultvalue</td>
    <td><div align="center">可选</div></td>
    <td><p>定义缺省会值，当需要使用表达式来设置缺省值时，需要以=开头。比如：</p>
    <p>defaultvalue=<strong>&quot;123&quot;</strong>  缺省值是123<br>
      defaultvalue=<strong>&quot;=now()&quot;</strong>   缺省值是当前时间<br>
      defaultvalue=<strong>&quot;=randomGuid()&quot;</strong> 缺省值是生成的一个全球唯一标识码<br>
    </p></td>
  </tr>
  <tr>
    <td nowrap>reserved</td>
    <td>可选 </td>
    <td>表示是不是保留字段，即必须的字段，如果 reserved=&quot;true&quot; 则该字段不允许删除和修改</td>
  </tr>
</table>
<p>&nbsp;</p>
<p class="style1">计算列 computer</p>
<p>当某些数据是需要通过计算得到到，那么可以通过计算列来定义。计算列作为本系统的特色，</p>
<p>它将用简单的方式完成各种计算的定义，并允许对计算结果进行保存。 计算列具有如下属性</p>
<p>  </p>
<UL>
  <LI>计算列由一个表达式来定义，表达式中允许使用内嵌的功能函数 
  <LI>允许使用字段名称名称来引用字段的值。比如 某计算列je 被定义为sl * dj表示该计算列为列sl 乘以列dj 
</UL>
<p>计算列有两类：</p>
<ol>
  <li>基于行的计算列：这类计算列使用字段名称来访问相应行上的数据</li>
  <li>基于列的计算列：也称聚合型计算列，它们通常是对某个列，或某个表示式，在整列上做运算。<br>
  比如求 对sl 这个字段，求它所有行的累加和，或求最大，最小，平均值。</li>
</ol>
<p>计算列有如下属性定义：</p>
<table width="96%"  border="1" cellpadding="3" cellspacing="0">
  <tr bgcolor="#CCCCCC">
    <td nowrap><div align="center">属性</div></td>
    <td><div align="center">是否必须</div></td>
    <td><div align="center">说明 </div></td>
  </tr>
  <tr>
    <td nowrap>name</td>
    <td><div align="center">必须</div></td>
    <td>计算列的名称，它指明计算结果使用某个名称来访问，它必须是合法的“<a href="#&#26631;&#35782;&#31526;">标识符</a>”定义。在一个表定义中，各个计算列及字段的名称都必须是唯一的</td>
  </tr>
  <tr>
    <td nowrap>expression</td>
    <td><div align="center">必须 </div></td>
    <td><p>表示式，它表明计算列的计算公式。其中可以用字段名来指代字段的数据。例如： sl*je 表示本计算列是sl字段×je字段。其中还可以使用函数</p>
    </td>
  </tr>
  <tr>
    <td nowrap>aggregatetype</td>
    <td><div align="center">可选</div></td>
    <td><p>当计算列是聚合计算列时，由它来指定聚合类型，它可以是：</p>
      <ul>
        <li><span class="style7">sum</span> 表示对 expression指定的表达式在所有数据行中进行求和</li>
        <li><span class="style7">max</span> 表示取expression指定的表达式在所有数据行中的最大值 </li>
        <li><span class="style7">mix</span> 表示取expression指定的表达式在所有数据行中的最小值 </li>
        <li><span class="style7">avg</span> 表示取expression指定的表达式在所有数据行中的平均值 </li>
      </ul>
    <p><strong>示例</strong>：&lt;computer name=&quot;sl_sum&quot; expression=&quot;sl&quot; aggregatetype=&quot;sum&quot;/&gt; 表示定义一个聚合计算列，名为sl_sum ,它是对字段sl进行求和。</p></td>
  </tr>
  <tr>
    <td nowrap>label</td>
    <td><div align="center">可选</div></td>
    <td>对该字段的说明</td>
  </tr>
  <tr>
    <td nowrap>fillback</td>
    <td><div align="center">可选</div></td>
    <td><p>定义将本计算列的计算结果回填到某个字段中</p>
    <p>示例：&lt;computer name=&quot;c_je&quot; expression=&quot;sl*je&quot; fillback=&quot;je&quot;/&gt; 表示将sl*je的结果放到字段je字段中保存</p></td>
  </tr>
  <tr>
    <td nowrap>reserved</td>
    <td>可选 </td>
    <td>表示是不是保留计算列，即必须的计算列，如果 reserved=&quot;true&quot; 则该计算列不允许删除和修改</td>
  </tr>
</table>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p class="style1">标识符<a name="标识符"></a></p>
<p>由字母开头，由字符，数字及下划线组成的符号</p>
<p>&nbsp;</p> 
<p class="style1">多用户的并发更新控制<a name="多用户的并发更新控制"></a></p>
<P>&nbsp;&nbsp;&nbsp;&nbsp;当有多个用户同时修改相同的数据时， 如何进行控制呢??</P>
<P>&nbsp;&nbsp;&nbsp;&nbsp;比如：000001号单据上的总金额为 500。这时，A，B两个操作员同时将该单据打开修改，A将总金额修改成 1000 ， 并保存。B将总金额修改成2000 ，此时，在数据库中，该单据的总金额已经变成了 1000，而不是最初检索出来的 500 。那么，是否允许 B 操作员保存修改呢？?</P>
<UL>
  <LI>策略一：允许B保存修改，这样带来的结果是：多人同时打开数据进行修改时，后修改的将覆盖先修改的，以最后一个保存的结果为最终结果。 
  <LI>策略二：不允许 B 保存修改，这样带来的结果是：多人同时打开数据进行修改时，最先保存的数据是有效数据，其后的更新操作都失败。 </LI>
</UL>
<P>&nbsp;&nbsp;&nbsp;&nbsp;DataStore 是通过 whereclause 属性来控制多用户的并发更新。该属性定义了数据修改翻译成 Update 语句中的where 子句的结构。比如 whereclause =" id | name | je "? ,那么当用户修改了数据并调用Update 函数作保存时，被修改的数据被解释成? Update? ????? Set?? col1= ??? , ...?? Where? id=? and? name=? and je= ? 。 比如表 t1 中有列 id, name ,code, je? ,?? 检索出来某行数据为 id=1, name='wise', code='01', je=500 。A 、B 操作员同时将该数据检索出来修改。 A操作员将 je 修改成 1000 , 当A作保存时 ， DataStore 将A所做的操作解释成? Update? t1 set je=500 Where id=1 and name='wise' and je=500 。当A 保存成功后，数据库中该记录的je变成了1000 . 这时，B操作员将je? 修改成 2000 , 当B作保存时 ， DataStore 将B所做的操作解释成? Update? t1 set je=2000 Where id=1 and name='wise' and je=500 。显然 <B>B</B>操作员的操作不会生效。因为数据库中已经不存在 id=1 并且 name='wise' 并且 je=500? 的记录了。这样实现了策略二的要求。如果令 whereclause= "id " 那么 B 操作员的操作被解释成? Update? t1 set je=2000 Where id=1 。这时B的操作生效，实现策略一的要求。 </P>
<P>&nbsp;&nbsp;&nbsp;&nbsp;所以，出现在 whereclause中的列越多，并发控制越严格。，出现在 whereclause中的列越少，并发控制越宽松 。但表的主键必须出现在 whereclause中。 比如表 t2 的主键是 name 和 code 组合而成，那么 name | code 必须出现在whereclause中，否则无法正确更新数据。 </P>
<P>&nbsp;&nbsp;&nbsp;&nbsp;值得注意的是：DataStore 能够通过whereclause来控制多用户同时多同一数据的更新，但对多用户对同一数据的删除不作控制，也就是说：如果Ａ操作员删除了单据 000001 , 然后　B 操作员再删除单据 000001 ,　虽然 B 操作员的删除操作没有删除任何数据（因为要删除的数据已经被删除），但系统仍然认为　B 操作员执行成功（因为他的目的的确已经达到）。 </P>
<P>　 </P>
<P class="style1">完整示例:</P>
 
<P>&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot;?&gt;<br>
  &lt;workbook sheetcount='1' gui='true'&gt;<br>
&lt;<strong>datasource</strong> name=&quot;flow_gs_jmslzd&quot; connection=&quot;default&quot; type=&quot;table&quot;<br>
updatable=&quot;true&quot; rowcount=&quot;single&quot;&gt;<br>
&lt;<strong>table</strong> name=&quot;flow_gs_jmslzd&quot; updatable=&quot;true&quot; primarykey=&quot;id&quot;<br>
updatablecolumns=&quot;*&quot; whereclause=&quot;id&quot;&gt;<br>
&lt;column name=&quot;id&quot; type=&quot;varchar(40) &quot; label=&quot;id&quot;<br>
defaultvalue=&quot;=randomGuid()&quot; /&gt;<br>
&lt;column name=&quot;gguid&quot; type=&quot;varchar(40)&quot; label=&quot;gguid&quot; /&gt;<br>
&lt;column name=&quot;czrq&quot; type=&quot;int&quot; label=&quot;受理日期&quot; /&gt;<br>
&lt;column name=&quot;swdjzh&quot; type=&quot;varchar(50)&quot; label=&quot;纳税人登记号&quot;<br>
search=&quot;true&quot; modifylog=&quot;true&quot; /&gt;<br>
&lt;column name=&quot;qynm&quot; type=&quot;int&quot; label=&quot;企业内码&quot; /&gt;<br>
&lt;column name=&quot;mc&quot; type=&quot;varchar(255)&quot; label=&quot;纳税人名称&quot;<br>
search=&quot;true&quot; /&gt;<br>
&lt;column name=&quot;qylxdh&quot; type=&quot;varchar(100)&quot; label=&quot;纳税人电话&quot; /&gt;<br>
&lt;column name=&quot;qydz&quot; type=&quot;varchar(255)&quot; label=&quot;纳税人地址&quot; /&gt;<br>
&lt;column name=&quot;slbm&quot; type=&quot;varchar(40)&quot; label=&quot;受理部门&quot; /&gt;<br>
&lt;column name=&quot;slry&quot; type=&quot;varchar(40)&quot; label=&quot;受理人员&quot; /&gt;<br>
&lt;column name=&quot;zrgw&quot; type=&quot;varchar(40)&quot; label=&quot;责任岗位&quot; /&gt;<br>
&lt;column name=&quot;zrgwid&quot; type=&quot;int&quot; label=&quot;岗位ID&quot; /&gt;<br>
&lt;column name=&quot;qx&quot; type=&quot;datetime&quot; label=&quot;时限&quot; /&gt;<br>
&lt;column name=&quot;jmlx&quot; type=&quot;int&quot; label=&quot;减免类型&quot; /&gt;<br>
&lt;column name=&quot;jmsx&quot; type=&quot;int&quot; label=&quot;减免事项&quot; /&gt;<br>
&lt;column name=&quot;yjsj&quot; type=&quot;int&quot; label=&quot;移交市局&quot; /&gt;<br>
&lt;column name=&quot;yjsjsj&quot; type=&quot;int&quot; label=&quot;移交时间&quot; /&gt;<br>
&lt;column name=&quot;sjpfsj&quot; type=&quot;int&quot; label=&quot;市局批复时间&quot; /&gt;<br>
&lt;column name=&quot;html&quot; type=&quot;text&quot; label=&quot;文档&quot; /&gt;</P>
<p> &lt;/table&gt;</p>
<p>&nbsp;</p>
<p> &lt;/datasource&gt;</p>
<p> &lt;<strong>datasource</strong> name=&quot;flow_a&quot; connection=&quot;default&quot; type=&quot;table&quot;<br>
  updatable=&quot;true&quot; rowcount=&quot;single&quot;&gt;<br>
&lt;<strong>table</strong> name=&quot;flow_gs_tslzd&quot; updatable=&quot;true&quot; primarykey=&quot;id&quot;<br>
  updatablecolumns=&quot;*&quot; whereclause=&quot;id&quot;&gt;<br>
&lt;column name=&quot;id&quot; type=&quot;varchar(40) &quot; label=&quot;id&quot;<br>
  defaultvalue=&quot;=randomGuid()&quot; /&gt;<br>
&lt;column name=&quot;gguid&quot; type=&quot;varchar(40)&quot; label=&quot;gguid&quot; /&gt;<br>
&lt;column name=&quot;photo&quot; type=&quot;text&quot; label=&quot;照片&quot;<br>
  modifylog=&quot;true&quot; /&gt;<br>
&lt;column name=&quot;test_xh&quot; type=&quot;int&quot; label=&quot;序号回填测试&quot;<br>
  modifylog=&quot;false&quot; /&gt;<br>
&lt;column name=&quot;test_xh2&quot; type=&quot;int&quot; label=&quot;序号回填测试&quot;<br>
  modifylog=&quot;false&quot; /&gt;<br>
&lt;computer name=&quot;xh&quot; expression=&quot; test_xh * 10 &quot;<br>
aggregatetype=&quot;sum&quot; label=&quot;序号&quot; fillback=&quot;test_xh2&quot; /&gt;</p>
<p> &lt;/table&gt;</p>
<p> &lt;/datasource&gt;<br>
</p>
<p> &lt;<strong>datasource</strong> name=&quot;tf2000cx_zjl&quot; connection=&quot;jdbc/tf2000&quot; type=&quot;sql&quot;<br>
  rowcount=&quot;multi&quot; sourcecharset=&quot;iso-8859-1&quot; tocharset=&quot;UTF-8&quot;<br>
  autoretrieve=&quot;false&quot;&gt;<br>
&lt;<strong>sql</strong>&gt;<br>
  SELECT SELECTED=1,WS_ZB.CZRQ, B.MC,B.QYLXDH,B.QYDZ,B.SWDJZH,<br>
  B.QY_ID ,B.QYNM,<br>
  D.JMQSQX,D.JMZZQX,D.CZYBM,D.SBH,D.JSJ,D.JMXMSE, WS_ZB.TZDZ,<br>
  WS_ZB.TZDH, SZSM= C.SZSM+'-'+BM_SZSM.SZSM , SZSMBM =<br>
  D.SZSMBM, D.XH, D.JMSE, D.JMFD, D.JMSL, E.JMXM FROM<br>
  DJ_SWDJZB B,WS_ZB,BM_SZSM , BM_SZSM C ,WS_JMSQB D,BM_JMXM E<br>
  WHERE (WS_ZB.CZYBM = D.CZYBM) AND (WS_ZB.CZRQ = D.CZRQ) AND<br>
  (WS_ZB.SBH = D.SBH) AND (B.QYNM = WS_ZB.QYNM) AND ( B.SWBMBM<br>
  = 33010005) AND ( BM_SZSM.SZSMBM = D.SZSMBM) AND (<br>
  WS_ZB.WSBM = 15006) AND ( WS_ZB.WSZT = 2) AND ( WS_ZB.PFJB =<br>
  1) AND ( D.JMXMBM = E.JMXMBM) AND BM_SZSM.SZ=C.SZSMBM<br>
&lt;/sql&gt;<br>
&lt;/datasource&gt;</p>
<p>&lt;/workbook&gt;<br>
</p>
<P>&nbsp; 
</P>
</body>
</html>
