
// sheet 工作表对象 
//  row  被编辑单元格的行号
//　col 　被编辑单元格的列号
//　dbRow  当该单元格绑定到一个多行数据源时，本参数表明是其中第几行正在被编辑
//	　        注意 dbRow 从０开始，dbRow=0 表示数据源中的第一行正在被编辑
//	            所以 dbRow 取值范围是从0 到 行数减一　 
　 
function beginEdit( sheet , row, col ,dbRow)
{
	var cell=sheet.cells(row,col);
	if(cell==null) return;
	//如果是发票代码得到编辑焦点， 那么自动复制上一行的发票代码
	if (cell.getAlias().equals("fpdm"))
	{
		var ds=book.getDataSource('fpysmx').getDataStore();
		if(dbRow>0)
		{
			
			
			if ( ds.getString(dbRow,"fpdm").equals(""))
			{
				var lastFPDM=''+ds.getString(dbRow-1,"fpdm");
				if( lastFPDM=='') return;
				ds.setValue(dbRow,"fpdm", lastFPDM);
				ds.setValue(dbRow,"tkrq_n", ds.getInt(dbRow-1,"tkrq_n"));
				ds.setValue(dbRow,"tkrq_y", ds.getInt(dbRow-1,"tkrq_y"));
				ds.setValue(dbRow,"lx", ds.getInt(dbRow-1,"lx"));
				
				
			}
		}else
		{
			ds.setValue(dbRow,"lx",1);
		}
	}
	//如果是发票号码得到编辑焦点， 那么自动将上一行的发票号码加1并填入
	if (cell.getAlias().equals("fphm"))
	{
		
		if(dbRow>0)
		{
			
			var ds=book.getDataSource('fpysmx').getDataStore();
			if ( ds.getString(dbRow,"fphm").equals(""))
			{
				var lastFPHM=''+ds.getString(dbRow-1,"fphm");
				if( lastFPHM=='') return;
				ds.setValue(dbRow,"fphm", stringInc(lastFPHM));
				
				
			}
		} 
	}
	
		
} 
