/*

作用： 等把接口数据上传到知识库的的公共目录下， 然后将所有接口文件数据读入




*/

var test=true;

var JRE = JavaImporter();
JRE.importPackage(Packages.java.io);


function main()
{
    
    var rootPath="d:/WiseOAFileRoot/netdisk/public/TF数据接口";
    
    var f= new JRE.File( rootPath);
    //递归所有子目录，找出xls文件，并导入
    checkFile( f);
}

function checkFile( f)
{

    if( f.isDirectory())
    {
        var subDir= f.list();
        var pf=f.getPath();
        for( var i=0;i<subDir.length;i++)
        {
            var sf= pf+"/"+ subDir[i] ;
            var d= new JRE.File( sf);
            checkFile(d);
        }
    }else
    {
        var name=f.getPath();
        if(  upper(right(name,4))=='.XLS') importData( name );
    }
}

function  importData(fileName)
{
    println( "导入："+fileName);
    var data=readXLS(fileName);	
    if( !data.success)
    {
        println( data.description);
        return ;
    }
    var excelSheet=data.sheets[0];
    var type= safeValue(excelSheet, 1,2);
    println("类型是："+type);

   if( type=='bill_de_ds')  import_bill_de_ds( excelSheet);
   if( type=='dj_swdjnb')   import_dj_swdjnb( excelSheet);
   if( type=='dj_swdjzb')   import_dj_swdjzb( excelSheet);
   if( type=='ds_kh')       import_ds_kh( excelSheet); //个体税收
   if( type=='ds_cb')       import_ds_cb( excelSheet); //催报
   if( type=='ds_cj')       import_ds_cj( excelSheet); //催缴
   if( type=='ds_lg')       import_ds_lg( excelSheet); //漏管
   
   if( type=='ds_dehd')     import_ds_dehd( excelSheet); //新办
   if( type=='ds_ty')       import_ds_ty( excelSheet); //停业
   
   
   
   
   
   
    
}

//导入定额信息到表：  jk_d
function   import_bill_de_ds( excelSheet)
{

     println("导入开始时间： "+newDate()+" ============================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
    var sql=" (qynm int not null,    qy_id varchar(30) null, de  decimal(20,2) null, "+
                               "   gthybm_count int null, ggh int null,	de_ggh decimal(20,2) null, "+
                               " gthybm1 varchar(20) null,	de1 decimal(20,2) null, qsny1 int null,	zzny1 int null, "+
                               " gthybm2 varchar(20) null,	de2 decimal(20,2) null, qsny2 int null,	zzny2 int null, "+
                               " gthybm3 varchar(20) null,	de3 decimal(20,2) null, qsny3 int null,	zzny3 int null, "+
                               " gthybm4 varchar(20) null,	de4 decimal(20,2) null, qsny4 int null,	zzny4 int null , " +
                               " primary key( qynm) )";
 
    //建表                              
    runSQL("", "create table jk_de_ds "+sql,true);
    //临时表
    runSQL("", "drop table jk_de_ds_tmp " ,true);
    runSQL("", "create table jk_de_ds_tmp "+sql,true);
  	var ds=newDataStore("","select * from jk_de_ds_tmp");
    ds.setUpdateProperty("jk_de_ds_tmp","qynm","*","qynm");
    
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
            
    for( var r=5; r<100000;r++)
    {
        
        var qynm=safeValue(excelSheet, r, colIndex['qynm']);
        if( qynm=='') break;
        var row=ds.insertRow(9999);
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            ds.setValue(row, colName , v);
        }
     }
     
     println("本文件包含"+ds.getRowCount()+"笔数据");
     if(!ds.update(true)) 
     {
         println( "保存失败："+ ds.getError().getMessage());
  
     }else
     {
     
        runSQL("",[ " delete from jk_de_ds  where  exists ( select qynm from jk_de_ds_tmp where jk_de_ds_tmp.qynm= jk_de_ds.qynm ) ",  //先删除旧的
                 " insert into jk_de_ds ("+colList+") select "+colList+"  from   jk_de_ds_tmp " ], //再插入新的
                 true);
     }
     
     println("导入完成时间： "+newDate()+" ============================================");
    
}


//催报工作
function   import_ds_cb( excelSheet)
{

     println("导入开始时间： "+newDate()+" =======  摧报工作 ==================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
  
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
    
    var flowID=3;
    var today=date2yyyymmdd(currentDate());
    var y =getYear(currentDate()) ;
    var m =getMonth(currentDate());
    var rq =''+date2yyyymmdd(thisMonthFirstDay(y,m));  //月初
    var rq1=''+date2yyyymmdd( nextMonthFirstDay(y,m));//下月初
    var sy='';//工作要求
         
    for( var r=5; r<100000;r++)
    {
        
        var qy_id=safeValue(excelSheet, r, colIndex['qy_id']);
        if( qy_id=='') break;
        
        var ym=''+safeValue(excelSheet, r, colIndex['ym']);    
        if( ym !=''+(y*100+m) )
        {
            println("该数据不是"+m+"月的接口数据，忽略.");
            continue;
        }
        
        var rowData={};
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            rowData[  colName ]= v  ;
        }
        
        
        var cc= getIntFromSQL( "select count(a.id)  from flow_gzlzd1  a , oa_mywork  b  where  a.gguid=b.guid and  a.nsbm='"+qy_id+"' and  a.qfrq >= '"+rq+"' and a.qfrq < '"+rq1+"'  and  b.flowid="+flowID );
	  
        if ( cc>0)
        {
            println(qy_id+"本月已生成任务，不需要再次生成");
            continue;
        }
    
        
       
	    sy="该纳税人"+ym+'期内尚未申报，请督促该纳税人进行地税税款申报工作。';
        //生成草稿时，默认要填充的数据
        var data="<nsbm>"+qy_id+"</nsbm>"+
		"<gsbm>"+rowData.nsrsbh+"</gsbm>"+
		"<nsrmc>"+rowData.qymc+"</nsrmc>"+
		"<dz>"+rowData.scjydz +"</dz>"+
		"<xm_fr>"+rowData.xm_fr+"</xm_fr>"+    
		"<gddh_fr>"+rowData.gddh_fr+"</gddh_fr>"+    
		"<sspq>"+rowData.szpqbm +"</sspq>"+		
 		"<czybm>"+rowData.czybm+"</czybm>"+
		"<qfrq>"+today+"</qfrq>"+
		"<sy>"+sy+"</sy>"+//工作内容说明
		"<bh>"+rowData.bh+"</bh>"+//工作编号
		"<gzdl>地税</gzdl>"+
		"<gzlb>01</gzlb>"+
		"<qfr>1</qfr>"+
		"<cbje>"+rowData.cbje+"</cbje>"+
		"<gzsx>01.01</gzsx>";	
 				
		//工作主题
        var subject= qy_id + rowData.qymc+"（国税有申报地税无申报的催报）";
        //工作起草人
       
        var sqrID=userName2UserId(rowData.czybm );
        println( sqrID);
     
        if(sqrID<0)
        {
            ErrorLog( qy_id ,"指定的起草人"+rowData.czybm +"不是合法的注册用户，数据忽略");
            continue;
        }		
		//生成工作任务
        var guid=newWork(flowID,sqrID,subject,"",0,today,data);  
        if(guid=='')
        {
            ErrorLog(  qy_id ,"在生成工作任务时发生错误， 数据是："+JSON.toString( rowData));
        }else
        {
            println( guid);
        }
        
    }
     
    println("导入完成时间： "+newDate()+" ============================================");
    
}



//催缴工作
function   import_ds_cj( excelSheet)
{

    println("导入开始时间： "+newDate()+" =======  摧缴工作 ==================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
  
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
    
    var flowID=4;  //催缴
    var today=date2yyyymmdd(currentDate());
    var y =getYear(currentDate()) ;
    var m =getMonth(currentDate());
    var rq =''+date2yyyymmdd(thisMonthFirstDay(y,m));  //月初
    var rq1=''+date2yyyymmdd( nextMonthFirstDay(y,m));//下月初
    var sy='';//工作要求
         
    for( var r=5; r<100000;r++)
    {
        
        var qy_id=safeValue(excelSheet, r, colIndex['qy_id']);
        if( qy_id=='') break;
        
        var ym=''+safeValue(excelSheet, r, colIndex['ym']);    
        if( ym !=''+(y*100+m) )
        {
            println("该数据不是"+m+"月的接口数据，忽略.");
            continue;
        }
        
        var rowData={};
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            rowData[  colName ]= v  ;
        }
        
        var czrq= safeValue(excelSheet, r , colIndex['czrq'] ,true) ;
      
         
        var cc= getIntFromSQL("select a.id   from flow_gzlzd1  a , oa_mywork  b  where  a.gguid=b.guid and  a.nsbm='"+qy_id+"' and  a.qfrq  = '"+czrq+"'  and  b.flowid="+flowID);
	  
        if ( cc>0)
        {
            println(qy_id+"本月已生成任务，不需要再次生成");
            continue;
        }
    
        
	    sy="该单位"+y+"年"+m+"月扣款失败，原因是："+ rowData.yy; 
        
        //生成草稿时，默认要填充的数据
        var data="<nsbm>"+qy_id+"</nsbm>"+
		"<gsbm>"+rowData.nsrsbh+"</gsbm>"+
		"<nsrmc>"+rowData.qymc+"</nsrmc>"+
		"<dz>"+rowData.scjydz +"</dz>"+
		"<xm_fr>"+rowData.xm_fr+"</xm_fr>"+    
		"<gddh_fr>"+rowData.gddh_fr+"</gddh_fr>"+    
		"<sspq>"+rowData.szpqbm +"</sspq>"+		
 		"<czybm>"+rowData.czybm+"</czybm>"+
		"<qfrq>"+czrq+"</qfrq>"+ // 一定注意了， 是czrq 不是today
		"<sy>"+sy+"</sy>"+//工作内容说明
		"<bh>"+rowData.bh+"</bh>"+//工作编号
		"<gzdl>地税</gzdl>"+
		"<gzlb>01</gzlb>"+
		"<qfr>1</qfr>"+
		"<cbje>"+rowData.cbje+"</cbje>"+
		"<gzsx>01.02</gzsx>";	
 				
		//工作主题
        var subject= qy_id + rowData.qymc+"扣款不成功催缴工作";
        //工作起草人
        var sqrID=userName2UserId(rowData.czybm);
        println( sqrID);
      
        if(sqrID<0)
        {
            ErrorLog( qy_id ,"指定的起草人"+rowData.czybm +"不是合法的注册用户，数据忽略");
            continue;
        }		
		//生成工作任务
        var guid=newWork(flowID,sqrID,subject,"",0,today,data);  
        if(guid=='')
        {
            ErrorLog(  qy_id ,"在生成工作任务时发生错误， 数据是："+JSON.toString( rowData));
        }else
        {
            println( guid);
        }
        
    }
     
    println("导入完成时间： "+newDate()+" ============================================");
    
}



//漏管工作
function   import_ds_lg( excelSheet)
{

    println("导入开始时间： "+newDate()+" =======  漏管工作 ==================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
  
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
    
    var flowID=5000003;  //漏管
    var today=date2yyyymmdd(currentDate());
    var y =getYear(currentDate()) ;
    var m =getMonth(currentDate());
    var rq =''+date2yyyymmdd(thisMonthFirstDay(y,m));  //月初
    var rq1=''+date2yyyymmdd( nextMonthFirstDay(y,m));//下月初
    var sy='';//工作要求
         
    for( var r=5; r<100000;r++)
    {
        
        var qymc=safeValue(excelSheet, r, colIndex['qymc']);
        if( qymc=='') break;
        
        var ym=''+safeValue(excelSheet, r, colIndex['ym']);    
        if( ym !=''+(y*100+m) )
        {
            println("该数据不是"+m+"月的接口数据，忽略.");
            continue;
        }
        
        var rowData={};
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            rowData[  colName ]= v  ;
        }
        
         
        var cc= getIntFromSQL("select count(a.id)  from flow_gzlzd1  a , oa_mywork  b  where  a.gguid=b.guid and  a.nsrmc='"+rowData.qymc+"' and  a.qfrq >= '"+rq+"' and a.qfrq < '"+rq1+"'  and  b.flowid="+flowID);
	  
        if ( cc>0)
        {
            println( rowData.qymc+"本月已生成任务，不需要再次生成");
            continue;
        }
    
        
	    sy="该纳税人"+rowData.qymc+"在"+ym+"，在国税登记为个体户，在地税没有登记，请实地核查是否漏管。";
        
        //生成草稿时，默认要填充的数据
        var data="<nsbm></nsbm>"+
		"<gsbm>"+rowData.nsrsbh+"</gsbm>"+
		"<nsrmc>"+rowData.qymc+"</nsrmc>"+
		"<dz>"+rowData.scjydz +"</dz>"+
		"<xm_fr>"+rowData.xm_fr+"</xm_fr>"+    
		"<gddh_fr>"+rowData.gddh_fr+"</gddh_fr>"+    
		"<sspq>"+rowData.szpqbm +"</sspq>"+		
 		"<czybm>"+rowData.czybm+"</czybm>"+
		"<qfrq>"+today+"</qfrq>"+
		"<sy>"+sy+"</sy>"+//工作内容说明
		"<bh>"+rowData.bh+"</bh>"+//工作编号
		"<gzdl>地税</gzdl>"+
		"<gzlb>01</gzlb>"+
		"<qfr>1</qfr>"+
		"<cbje>"+rowData.cbje+"</cbje>"+
		"<gzsx>01.02</gzsx>";	
 				
		//工作主题
        var subject= rowData.nsrsbh + rowData.qymc+"地税漏征漏管工作";
        //工作起草人
        var sqrID=userName2UserId(rowData.czybm);
        println( sqrID);
        sqrID=1;
        if(sqrID<0)
        {
            ErrorLog( qy_id ,"指定的起草人"+rowData.czybm +"不是合法的注册用户，数据忽略");
            continue;
        }		
		//生成工作任务
        var guid=newWork(flowID,sqrID,subject,"",0,today,data);  
        if(guid=='')
        {
            ErrorLog(  qy_id ,"在生成工作任务时发生错误， 数据是："+JSON.toString( rowData));
        }else
        {
            println( guid);
        }
        
    }
     
    println("导入完成时间： "+newDate()+" ============================================");
    
}




//新办　
function   import_ds_dehd( excelSheet)
{

     println("导入开始时间： "+newDate()+" =======  新办纳税人定额核定工作 ==================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
  
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
    
    var flowID=5; //新办
    var today=date2yyyymmdd(currentDate());
    var y =getYear(currentDate()) ;
    var m =getMonth(currentDate());
    var rq =''+date2yyyymmdd(thisMonthFirstDay(y,m));  //月初
    var rq1=''+date2yyyymmdd( nextMonthFirstDay(y,m));//下月初
    var sy='';//工作要求
         
    for( var r=5; r<100000;r++)
    {
        
        var qy_id=safeValue(excelSheet, r, colIndex['qy_id']);
        if( qy_id=='') break;
        
        var ym=''+safeValue(excelSheet, r, colIndex['ym']);    
        if( ym !=''+(y*100+m) )
        {
            println("该数据不是"+m+"月的接口数据，忽略.");
            continue;
        }
        
        var rowData={};
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            rowData[  colName ]= v  ;
        }
        
        
        var cc= getIntFromSQL( "select count(a.id)  from flow_gzlzd1  a , oa_mywork  b  where  a.gguid=b.guid and  a.nsbm='"+rowData.qy_id+ "' and  b.state=0 and  b.flowid="+flowID );
	  
        if ( cc>0)
        {
            println(qy_id+"本月已生成任务，不需要再次生成");
            continue;
        }
    
        
       
	    sy="该纳税人截止"+ym+"，没有核定地税定额，请协助处理。";
        
        //生成草稿时，默认要填充的数据
        var data="<nsbm>"+qy_id+"</nsbm>"+
		"<gsbm>"+rowData.nsrsbh+"</gsbm>"+
		"<nsrmc>"+rowData.qymc+"</nsrmc>"+
		"<dz>"+rowData.scjydz +"</dz>"+
		"<xm_fr>"+rowData.xm_fr+"</xm_fr>"+    
		"<gddh_fr>"+rowData.gddh_fr+"</gddh_fr>"+    
		"<sspq>"+rowData.szpqbm +"</sspq>"+		
 		"<czybm>"+rowData.czybm+"</czybm>"+
		"<qfrq>"+today+"</qfrq>"+
		"<sy>"+sy+"</sy>"+//工作内容说明
		"<bh>"+rowData.bh+"</bh>"+//工作编号
		"<gzdl>地税</gzdl>"+
		"<gzlb>03</gzlb>"+
		"<qfr>1</qfr>"+
		"<cbje>"+rowData.cbje+"</cbje>"+
		"<gzsx>03.01</gzsx>";	
 				
		//工作主题
        var subject= qy_id + rowData.qymc+"（定额核定工作）";
        //工作起草人
       
        var sqrID=userName2UserId(rowData.czybm );
        println( sqrID);
        if( test) sqrID=1;
        if(sqrID<0)
        {
            ErrorLog( qy_id ,"指定的起草人"+rowData.czybm +"不是合法的注册用户，数据忽略");
            continue;
        }		
		//生成工作任务
        var guid=newWork(flowID,sqrID,subject,"",0,today,data);  
        if(guid=='')
        {
            ErrorLog(  qy_id ,"在生成工作任务时发生错误， 数据是："+JSON.toString( rowData));
        }else
        {
            println( guid);
        }
        
    }
     
    println("导入完成时间： "+newDate()+" ============================================");
    
}


//停业　
function   import_ds_ty( excelSheet)
{

     println("导入开始时间： "+newDate()+" =======  停业核查工作 ==================================");
	//哪些字段需要导入
    var headRow =4; //字段行 
  
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
    
    var flowID=7; //停业
    var today=date2yyyymmdd(currentDate());
    var y =getYear(currentDate()) ;
    var m =getMonth(currentDate());
    var rq =''+date2yyyymmdd(thisMonthFirstDay(y,m));  //月初
    var rq1=''+date2yyyymmdd( nextMonthFirstDay(y,m));//下月初
    var sy='';//工作要求
         
    for( var r=5; r<100000;r++)
    {
        
        var qy_id=safeValue(excelSheet, r, colIndex['qy_id']);
        if( qy_id=='') break;
        
        var ym=''+safeValue(excelSheet, r, colIndex['ym']);    
        if( ym !=''+(y*100+m) )
        {
            println("该数据不是"+m+"月的接口数据，忽略.");
            continue;
        }
        
        var rowData={};
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            rowData[  colName ]= v  ;
        }
        
        
        var cc= getIntFromSQL( "select count(a.id)  from flow_gzlzd1  a , oa_mywork  b  where  a.gguid=b.guid and  a.nsbm='"+qy_id+"' and  a.qfrq >= '"+rq+"' and a.qfrq < '"+rq1+"'  and  b.flowid="+flowID );
	  
        if ( cc>0)
        {
            println(qy_id+"本月已生成任务，不需要再次生成");
            continue;
        }
    
        
       
	    sy="该纳税人"+ym+'期内停业，请核查。';
        //生成草稿时，默认要填充的数据
        var data="<nsbm>"+qy_id+"</nsbm>"+
		"<gsbm>"+rowData.nsrsbh+"</gsbm>"+
		"<nsrmc>"+rowData.qymc+"</nsrmc>"+
		"<dz>"+rowData.scjydz +"</dz>"+
		"<xm_fr>"+rowData.xm_fr+"</xm_fr>"+    
		"<gddh_fr>"+rowData.gddh_fr+"</gddh_fr>"+    
		"<sspq>"+rowData.szpqbm +"</sspq>"+		
 		"<czybm>"+rowData.czybm+"</czybm>"+
		"<qfrq>"+today+"</qfrq>"+
		"<sy>"+sy+"</sy>"+//工作内容说明
		"<bh>"+rowData.bh+"</bh>"+//工作编号
		"<gzdl>地税</gzdl>"+
		"<gzlb>01</gzlb>"+
		"<qfr>1</qfr>"+
		"<cbje>"+rowData.cbje+"</cbje>"+
		"<gzsx>01.01</gzsx>";	
 				
		//工作主题
        var subject= qy_id + rowData.qymc+"（停业核查工作）";
        //工作起草人
       
        var sqrID=userName2UserId(rowData.czybm );
        println( sqrID);
        if( test) sqrID=1;
        if(sqrID<0)
        {
            ErrorLog( qy_id ,"指定的起草人"+rowData.czybm +"不是合法的注册用户，数据忽略");
            continue;
        }		
		//生成工作任务
        var guid=newWork(flowID,sqrID,subject,"",0,today,data);  
        if(guid=='')
        {
            ErrorLog(  qy_id ,"在生成工作任务时发生错误， 数据是："+JSON.toString( rowData));
        }else
        {
            println( guid);
        }
        
    }
     
    println("导入完成时间： "+newDate()+" ============================================");
    
}

//导入 dj_swdjnb
function   import_dj_swdjnb( excelSheet)
{

     println("导入开始时间： "+newDate()+" ============================================");
	//哪些字段需要导入
    var headRow =4; //字段行
 
    var sql=" (qynm int not null,    qy_id varchar(30) null, nsrsbh   varchar(40) null, "+
                               "  qymc varchar(200) null,	hybm  int null, "+
                               " djzclxbm int null,	scjydz varchar(200) null, xm_fr varchar(50) null,	gddh_fr varchar(100 )  null, "+
                               " swbmbm_dj  int null,	swbmbm_gl int  null, szpqbm int null,	nsrztbm int null, "+
                               " primary key( qynm) )";
 
    //建表                              

    runSQL("", "drop  table t_dj_swdjnb  " ,true);
    runSQL("", "create table t_dj_swdjnb  "+sql,true);
    
  	var ds=newDataStore("","select * from t_dj_swdjnb");
    ds.setUpdateProperty("t_dj_swdjnb","qynm","*","qynm");
    
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
            
    var  qynmExist={}; //避免重复
            
    for( var r=5; r<100000;r++)
    {
        
        var qynm=safeValue(excelSheet, r, colIndex['qynm']);
        
        if( qynm=='') break;
        if( qynmExist[qynm]!=undefined)
        {
            println( "第"+r+"行中的企业内码与第"+qynmExist[qynm]+"行中的重复,本行数据忽略");
            continue;
        }
        
        qynmExist[qynm]=r;
        
        var row=ds.insertRow(9999);
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            ds.setValue(row, colName , v);
        }
     }
     
     println("本文件包含"+ds.getRowCount()+"笔数据");
     if(!ds.update(true)) 
     {
         println( "保存失败："+ ds.getError().getMessage());
  
     }else
     {
       //构建 update语句 ，用临时表中的数据更新
        var sql="update dj_swdjnb set ";
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            sql = sql+ " dj_swdjnb."+colName+"= t_dj_swdjnb."+colName+",";
        }
        sql=sql.substring(0, sql.length-1);
        sql=sql+" from dj_swdjnb , t_dj_swdjnb where dj_swdjnb.qynm =  t_dj_swdjnb.qynm ";
        
        runSQL("",sql,true);
        //新的纳税人插入
        runSQL("", " insert into dj_swdjnb ("+colList+") select "+colList+" from t_dj_swdjnb where not exists (select qynm from dj_swdjnb where dj_swdjnb.qynm=t_dj_swdjnb.qynm )", true);
        
     }
     
     println("导入完成时间： "+newDate()+" ============================================");
    
}


//导入 个体税收收入信息
function   import_ds_kh( excelSheet)
{

     println("导入开始时间： "+newDate()+" ============================================");
	//哪些字段需要导入
    var headRow =4; //字段行
 
    var sql=" ( id varchar(40) not null, jied  varchar(50)  null, y   int  null , m int  null , qnlj int  null ,"+
              " gt102 decimal(20,2) null, gt1124000 decimal(20,2) null, gt1059002 decimal(20,2) null, gt1059008 decimal(20,2) null, "+
              " wt102 decimal(20,2) null, wt1059002 decimal(20,2) null, wt1020910 decimal(20,2) null, wt1124000 decimal(20,2) null, wt1059008 decimal(20,2) null, "+
              " rkl decimal(20,2) null, sbl  decimal(20,2) null, "+
              " primary key(id) )";
 
    //建表                              

    runSQL("", "drop  table jk_kh_tmp  " ,true);
    runSQL("", "create table jk_kh_tmp  "+sql,true);
    runSQL("", "create table jk_kh  "+sql,true);
    
  	var ds=newDataStore("","select * from  jk_kh_tmp");
    ds.setUpdateProperty("jk_kh_tmp","id","*","id");
    
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
            
    var  jiedExist={}; //避免重复
            
    for( var r=5; r<100000;r++)
    {
        
        var jied=safeValue(excelSheet, r, colIndex['jied']);
        var qnlj=safeValue(excelSheet, r, colIndex['qnlj']);
        if( jied=='') break;
        if( jiedExist[jied+qnlj]!=undefined)
        {
            println( "第"+r+"行中的街道与第"+jiedExist[jied]+"行中的重复,本行数据忽略");
            continue;
        }
        
        jiedExist[jied+qnlj]=r;
        
        var row=ds.insertRow(9999);
        ds.setValue(row,"id", newGUID());
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            ds.setValue(row, colName , v);
        }
     }
     
     println("本文件包含"+ds.getRowCount()+"笔数据");
     if(!ds.update(true)) 
     {
         println( "保存失败："+ ds.getError().getMessage());
  
     }else
     {
       //构建 update语句 ，用临时表中的数据更新
        var sql="update jk_kh set ";
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            sql = sql+ " jk_kh."+colName+"= jk_kh_tmp."+colName+",";
        }
        sql=sql.substring(0, sql.length-1);
        sql=sql+" from jk_kh , jk_kh_tmp where jk_kh.jied=jk_kh_tmp.jied and  jk_kh.y=jk_kh_tmp.y and  jk_kh.m=jk_kh_tmp.m and  jk_kh.qnlj=jk_kh_tmp.qnlj    ";
        
        runSQL("",sql,true);
        //新的纳税人插入
        runSQL("", " insert into jk_kh (id,"+colList+") select id,"+colList+" from jk_kh_tmp where not exists (select id from jk_kh where  jk_kh.jied=jk_kh_tmp.jied and  jk_kh.y=jk_kh_tmp.y and  jk_kh.m=jk_kh_tmp.m and  jk_kh.qnlj=jk_kh_tmp.qnlj    )", true);
        
     }
     
     println("导入完成时间： "+newDate()+" ============================================");
    
}




//导入 dj_swdjzb
function   import_dj_swdjzb( excelSheet)
{

     println("导入开始时间： "+newDate()+" ============================================");
	//哪些字段需要导入
    var headRow =4; //字段行

    var sql=" (qynm int not null,    qy_id varchar(30) null,  nodeid int null, nsrsbh   varchar(40) null, "+
                               "  qymc varchar(200) null,	hybm  int null, "+
                               " djzclxbm int null,	scjydz varchar(200) null, scjydzlxdh varchar(200) null,xm_fr varchar(50) null, "+
                               " zzhm_fr varchar(50) null,	gddh_fr varchar(100 )  null, yddh_fr varchar(100 )  null,"+
                               " swbmbm_dj  int null,"+
                               " primary key( qynm) )";
 
    //建表                              
    runSQL("", "drop  table t_dj_swdjzb  " ,true);
    runSQL("", "create table t_dj_swdjzb  "+sql,true);
    
  	var ds=newDataStore("","select * from t_dj_swdjzb");
    ds.setUpdateProperty("t_dj_swdjzb","qynm","*","qynm");
    
    var cols=[];
    var colIndex={};
    var colList="";
    //把字段行中的字段读出来
	for(var ci=1;ci<100;ci++)
	{
		var colName=safeValue(excelSheet, headRow,ci);				
		colName=trim(colName);				
		if(colName=="")continue;				
		cols[cols.length]=colName;				
		colIndex[colName]=ci;				
		colList= colList+","+colName;
	}
 	println(JSON.toString (colIndex));
    colList= colList.substring(1); //去掉最前面的逗号        
            
    var  qynmExist={}; //避免重复
            
    for( var r=5; r<100000;r++)
    {
        
        var qynm=safeValue(excelSheet, r, colIndex['qynm']);
        
        if( qynm=='') break;
        if( qynmExist[qynm]!=undefined)
        {
            println( "第"+r+"行中的企业内码与第"+qynmExist[qynm]+"行中的重复,本行数据忽略");
            continue;
        }
        
        qynmExist[qynm]=r;
        
        var row=ds.insertRow(9999);
        ds.setValue(row,"nodeid","330400");
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            var v= safeValue(excelSheet, r , colIndex[colName] );
            ds.setValue(row, colName , v);
        }
     }
     
     println("本文件包含"+ds.getRowCount()+"笔数据");
     if(!ds.update(true)) 
     {
         println( "保存失败："+ ds.getError().getMessage());
  
     }else
     {
       //构建 update语句 ，用临时表中的数据更新
        var sql="update dj_swdjnb set ";
        for( var c=0;c<cols.length;c++)
        {
            var colName= cols[c];
            sql = sql+ " dj_swdjnb."+colName+"= t_dj_swdjnb."+colName+",";
        }
        sql=sql.substring(0, sql.length-1);
        sql=sql+" from dj_swdjzb , t_dj_swdjzb where dj_swdjzb.qynm =  t_dj_swdjzb.qynm ";
        
        runSQL("",sql,true);
        //新的纳税人插入
        var notNullCols={
                nodeid:330400,
                swdjblxbm:2,
                swdjzlbm:7,
                zzjgdm:"''",
                gshbj:0,
                gsjgbm_pzjg:0,
                gsfzrq:0,
                pzrq:0,
                kyrq:0,
                scjyqx_qs:0,
                scjyqx_zz:0,
                zjbm:0,
                zzhm:"''",
                hhrs:0,
                cyrs:0,
                wjrs:0,
                lsdjyxqx:0,
                dwxzbm:0,
                kjzdbm:0,
                bzrq:0,
                hzrq:0,
                yzrq:0,
                fffbsl:0,
                hsxsbm:0,
                nsrztbm:0,
                nsbj:0,
                jfbj:0,
                gsqyglrdrq:0,
                bghxgbj:0,
                djsx:0,
                djsx2:0,
                djsx3:0,
                djsx4:0,
                id_qy:"''",
                sbhnsr:"''",
                czrq:0,
                czybm:0,
                sbh:0,
                csbj:0
            };
        var  moreCols ="", moreValues="";
        for( var col in  notNullCols)
        {
            moreCols=moreCols+ col+",";
            moreValues=moreValues+ notNullCols[col]+",";
        }

        runSQL("", " insert into dj_swdjzb ("+moreCols+colList+") select "+moreValues+colList+" from t_dj_swdjzb where not exists (select qynm from dj_swdjzb where dj_swdjzb.qynm=t_dj_swdjzb.qynm )", true);
        
     }
     
     println("导入完成时间： "+newDate()+" ============================================");
    
}



/**
data 是数据包
ri是行号
ci是列号
*/
function safeValue(excelSheet,row,col,isdate)
{
 	
	if(isdate==undefined)isdate=false;	
	var pos="r"+row+"c"+col;	
	//println( pos);
	var v=excelSheet.cells[pos+(isdate?"_date":"")];
 	if(v==undefined)return "";	
	return ''+trim(v);	
	
}

// 生成错误提示便于查看
function ErrorLog(xh,tip)
{
	println(" 企业编码为 "+xh+"     "+tip);	
}