/*

核心思想： 把收款按应收进行先进先出核销， 并计算各个帐期的应收款

*/


function main()
{
    
    var ssdw='A330001';
    var y =2011;  //需要统计的年月
    var m = 7;

    var ym = beforeMonth(y,m,0);  //当期
    var ym1 = beforeMonth(y,m,1);  //上期 
    var ym3 = beforeMonth(y,m,3);  //3月前
    var ym6 = beforeMonth(y,m,6);  //6月前
    var ym12 = beforeMonth(y,m,12);  //12月前
    var ym24 = beforeMonth(y,m,24);  //2月前
    var ym36 = beforeMonth(y,m,36);  //36月前 
    var ym99 = 0;  // 有史以来
    
    /* 由于需要统计每个帐期内的应付合计，所以需要用    日期1 < 帐期 <日期2 
    
    当统计大于24个月的应收时， 条件就是       36个月前  =<  ym <  24月前
     当统计大于36个月的应收时， 条件就是       0  =<ym < 36个月前
     
     所以需要拼一个ym99 
    
     在下面的循环时，只需要循环到 ym36 
    */

    
    var yms=[ym,ym1,ym3,ym6,ym12,ym24,ym36,ym99];   //实际的年月
    var ym_suffix= [ '','1','3','6','12','24','36','99']; //后缀名称 
    
    runSQL(""," create  index  di_hs_fyx_sr on   hs_fyx_sr  ( h_dwdmx , h_xmxh , h_kmdm, h_ly , ym1 )");
 
     
    //本期应收,收款
    
    var sql = "  select    h_xmxh , h_kmdm ,sum( case  when h_ly='XM.SK'    and  ym1 ="+ ym + "   then je else 0 end ) as bq_sk   \n"  ; //本期收款，实际上只";
    
    //第一步：按帐期计算出各个帐期的应收余额
    for( var i=0;i<yms.length -1 ;i++)
    {
        
        sql=sql+",sum(  case  when h_ly='XM.JDSR'  and  ym1<="+ yms[i]+ " then je else 0 end ) as lj_ys"+ym_suffix[i]+"  \n" +  //累计应收
                ",sum(  case  when h_ly='XM.SK'    and  ym1<="+ yms[i]+ " then je else 0 end ) as lj_sk"+ym_suffix[i]+"  \n" +   //累计收款
                ",sum(  case  when h_ly='XM.JDSR'  and  ym1<="+ yms[i]+ " and  ym1 >"+ yms[i+1]+ "   then je else 0 end ) as bq_ys"+ym_suffix[i]+"  \n"  ; //本期应收

     
    }
           
               
                 
    sql=sql+  " from  hs_fyx_sr   where  h_dwdmx ='"+ssdw+"'   \n"+
              " group by h_xmxh ,h_kmdm  ";
     
    // println( sql );
     println("----------------------------------------------------------------------------------------");
     
    //第二步，把总收款进行先进先出的核销处理


    var sql2="select h_xmxh , h_kmdm , lj_ys , "+ //累计应收
               "  lj_sk , "+//累计收款
               " lj_ys - lj_sk as lj_ye , "+ //累计余额 
               " bq_sk ";  //本月收款 

    
    var ye_formula="lj_sk";
    /*
    下面是把收款合计按先进先出分滩到每个帐期中 ，
    
      当余额  > 帐期内应付合计时，表示当期没有应付了 
      当余额大于0且 < 帐期内应付合计时 ，表示当期部分核销，
      当余额小于0时，表示当期全部都是应付款
    
    */
    //最后一个99是边界，不需要处理
     for( var i= yms.length -1-1; i>=0;i--)
    {
        if( i< yms.length-1) ye_formula = ye_formula + " - bq_ys"+ym_suffix[i];
          
        sql2 = sql2+", case when ("+ye_formula+")< 0 then bq_ys"+ym_suffix[i] + //如果余额小于0，表示没有收款供核销了，所以本期的应收都是应收款 
        " when bq_ys"+ym_suffix[i]+">("+ye_formula+") then bq_ys"+ym_suffix[i]+"-("+ye_formula+") "+ //如果还有余额，那么如果本期间的应收大于可供核销的余额，那么部分核销后剩下的就是应收款
        " else 0 end as ye"+ym_suffix[i]+'_'+ym_suffix[i+1]+"\n";// 如果可供核销的金额大于本期单内的应付，那么全部核销掉，本期单没有应付款了
          
    }
    
    sql2=sql2+" from  (\n"+ sql+") ys_temp ";
                            
    sql2=" select * from (\n"+sql2+"\n) ys_temp where lj_ye<>0 \n";
    
    println( sql2);
    
    
}


//指定年月之前n个月的日期的年月
function  beforeMonth( y , m ,n)
{
    var d= thisMonthFirstDay(y,m);
    if( n==0) return y*100+m;
    d= nextDate( d , -n , 'month');
    return getYear(d)*100+getMonth(d);
}

