/***********************************************************************************************************************

本示例演示了如何从第三方数据库的数据生成工作任务

  关于本示例的背景知识请参看本应用发布目录下\doc\与杭州地税在线监控系统的融合.doc

   如何使用本程序来完成定时生成工作任务
         1 新建一个任务调试
		 2 将任务调试设置成仅某一个系统管理员能执行
		 3 任务执行频率是每１分钟执行一次
		 4 修改　var data = .... 这个参数，把相关信息在生成工作任务的同时填写到相应主表的需要的字段中


***********************************************************************************************************************/
 function main()
{
		
	//得到上一次从在线监控税数据取数已经取到哪里了　　
	var lastXH=cInt(getConfig("TaxSource\\lastXH"));
	println("上次行号："+cStr(lastXH));
	var TF2000="jdbc/tf2000";
	var path="TaxSource\\lastXH";
	//配置信息
	var dsConfig=newDataStore(TF2000,"select  *  from QR_PGLXBM ");
	
	dsConfig.retrieve();
	
	// 税源，按xh排，那么最后一个就是最大的一个XH，记录下来，备用
	var dssy=newDataStore(TF2000,"select * from QR_PGLC where XH >"+lastXH+"  order by XH asc ");
	
	dssy.retrieve();
	
	RC=dssy.getRowCount();
	
	var i;
	println("行数 ："+cStr(RC));
	for(i=0;i<RC;i++)
	{
		var XH=dssy.getInt(i,"XH");		
		// 序号
		var QYNM=dssy.getInt(i,"QYNM");		
		// 企业内码
		var SXBM=dssy.getInt(i,"SXBM");		
		// 属性编码
		var SQRQ=dssy.getInt(i,"SQRQ");		
		// 申请日期
		var SQR=dssy.getString(i,"SQR");		
		// 申请人
		var SQLY=dssy.getString(i,"SQLY");		
		// 申请理由
		var PGLXBM=dssy.getInt(i,"PGLXBM");		
		// -派工类型编码
		var FPR=dssy.getString(i,"FPR");		
		// 分派人	
		var fr=dsConfig.find(" PGLXBM == "+PGLXBM,0,9999);
		
		if(fr<0)
		{
			ErrorLog(XH,"派工类型编码="+PGLXBM+"没有找到对应工作流程类型");
			continue;
		}
		
		var sqrID=userSSOName2UserId(SQR);
		
		if(sqrID<0)
		{
			ErrorLog(XH,"指定的申请人"+SQR+"不是合法的注册用户");
			continue;
		}
		
		var fprID=userSSOName2UserId(FPR);
		
		if(fprID<0)
		{
			ErrorLog(XH,"指定的分配人"+FPR+"不是合法的注册用户");
			continue;
		}
		
		//得到申请人的核算单位
		var unit=unitOfUser(sqrID);
		
		// 得到对应的工作流程id
		var PGLXBM_XTBG=dsConfig.getInt(fr,"PGLXBM_XTBG");
		
		flowID=getFlowId(PGLXBM_XTBG,unit);
		
		if(flowID<0)
		{
			ErrorLog(XH,"无法找到对应的流程,请确信在在线监控里已经做好了相关配置");
			continue;
		}
		
		var PGLXMC=dsConfig.getString(fr,"PGLXMC");
		var sql=" select  QYNM ,SWDJZH, QY_ID ,MC,QYDZ,QYLXDH,  FDDBR , CWFZR,ZYFW, JYFW,ZCZB,JJXZBM   " +
			               "    from DJ_SWDJZB where QYNM="+cStr(QYNM);
		println("sql:"+sql);		       
		//取得纳税人相关信息
		var ds2=newDataStore(TF2000,sql);
		
		ds2.retrieve();
		
		if(ds2.getRowCount()==0) ds2.insertRow(0);
				
		//把取出的信息拼成一串，为什么要这么拼，请参看函数　newWork 的详细说明
		// 注意，比如需要将企业名称填入到工作表单主表的　nsrmc字段时，
		// 那么需要这样写 .... +     "<nsrmc>"+ds2.getString(0,"MC")+"</nsrmc>" + ...
		//
		var data="<qynm>"+ds2.getString(0,"QYNM")+"</qynm>"+
		"<qyswdjzh>"+ds2.getString(0,"QY_ID")+"</qyswdjzh>"+
		"<qymc>"+ds2.getString(0,"MC")+"</qymc>"+
		"<qydz>"+ds2.getString(0,"QYDZ")+"</qydz>"+
		"<qylxdh>"+ds2.getString(0,"QYLXDH")+"</qylxdh>"+
		"<fddbr>"+ds2.getString(0,"FDDBR")+"</fddbr>"+
		"<cwfzr>"+ds2.getString(0,"CWFZR")+"</cwfzr>"+
		"<zyfw>"+ds2.getString(0,"ZYFW")+"</zyfw>"+
		"<jyfw>"+ds2.getString(0,"ZYFW")+"</jyfw>"+
		"<zczb>"+ds2.getString(0,"ZCZB")+"</zczb>"+
		"<jjxzbm>"+ds2.getString(0,"JJXZBM")+"</jjxzbm>";		
 		 
		//工作主题
		var subject=PGLXMC+"("+ds2.getString(0,"QY_ID")+ds2.getString(0,"MC")+")";
		
		// 工作生成日期
		// SQRQ是数据型表示的日期，比如　20050101,现在需要把它转换成2005.01.01格式　
		var rq=''+SQRQ;
		
		rq=mid(rq,0,4)+"."+mid(rq,4,6)+"."+mid(rq,6,8);
		println("流程id："+cStr(flowID));
		println("申请人id："+cStr(sqrID));
		println("主题："+subject);
		println("内容："+data);
		//生成工作任务
		var guid=newWork(flowID,sqrID,subject,"",0,rq,data);
		println("guid="+guid);
		if(guid=="")
		{
			ErrorLog(XH,"xh="+XH+"的税源在生成工作任务时发生错误，原因请查看应用服务器的日志　");
		}
		else 
		{
			var result=commitFirstStep(guid,fprID,0);			
			if(result!="")
			{
				ErrorLog(XH,"xh="+XH+"的税源在生成工作任务后，提交审批时发生错误，原因是："+result);
			}
		}
		ds2=null;
		
	} //循环结束
	
     // 设置本次已经读取到哪儿了，下次将接着往现取数据
	if(RC>0)
	{
		var maxXH=dssy.getInt(RC-1,"XH");
		setConfig(path,maxXH);
	}
	　
}



//得到派工类型对应于协同平台里的流程类型ID
// PGLXBM_XTBG通常就是对应的协同平台里流程类型的ID，但
// 为了解决多核算单位只有一个配置的问题，可能会在流程类型的编码处设置一个数字型的编码，这样，
// 一个配置就可以对应到不同核算单位中的不同流程。

 
function getFlowId(PGLXBM_XTBG,unit)
{
	return getIntFromSQL(" select id from  oa_flow where  unit="+unit+" and  id="+PGLXBM_XTBG );	
}


// 生成错误提示便于查看
function ErrorLog(xh,tip)
{
	alert(" xh="+xh+"     "+tip);	
}