/**************************************************************************************************************************************************

把 datastore中指定的行，转换成一个 Js对象。注意，字符串被转换成了js的String对象，而不是Java的String对象
但日期型字段仍是Java的Date类型 

**************************************************************************************************************************************************/
function datastoreRow2JSON(ds ,row)
{
   
   var data={ };
   for (var j = 0; j < ds.getColumnCount(); j++)
   {
    var v=null; 
    var ut=ds.getColumnProperty(j).getUniformDataType();
   
    switch (ut)
     {
     case 1: 
      //UniformDataType.$Integer 
      v = ds.getInt(row,j);
      break; 
     case 2:
      //UniformDataType.$Numeric :
      v = ds.getDouble(row,j);
      break;
     case 3://UniformDataType.$String :
      v = ''+ds.getString(row,j);
      break;
     case 4://UniformDataType.$Datetime :
      v = ds.getDate(row,j);
      break;
     default :
      v = ''+ds.getString(row,j);
    }

    data[ds.getColumnName(j)]=v;

   }
   return data;
}

