/*
Copyright (c) 2005 JSON.org
    与在浏览器中运行的json.js 有稍微的不同，去掉了 parse 中 正则表达式部分
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The Software shall be used for Good, not Evil.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
 */

/*
 The global object JSON contains two methods.

 JSON.stringify(value) takes a JavaScript value and produces a JSON text.
 The value must not be cyclical.

 JSON.parse(text) takes a JSON text and produces a JavaScript value. It will
 return false if there is an error.
 */
var JSON = function() {
	var m = {
		'\b' : '\\b',
		'\t' : '\\t',
		'\n' : '\\n',
		'\f' : '\\f',
		'\r' : '\\r',
		'"' : '\\"',
		'\\' : '\\\\'
	}, s = {
		'boolean' : function(x) {
			return String(x);
		},
		number : function(x) {
			return isFinite(x) ? String(x) : 'null';
		},
		string : function(x) {

			if (/["\\\x00-\x1f]/.test(x)) {
				x = x.replace(/([\x00-\x1f\\"])/g, function(a, b) {
					var c = m[b];
					if (c) {
						return c;
					}
					c = b.charCodeAt();
					return '\\u00' + Math.floor(c / 16).toString(16)
							+ (c % 16).toString(16);
				});
			}
			return '"' + x + '"';
		},
		object : function(x, objCache) {

		
			
			if (x) {

				var javaClass = javaClassName(x);// javaClassName 在 util.js中

				if (javaClass == 'java.util.Date') {
					return '"' + date2yyyymmdd(x) + ' '
							+ right('00' + getHour(x), 2) + ':'
							+ right('00' + getMinute(x), 2) + ':'
							+ right('00' + getSecond(x), 2) + '"';
				}

				if (javaClass == 'java.lang.String') {

					return s.string('' + x);
				}

				if (javaClass == 'java.math.BigDecimal') {

					return s.string('' + x);
				}

				if (javaClass != '') {
					println('JSON.toString没有处理的Java类型:' + javaClass);
					return x.toString(); // 
				}

				var a = [], b, f, i, l, v;
				if (x instanceof Array) {
					a[0] = '[';
					l = x.length;
					for (i = 0; i < l; i += 1) {
						v = x[i];
						f = s[typeof v];
						if (f) {
						 
							v = f(v, objCache);
						 

							if (typeof v == 'string') {
								if (b) {
									a[a.length] = ',';
									// a[a.length] = '\n'; //加一个回车， 好查看一点
								}
								a[a.length] = v;
								b = true;
							}
						}
					}
					a[a.length] = ']';
					// a[a.length] = '\n'; //加一个回车， 好查看一点

				} else if (x instanceof Object) {
					
					if (objCache.contains(x))
						return '"本对象可能存在循环引用."';
		            
					objCache.push(x) ;

					a[0] = '{';
					for (i in x) {
						v = x[i];
						f = s[typeof v];
						if (f) {
						 
							v = f(v,objCache);
						 
							if (typeof v == 'string') {
								if (b) {
									a[a.length] = ',';
									// a[a.length] = '\n'; //加一个回车， 好查看一点
								}
								a.push(s.string(i), ':', v);
								b = true;
							}
						}
					}
					a[a.length] = '}';
					// a[a.length] = '\n'; //加一个回车， 好查看一点

				} else {
					return;
				}
				return a.join('');
			}
			return 'null';
		}
	};
	return {
		copyright : '(c)2005 JSON.org',
		license : 'http://www.crockford.com/JSON/license.html',
		/*
		 * Stringify a JavaScript value, producing a JSON text.
		 */
		toString : function(v) {
			// 2009.06.25把java
			// String对象强制转换成js字符串,不然会变成类似于{bytes=[-72,-16,-49,-14,-70,-20],
			// empty=false}的结果

			var objCache = [];

			var t = typeof v;

			var f = s[typeof v];
			if (f) {
				var ret = f(v, objCache);
			 
				if (typeof ret == 'string') {
					return ret;
				}
			}
			return null;
		},
		/*
		 * Parse a JSON text, producing a JavaScript value. It returns false if
		 * there is a syntax error. 与在浏览器中运行的json.js 有稍微的不同，去掉了正则表达式部分
		 */
		parse : function(text) {
			try {
				return eval('(' + text + ')');
			} catch (e) {
				// 当字符串中有异常的回车符时，解析会出问题，所以需要替换掉回车符等后再试一次
				text = '' + text; // 去掉回车
				text = text.replace(/\n/g, '');
				text = text.replace(/\r/g, '');

				try {
					return eval('(' + text + ')');
				} catch (e) {
					println("json parser second time error:" + JSON.toString(e));
					return false
				}

			}
		}
	};
}();
