/* 
* 方法:Array.removeAt(Index) 
* 功能:删除数组元素. 
* 参数:Index删除元素的下标. 
* 返回:在原数组上修改数组 
*/ 

Array.prototype.removeAt=function(Index) 
{ 
   if(isNaN(Index)||Index>this.length){return false;} 
   for(var i=0,n=0;i<this.length;i++) 
   { 
    if(this[i]!=this[Index]) 
    { 
       this[n++]=this[i] 
    } 
   } 
   this.length-=1 
} 
             
/*                            
* 方法:Array.remove(obj)     
* 功能:删除数组元素.        
* 参数:要删除的对象.    
* 返回:在原数组上修改数组   
*/                           
                               
Array.prototype.remove=function(obj) 
{ 
   if(null==obj){return;} 
   for(var i=0,n=0;i<this.length;i++) 
   { 
    if(this[i]!=obj) 
    { 
     this[n++]=this[i]; 
    } 
   } 
   this.length-=1 
} 

/*                            
* 方法:Array.Contains(obj)     
* 功能:确定某个元素是否在数组中.        
* 参数:要查找的Object对象 
* 返回:找到返回true,否则返回false; 
*/                                                
Array.prototype.contains=function(obj) 
{ 
   if(null==obj){return;} 
   for(var i=0,n=0;i<this.length;i++) 
   { 
    if(this[i]==obj) 
    { 
     return true; 
    } 
   } 
  
   return false; 
} 


/*                            
* 方法:Array.IndexOf(obj)     
* 功能:搜索指定的Object,并返回第一个匹配项从零开始的索引        
* 参数:要查找的Object对象   
* 返回:找到返回该元素在数组中的索引,否则返回-1 
*/ 
Array.prototype.indexOf=function(obj) 
{ 
   if(null==obj){return;} 
   { 
    for(var i=0,n=0;i<this.length;i++) 
    { 
     if(this[i]==obj) 
     { 
      return i; 
     } 
    }   
   } 
  
   return -1; 
} 

/*                            
* 方法:Array.Clear()     
* 功能:消空数组元素.        
* 参数:无.    
* 返回:空数组 
*/ 
Array.prototype.clear=function()                                   
{                                                                  
   this.length=0;                                             
} 


/*                            
* 方法:Array.Contains(obj)     
* 功能:确定某个元素是否在数组中.        
* 参数:要查找的Object对象 
* 返回:找到返回true,否则返回false; 
*/                                                
Array.prototype.each=function( func) 
{ 
   
   for(var i=0,n=0;i<this.length;i++) 
   { 
      func(  this[i],i);
   } 
  
} 


if (!Array.prototype.forEach) {  
    Array.prototype.forEach = function(callback, thisArg) {  
        var T, k;  
        if (this == null) {  
            throw new TypeError(" this is null or not defined");  
        }  
        var O = Object(this);  
        var len = O.length >>> 0; // Hack to convert O.length to a UInt32  
        if ({}.toString.call(callback) != "[object Function]") {  
            throw new TypeError(callback + " is not a function");  
        }  
        if (thisArg) {  
            T = thisArg;  
        }  
        k = 0;  
        while (k < len) {  
            var kValue;  
            if (k in O) {  
                kValue = O[k];  
                callback.call(T, kValue, k, O);  
            }  
            k++;  
        }  
    };  
}  
