/*
创建逐级汇总
		dsname 需要逐级汇总的结果集名称 
	groupCol  按哪个字段进行逐级汇总 
	mcCol     逐级汇总的代码名称放在哪个字段中显示
	levels:对groupCol字段定义各个级别的长度，比如 [2,4] 表示一级代码２位，二级代码４位，即需要把groupCol中的数据，分别取4位，取2位进行汇总。2位，4位代码对应的名称放在mcCol指明的列中
	cols ： 需要汇总的字段名称数组，示例  ['a1','a2','a3']
	dmTable : 代码表，即groupCol对应的数据对应的代码表，以便取出代码名称
	dmCol :代码字段在代码表中的字段名称,
	cmMC  :在代码表中，名称对应的字段名

  示例：　gf_createGroup(dsname , 'dm','mc', [2,4],['sl','cy','qy','dl','qt'],'dm_nj','dm','mc');
*/

function gf_createGroup(dsname , groupCol ,mcCol, levels ,sumCols, dmTable, dmCol,dmMC)
{
	 
	var ds=book.getDataSource(dsname).getDataStore();
	 
	var sql0=ds.getSelectLastRetrieved();
	 
	 
	for( var i= levels.length-1; i>=0;i--) // 前几位汇总
	{
		var codeLen= levels[i];
		 
		var sql=[];
		sql.push( "select  substr("+groupCol+",1,"+codeLen+") as "+groupCol+",b."+dmMC+" as "+mcCol);
		for( var ci=0;ci<sumCols.length;ci++)
		{
		
			sql.push( "\n,sum("+ sumCols[ci]+") as "+sumCols[ci]);
			
		}
		
		
		 
		sql.push("\n from ("+sql0+") a left join  \n"+
		        "       (select "+dmCol+" as "+dmTable+"_"+dmCol+","+dmMC+" from "+dmTable+") b  \n"+  //只取代码，名称　两个字段，并且把代码表中的代码字段重命名，因为之后group by 中用到了代码字段，这里重命名是为了避免同名引起的字段不明确错误
			"       on ( b."+dmTable+"_"+dmCol+"= substr(a."+groupCol+",1,"+codeLen+ ")) \n "+
		        " group by substr("+groupCol+",1,"+codeLen+") , b."+dmMC);
	 
		var tsql= sql.join(' ');
		
		
		println(tsql);
		 
		var tds=newDataStore("",tsql );
		tds.retrieve();
		ds.setAutoResetBeforeRetrieve(false); //注意，是追加检索数据，即当前数据保留，把新检索的数据追加到后面
		ds.retrieve( tds.getData(),true );
		ds.setAutoResetBeforeRetrieve(true);
	}
	
	
	ds.setOrderBy( groupCol); //按这个字段排序
	ds.sort();
	
	
}
