/**
 * Created by 三宝爹 on 2017/7/8.
 *
 * 常规的JSON对象可以做到把简单数据映射到其它对象。比如  a.a=1 可以看成把'a'映射成1，
 * 而本类主要是用于把一个JSON对象映射为另一个JSON对象
 *
 * 下面的Map实现取自如下地址，并略做调整
 * https://stackoverflow.com/questions/368280/javascript-hashmap-equivalent

 The following script

 var map = new Map;

 map.put('spam', 'eggs').
 put('foo', 'bar').
 put('foo', 'baz').
 put({}, 'an object').
 put({}, 'another object').
 put(5, 'five').
 put(5, 'five again').
 put('5', 'another five');

 string spam : eggs
 string foo : baz
 object 1 : an object
 object 2 : another object
 number 5 : five again
 string 5 : another five
 Further considerations

 PEZ suggested to overwrite the toString() method, presumably with our hash function.
 This is not feasible because it doesn't work for primitive values (changing toString() for
 primitives is a very bad idea). If we want toString() to return meaningful values for
 arbitrary objects, we would have to modify Object.prototype, which some people
 (myself not included) consider verboten.

 */



    function Map()
    {
        this.map = {};
        this.current=0;
    }

// overwrite in Map instance if necessary

/**
 * 如果是字符串，那么直接用字符串的值做key，
 * 否则， 分配一个序号做hashkey ， 且这个key回设到原对象上的 __hash属性上，
 * 第一次访问value时，它没有，那么就是给增加一个__hash属性， 就从该对象的__hash属性上直接读取做为key
 * @param value
 * @returns {string}
 */
    Map.prototype.hash = function (value)
    {
        return (typeof value) + ' ' + (value instanceof Object ?
                (value.__hash || (value.__hash = ++ this.current)) :
                value.toString());
    };


    Map.prototype.containsKey = function (key)
    {
        var item = this.map[this.hash(key)];
        return item !=  undefined ;
    };

    Map.prototype.get = function (key)
    {
        var item = this.map[this.hash(key)];
        return item === undefined ? undefined : item.value;
    };

    Map.prototype.put = function (key, value)
    {
        var hash = this.hash(key);

        if (this.map[hash] === undefined)
        {
            var item = {key: key, value: value};
            this.map[hash] = item;
        }
        else
        {
            this.map[hash].value = value;
        }

        return this;
    };

    Map.prototype.remove = function (key)
    {
        var hash = this.hash(key);
        var item = this.map[hash];

        if (item !== undefined)
        {
            delete this.map[hash];
        }

        return this;
    };

// only works if linked
    Map.prototype.clear = function ()
    {
        this.map = {};
        return this;
    };

    Map.prototype.length = function ()
    {
        Object.getOwnPropertyNames(this.map).length;
    };

    Map.prototype.keys = function ()
    {
        var ret = [];
        for (var code in this.map)
        {
            if (this.map.hasOwnProperty(code))
            {
                ret.push(this.map[code].key);
            }
        }
        return ret;
    };

    Map.prototype.values = function ()
    {
        var ret = [];
        for (var code in this.map)
        {
            if (this.map.hasOwnProperty(code))
            {
                ret.push(this.map[code].value);
            }
        }
        return ret;
    };


    export default   Map  ;

