/**
 Created by mgso  2018/7/16 0016

 2020.04.06  当目标宽度大于实际图片宽度时，不要放大
             options.size 是宽及高的最小尺寸，如果宽大于高，那么高=options.size ,同比绽放宽。
            这么处理的目的是让缩略图能占满缩略图块，而不是出现空白


 */
/**
 * @param path 文件路径
 * @param options 包含宽,高,质量
 * @param callback 图片压缩后执行的回调函数
 */
function canvasDataURL(path, options, callback) {

    var t= path.substring(11,14).toLowerCase();
    //console.info(" file path="+ t);
    var imgType=  (t.startsWith('png')||t.startsWith('gif'))?'png':'jpeg';
    var img = new Image();
    img.crossOrigin = "*";  // 必须在image之前赋值 , but 它有没有用未经验证，加上总是没错
    img.src = path;
    img.onload = function () {
        var that = this;
        // 默认按比例压缩

        var w0=that.width;
        var h0=that.height;

        var w = that.width;
        var h = that.height;
        var scale = w / h;

        if( options.size && options.size<w && options.size<h )  //如果目标尺寸大于实际宽度，那么不要放大，
        {
            if( w> h)
            {
                w=options.size;
                h=w /scale;
            }else
            {
                h=options.size;
                w= h * scale;
            }
        }



        var quality = 0.9;  // 默认图片质量为0.9
        //生成canvas
        var canvas = document.createElement('canvas');


        var ctx = canvas.getContext('2d');
        // 创建属性节点
        var anw = document.createAttribute("width");
         $(canvas).appendTo( document.body);

        anw.nodeValue = w;
        var anh = document.createAttribute("height");
        anh.nodeValue = h;
        canvas.setAttributeNode(anw);
        canvas.setAttributeNode(anh);

        //
        // 原作者写的是 ctx.drawImage(that, 0, 0, w, h); 在常规屏幕上没有问题
        // 在 mac及手机上， 图片变成一片黑。原因可能是 hidpi-canvas这个注入了canvas，对drawImage函数做了处理，
        // 按下面的写法，结果正常
        ctx.drawImage(that, 0, 0, w0, h0,0, 0, w, h);
        // 图像质量
        if (options.quality && options.quality <= 1 && options.quality > 0) {
            quality = options.quality;
        }


        // quality值越小，所绘制出的图像越模糊
        var base64 = canvas.toDataURL('image/'+imgType, quality);
        // 回调函数返回base64的值
        callback(base64 , imgType);
    }
}

/**
 * @param file 文件对象
 * @param options 包含宽,高,质量
 * @param callback
 */
export function photoCompress(file, options, callback) {
    var ready = new FileReader();
    //开始读取指定的Blob对象或File对象中的内容.
    //当读取操作完成时,readyState属性的值会成为DONE
    // 如果设置了onloadend事件处理程序,则调用之.
    //同时,result属性中将包含一个data: URL格式的字符串以表示所读取文件的内容.
    ready.readAsDataURL(file);
    ready.onload = function () {
        var path = this.result;
        //callback( path);
        canvasDataURL(path, options, callback)
    }
}


/**
 *  上传文件方法
 * @param url   接收上传文件的后台地址
 * @param file
 * @param options
 * @param callback
 */

function uploadFile(url, file, options, configData, callback) {


    console.info( JSON.stringify(configData));

    photoCompress(file, options, function (base64Codes , imgType) {

        let form = new FormData(); // FormData 对象

        let bl = convertBase64UrlToBlob(base64Codes);
        configData.responseType="JSON"; //表示只需要返回JSON数据
        form.append("uploadData", encodeURI(JSON.stringify(configData))); //不做enodeURI，中文会乱码
        form.append("file", bl, "file_" + Date.parse(new Date()) + "."+imgType); // 文件对象

        /*

        let xhr = new XMLHttpRequest();  // XMLHttpRequest 对象

        xhr.open("post", url, true); //post方式，url为服务器请求地址，true 该参数规定请求是否异步处理。
        xhr.withCredentials = true; // 允许跨域操作
        xhr.onload = callback.onComplete; //请求完成
        xhr.onerror = callback.onerror; //请求失败
        xhr.upload.onprogress = callback.onprogress;
        xhr.upload.onloadstart = callback.onloadstart ;//上传开始执行方法
        xhr.send(form); //开始上传，发送form数据

        */

        axios.post(url, form, {
            timeout: 1000000,
            withCredentials: true,

            onUploadProgress: function (progressEvent) {
                callback.onprogress(progressEvent);
            }
        }).then(function (res) {
            callback.onComplete(res);
        })
            .catch(function (err) {
                console.error( err.message);
            });

    });

}

/**
 * 得到 图片的 base64编码后的内容 ，如果指定了宽度，高度，那么缩放它
 * @param img
 * @param w
 * @param h
 * @returns {string}
 */
function getBase64Image(img,w ,h ) {

    if( w==undefined) w= img.width;
    if( h==undefined) h= img.height;



    //生成canvas
    var canvas = document.createElement('canvas');

    var ctx = canvas.getContext('2d');
    // 创建属性节点
    var anw = document.createAttribute("width");
    $(canvas).appendTo( document.body);

    anw.nodeValue = w;
    var anh = document.createAttribute("height");
    anh.nodeValue = h;
    canvas.setAttributeNode(anw);
    canvas.setAttributeNode(anh);

    ctx.drawImage(img, 0, 0, img.width, img.height,0, 0, w, h); //缩放
    var dataURL = canvas.toDataURL("image/png",0.9); //100%质量
    return dataURL;

}

/**
 * base64转blod流
 * @param urlData
 * @returns {Blob}
 */
export function convertBase64UrlToBlob(urlData) {
    var arr = urlData.split(','), mime = arr[0].match(/:(.*?);/)[1],
        bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], {type: mime});
}

export default {
    photoCompress: photoCompress,
    convertBase64UrlToBlob: convertBase64UrlToBlob,
    uploadFile: uploadFile,
    getBase64Image:getBase64Image
}

