import Util from "../../util/Util.js"


import Color from "../../gdi/Color.js"


import MouseAdapter from './MouseAdapter.js';
import Tools from '../../util/Tools.js';


/**
 * 标记区，画出6个时间点
 * @type {{draw: draw}}
 */
var SignArea = MouseAdapter.extend(
    {

        constructor: function () {

        },
        //在指定单元格中画出时间轴
        draw: function (cell, /*int*/dbrow, /*Graphics2D*/g, /*Rectangle*/rc, data, /*String*/  s, /*int*/bkMode,
                        /*Color*/bkcolor, /*Color*/textcolor, /*String*/   FontName, /* int*/FontSize,
                        /*boolean*/FontBold, /*boolean*/FontItalic, /*boolean*/FontUnderline,
                        /*int*/hAlign, /*int*/vAlign, /*boolean*/MultiLine, /*boolean*/ noES) {

            var physiology = cell.Book.property.get(data.physiologyName);

            if (physiology == null) return; //当单元格用公式定义时，源可能还没有初始化好，这是允许的

            if (cell.getMouseAdapter('physiology') == undefined)
            {
                cell.addMouseAdapter('physiology', this);
            }

            var view = cell.Sheet.View;
            var lineColor = cell.getSplitLineColor();

            var textRect = rc.clone();


            //垂直线
            //看看能画多少个小格
            var n = Math.floor(rc.width / physiology.dateAxisCellWidth);
            var tn = Math.floor(n / 3); //每3格画一个时间刻度
            for (let i = 0; i <= n; i++)
            {
                let x = (physiology.offset + i) * physiology.dateAxisCellWidth;
                let y = rc.y;

                let lineStyle = 3;
                if (i % 3 == 0) lineStyle = 1;
                Tools.drawLine(g, lineStyle, 1, lineColor, rc.x + x, y, rc.x + x, y + rc.height);


            }
            //画标记


            //麻醉开始时间

            if (physiology.mzks)
            {
                var m = Tools.minutesBetween(physiology.mzks, physiology.startTime);
                var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                textRect.x = rc.x + x - FontSize / 2;
                textRect.width = FontSize;

                g.drawStringSingleRow(textRect, '\ue010', bkMode, bkcolor, textcolor, "physiology", FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);
            }

            if (physiology.ssks)
            {
                var m = Tools.minutesBetween(physiology.ssks, physiology.startTime);
                var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                textRect.x = rc.x + x - FontSize / 2;
                textRect.width = FontSize;

                g.drawStringSingleRow(textRect, '\ue001', bkMode, bkcolor, textcolor, "physiology", FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);
            }

            if (physiology.ssjs)
            {
                var m = Tools.minutesBetween(physiology.ssjs, physiology.startTime);
                var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                textRect.x = rc.x + x - FontSize / 2;
                textRect.width = FontSize;

                g.drawStringSingleRow(textRect, '\ue001', bkMode, bkcolor, Color.red, "physiology", FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);
            }

            if (physiology.mzjs)
            {
                var m = Tools.minutesBetween(physiology.mzjs, physiology.startTime);
                var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                textRect.x = rc.x + x - FontSize / 2;
                textRect.width = FontSize;

                g.drawStringSingleRow(textRect, '\ue010', bkMode, bkcolor, Color.red, "physiology", FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);
            }


        }
    });

export default SignArea;
