import Class from '../../base/Class.js';
import ObjectTool from '../../db/ObjectTool.js';
import UniformDataType from '../../core/UniformDataType.js';


var  Physiology = Class.extend({

    staic:
        {
            minDateAxisCellWidth: 5,//日期轴最小格的尺寸（单位：像素）
            maxDateAxisCellWidth: 10 //日期轴最小格的尺寸（单位：像素）

        },


    /**
     *
     * @param name
     * @param rsss  进手术室时间
     * @param mzks 麻醉开始时间
     * @param ssks 手术开始时间
     * @param ssjs 手术结束时间
     * @param mzjs 麻醉结束时间
     * @param csss  出手术室时间
     */
    constructor: function (name, rsss, mzks, ssks, ssjs, mzjs, csss) {

        rsss = ObjectTool.changeType(rsss, UniformDataType.$Datetime);
        mzks = ObjectTool.changeType(mzks, UniformDataType.$Datetime);
        ssks = ObjectTool.changeType(ssks, UniformDataType.$Datetime);
        ssjs = ObjectTool.changeType(ssjs, UniformDataType.$Datetime);
        mzjs = ObjectTool.changeType(mzjs, UniformDataType.$Datetime);
        csss = ObjectTool.changeType(csss, UniformDataType.$Datetime);

        //rsss,csss 必须不能为null
        if (rsss == null) rsss = new Date();
        if (csss == null) csss = ObjectTool.ObjectClone(rsss).add("H", 4);

        var startTime = ObjectTool.ObjectClone(rsss);
        var min = startTime.getMinutes();
        this.startTime = startTime.add("m", -min % 10); //把它往整10分钟靠
        var endTime = csss;
        min = endTime.getMinutes();
        this.endTime = endTime.add("m", 10 - min % 10); //把它往整10分钟靠


        this.rsss = rsss;
        this.csss = csss;
        this.mzks = mzks;
        this.ssks = ssks;
        this.ssjs = ssjs;
        this.mzjs = mzjs;
        this.timeStep = 5; // 每格表示5分钟
        this.dateAxisCellWidth = 15; //日期轴每小格的尺寸 10 （单位：像素）

        this.pixelPerSeconds = this.dateAxisCellWidth / this.timeStep;//每分钟占几个点

        this.offset = 0;

    }
});

export default Physiology;
