import Util from "../../util/Util.js";
import Color from "../../gdi/Color.js";
import MouseAdapter from './MouseAdapter.js';
import Tools from '../../util/Tools.js';
import Point from '../../gdi/Point.js';
import ActionTool from '../../mouse/ActionTool.js';


var DataArea = MouseAdapter.extend(
    {

        constructor: function () {
            this.hotAreaList = null;

        },
        //在指定单元格中画出时间轴
        draw: function (cell, /*int*/dbrow, /*Graphics2D*/g, /*Rectangle*/rc, data, /*String*/  s, /*int*/bkMode,
                        /*Color*/bkcolor, /*Color*/textcolor, /*String*/   FontName, /* int*/FontSize,
                        /*boolean*/FontBold, /*boolean*/FontItalic, /*boolean*/FontUnderline,
                        /*int*/hAlign, /*int*/vAlign, /*boolean*/MultiLine, /*boolean*/ noES) {

            var physiology = cell.Book.property.get(data.physiologyName);
            if (physiology == null) return; //当单元格用公式定义时，源可能还没有初始化好，这是允许的

            var injectionData = data.param;
            if (Util.isString(injectionData))
            {
                injectionData = window[injectionData](cell, dbrow);

            }


            if (cell.getMouseAdapter('physiology') == undefined)
            {
                cell.addMouseAdapter('physiology', this);
            }

            var view = cell.Sheet.View;
            var lineColor = cell.getSplitLineColor();

            var textRect = rc.clone();


            //看看能画多少个小格
            var h = Math.floor(rc.height / 31); //分成30份,每份的高度


            //再画数字轴
            for (var i = 1; i <= 31; i++)
            {
                textRect.y = rc.y + i * h;
                textRect.h = h;

                let lineStyle = 3;
                if (i % 2 == 0) lineStyle = 1;
                Tools.drawLine(g, lineStyle, 1, lineColor,
                    textRect.x, textRect.y,
                    textRect.x + textRect.width, textRect.y, 'dataxAxis');

            }

            //垂直线
            //看看能画多少个小格
            var n = Math.floor(rc.width / physiology.dateAxisCellWidth);
            var tn = Math.floor(n / 3); //每3格画一个时间刻度
            for (let i = 0; i <= n; i++)
            {
                let x = (physiology.offset + i) * physiology.dateAxisCellWidth;
                let y = rc.y;

                let lineStyle = 3;
                if (i % 3 == 0) lineStyle = 1;
                Tools.drawLine(g, lineStyle, 1, lineColor,
                    rc.x + x, y,
                    rc.x + x, y + rc.height, 'dataAxis');


            }

            this.hotAreaList = [];


            var data = injectionData.data;

            for (var i = 0; i < data.length; i++)
            {
                var lastX = -1;
                var lastY = -1;
                var lastValue = 0;


                var one = data[i];
                var y0 = rc.y + 30 * h;
                var pixelPerValue = 30.0 * h / ( one.maxValue - one.minValue);

                for (var j = 0; j < one.data.length; j++)
                {
                    var onePoint = one.data[j];
                    var m = Tools.minutesBetween(onePoint.when, physiology.startTime);
                    var x = m * physiology.pixelPerSeconds - physiology.offset;//起始x坐标
                    textRect.x = rc.x + x;
                    textRect.y = y0 - (onePoint.value - one.minValue) * pixelPerValue;

                    var currentX = textRect.x;
                    var currentY = textRect.y;

                    textRect.x -= FontSize / 2;
                    textRect.y -= FontSize / 2;
                    textRect.width = FontSize;
                    textRect.height = FontSize;

                    var hotRC = textRect.clone();
                    hotRC.tipInfo = `指标：${one.name}<br>时间：${onePoint.when.substring(0, 16)}<br>数据：${onePoint.value}`;

                    this.hotAreaList.push(hotRC);

                    var sign = one.legend;


                    if (onePoint.value != 0 && onePoint.value != -1)
                    {
                        g.drawStringSingleRow(textRect, sign, bkMode, bkcolor, one.color,
                            "physiology", FontSize, FontBold, FontItalic, FontUnderline, 2, vAlign);

                    }


                    if (lastValue != 0 && onePoint.value != 0)
                    {
                        Tools.drawLine(g, 1, 1, one.color, lastX, lastY, currentX, currentY, '');
                    }
                    lastX = currentX;
                    lastY = currentY;
                    lastValue = onePoint.value;


                }


            }


        },

        OnMouseMove: function (cell, pView, e) {

            //提示：不用去管重复设置光标的问题，在pView.setCursor中会判断如果要设置的光标与当前光标是一样的，那么是不会再次设置的
            if (this.hotAreaList)
            {
                var onHotArea = false;
                var point = new Point(e.offsetX, e.offsetY);
                var pView = cell.Sheet.View;

                for (var i = 0; i < this.hotAreaList.length; i++)
                {
                    var rc = this.hotAreaList[i];
                    if (rc.contains(point))
                    {
                        pView.setCursor(ActionTool.IDC_HAND);
                        onHotArea = true;
                        pView.Sheet.Book.View.showInfoPane(rc.tipInfo, e.clientX + 32, e.clientY + 32);
                        break;
                    }
                }

                if (!onHotArea)
                {
                    pView.setCursor(ActionTool.IDC_DEFAULT);
                    pView.Sheet.Book.View.hideInfoPane();
                }
            }
        }

    });


export default DataArea;
