var sqlserverIP='192.168.3.126';
async function newDataStore(dsn, select)
{


    var ret = null;

    const sql = require('mssql');
    let config = {
        user: 'sa',
        password: 'dir',
        server: sqlserverIP,//'192.168.1.206',
        database: 'fycs',
        port: 1433,
        options: {
            encrypt: false // Use this if you're on Windows Azure
        },
        pool: {
            min: 0,
            max: 5,
            idleTimeoutMillis: 3000
        }
    };


    try
    {
        var pool = await new sql.ConnectionPool(config);
        await pool.connect();
        let result = await pool.request().query(select);

        var value = [];
        var columns = result.recordset.columns;
        for (var col in columns)
        {
            var colInfo = columns[col];
            var one = {};
            one.name = col;
            one.caseSensitive = colInfo.caseSensitive;
            one.label = col;
            one.type = colInfo.type().type.name;
            one.length = colInfo.length;
            one.nullable = colInfo.nullable;
            one.precision = colInfo.precision;
            one.scale = colInfo.scale;
            one.readOnly = colInfo.readOnly;

            value.push(one);
        }

        await  pool.close();// 好象不释放，数据库连接数也不会增加，奇怪
        ret = {success: true, value: value, dialect: 'sqlserver'};


    } catch (err)
    {
        // ... error checks
        ret = {success: false, error: err};
    }
    return ret;
}

/**
 *
 * @param dsn 数据库连接标识，此标识如何转换成实际的连接，可以按需要定制
 * @param select  语句
 * @param where  附加的检索条件
 * @param onceRetrieveCount   一次性检索多少条
 * @param absolute  检索前先定位到哪里
 * @returns {Promise.<void>}
 */
async function retrieve(dsn, select, onceRetrieveCount, absolute)
{
    var ret = null;

    const sql = require('mssql');
    let config = {
        user: 'sa',
        password: 'dir',
        server: sqlserverIP,
        database: 'fycs',
        port: 1433,
        options: {
            encrypt: false // Use this if you're on Windows Azure
        },
        pool: {
            min: 0,
            max: 5,
            idleTimeoutMillis: 3000
        }
    };


    try
    {
        var pool = await new sql.ConnectionPool(config);
        await pool.connect();
        let result = await pool.request().query(select);
        // 字段名转索引号
        var columns = result.recordset.columns;
        var col2index = {};
        for (var col in columns)
        {
            col2index[col] = columns[col].index;

        }

        var value = [];
        var recordset = result.recordset;
        //数据精简，把为 null的字段去掉，把字段名替换成字段序号，以减少数据传输量
        var RC = recordset.length;
        var CC = result
        for (var row = 0; row < RC; row++)
        {
            var rowData = {};
            for (var col in col2index)
            {
                var v = recordset[row][col];
                if (v == null) continue;
                rowData['c' + col2index[col]] = v;// 把字段名转在索引号，减少数据量

            }
            value.push(rowData);

        }

        await  pool.close();// 好象不释放，数据库连接数也不会增加，奇怪
        ret = {success: true, value: value, dialect: 'sqlserver'};


    } catch (err)
    {
        // ... error checks
        ret = {success: false, error: err};
    }
    return ret;

}


module.exports = {
    newDataStore: newDataStore,
    retrieve: retrieve
}
