/**
 * Created by 三宝爹 on 2017/10/13.


 此类继承自 DrawTool ,当本类调用 this.$uper.func时，理应加上 .call(this,  arg1, arg2....) 来切换this
 但是 DrawTool中的函数操作的数据，都是静态数据，不受 this指针的影响，所以就不需要加
 如果 DrawTool中有改变，就一定注意，它的子类，比如本类中调用父类方法时，选择性地切换 this
 */


import ActionTool from './ActionTool.js';
import MouseState from './MouseState.js';
import DrawShape from './DrawShape.js';
import Point from '../gdi/Point.js';
import DrawTool from './DrawTool.js';
import Rectangle from '../gdi/Rectangle.js';
import Range from '../core/Range.js';
import Tools from '../util/Tools.js';
import Util from '../util/Util.js';
import ALIGNMENT from "../core/ALIGNMENT.js";

var SelectTool = DrawTool.extend({

    constructor: function () {
        this.$uper.constructor();

        this.m_drawShape = DrawShape._selection_;

        this.oldSelection = null;//Range


        this.view = null;
        /*pView.Clas$*/
        this.ContinueScroll = false;
        this.outSizeX = 0;
        this.outSizeY = 0;

        // 用于拖拽
        this.deltaRow = 0;
        this.deltaCol = 0;

        DrawTool.c_tools.push(this);

    },


    OnLButtonDown(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        this.$uper.OnLButtonDown(pView, e);

        var /*WorkSheet*/ sheet = pView.Sheet;
        var rc = pView.getRectangleOfSelection();
        var rcTop = new Rectangle(rc.x, rc.y - 1, rc.width, 4);
        var rcBottom = new Rectangle(rc.x, rc.y + rc.height - 1, rc.width - 2, 4);

        var rcLeft = new Rectangle(rc.x - 1, rc.y, 4, rc.height);
        var rcRight = new Rectangle(rc.x + rc.width - 1, rc.y, 4, rc.height - 2);

        var rcResize = new Rectangle(rc.x + rc.width - 2, rc.y + rc.height - 2, 4, 4);

        this.m_mousestate = MouseState._DoSelection_;

        // 一定要调用

        var hCur = ActionTool.IDC_CROSS;
        if (!pView.Sheet.designMode) hCur = ActionTool.IDC_DEFAULT;

        var /*Point*/ p = new Point(e.offsetX, e.offsetY);
        if (rcTop.contains(p) || rcBottom.contains(p) || rcLeft.contains(p) || rcRight.contains(p))
        {
            if (pView.Sheet.designMode)
            {
                hCur = ActionTool.IDC_MOVESELECTION;
                if (e.controlKey) hCur = ActionTool.IDC_MOVESELECTION2;
                this.m_mousestate = MouseState._MoveSelection_;

                var row = pView.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row)) row = row.row;
                var col = pView.GetColAtPoint(false, e.offsetX, row);
                // 记下鼠标按下点与选中区起始点的距离
                this.deltaRow = row - sheet.selection.startRow;
                this.deltaCol = col - sheet.selection.startCol;
            }

        }
        if (rcResize.contains(p))
        {
            hCur = ActionTool.IDC_RESIZESELECTION;
            this.m_mousestate = MouseState._ResizeSelection_;

        }

        pView.setCursor(hCur);

        if (this.m_mousestate == MouseState._DoSelection_)
        {
            var row = pView.GetRowAtPoint(false, e.offsetY);
            if (Util.isObject(row)) row = row.row;
            var col = pView.GetColAtPoint(false, e.offsetX, row);
            if (e.shiftKey)
            {
                var row1 = this.oldSelection.startRow;
                var col1 = this.oldSelection.startCol;
                sheet.setSelection(new Range(row1, col1, row, col));
            } else
            {
                sheet.setSelection(new Range(row, col, row, col));
            }

        }

        this.oldSelection = sheet.selection; // 记下此时的Selection

        // 再交给单元格处理
        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = pView.GetColAtPoint(false, e.offsetX, row);

        if (row >= 0 && col >= 0)
        {
            var cell = sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                cell.OnLButtonDown(pView, e);
            }
        }


    },

    OnLButtonClick(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        this.$uper.OnLButtonClick(pView, e);

        var sheet = pView.Sheet;
        var r = sheet.selection;

        // 如果是设计模式，那么不要让单元格处于编辑状态，而是选中状态就行了
        // 要编辑就双击。如果是运行模式，那么直接让它处于编辑状态。
        if (!sheet.designMode)
        {
            // 移动到cell中处理
            //	pView.$beginEdit(r.startRow, r.startCol, null, e ,-1);

        }

        // 再交给单元格处理其中的小件
        let row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        //
        //鼠标点击处判断列号，要把行号代入，因为行可能是禁止列卷滚的,所在在不同的行上点击，得到的列可能是不同的
        let  col = pView.GetColAtPoint(false, e.offsetX, row);

        let innerRow=-1;
        if (row >= 0 && col >= 0)
        {
            var cell = sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                innerRow = cell.OnLButtonClick(pView, e);

            }
        }
        //2021.07.01 当单元格为空，或在非单元格部分点击时，触发此事件


        sheet.Book.EM.fire("workSheetOnClicked", [sheet, row,col,innerRow, e]);

        //2021.12.13 增加关闭非自动关闭的tooltip显示框
        sheet.popoverHide();
    },

    OnLButtonDblClk(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        this.$uper.OnLButtonDblClk(pView, e);
        var sheet = pView.Sheet;
        var r = sheet.selection;
        //放到cell.OnLButtonDblClk中处理
        //pView.$beginEdit(r.startRow, r.startCol, null, e ,-1);

        // 再交给单元格处理其中的小件
        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = pView.GetColAtPoint(false, e.offsetX, row);

        if (row >= 0 && col >= 0)
        {
            //如果是设计模式，那么要确保单元格创建，并进入编辑 状态，如果是运行模式，那么单元格如果是空的，那么什么也不用做了
            var cell = sheet.designMode ? sheet.cells(row, col) : sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                cell.OnLButtonDblClk(pView, e);
            }
        }

    },

    OnLButtonUp(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        // 一定要显示调用
        this.$uper.OnLButtonUp(pView, e);

        var sheet = pView.Sheet;
        if (this.m_mousestate == MouseState._MoveSelection_)
        {

            // 取消选中区移动显示

            var /*Range*/ r = sheet.getMovingSelection();
            if (r != null)
            {
                if (sheet.designMode)
                {

                    if (e.ctrlKey)
                    {
                        sheet.copy();
                    } else
                    {
                        sheet.cut();
                    }
                    sheet.setSelection(r);
                    sheet.paste();
                    sheet.setMovingSelection(null);
                }
            }
        }

        // 再交给单元格处理其中的小件
        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = pView.GetColAtPoint(false, e.offsetX, row);

        if (row >= 0 && col >= 0)
        {
            var cell = sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                cell.OnLButtonUp(pView, e);
            }
        }
    },

    // 所有工具的切换都要在些进行处理
    // 所有的其它工具只需要在交出控制时，把控制交还给 SelectTool ,由 SelectTool 进行再次的判断
    OnMouseMove(/*pView.Clas$*/ pView, /*Event*/ e)
    {


        let that=this;
        // 必须先运行
        this.$uper.OnMouseMove(pView, e);

        var sheet = pView.Sheet;

        if (DrawTool.c_IsDraging)
        {
            this.OnMouseDrag(pView, e);
            return; // 不是在拖拽时，才做如下动作
        }


        var rc = pView.getRectangleOfSelection();
        var rcTop = new Rectangle(rc.x, rc.y - 1, rc.width, 4);
        var rcBottom = new Rectangle(rc.x, rc.y + rc.height - 1, rc.width - 2, 4);

        var rcLeft = new Rectangle(rc.x - 1, rc.y, 4, rc.height);
        var rcRight = new Rectangle(rc.x + rc.width - 1, rc.y, 4, rc.height - 2);

        var rcResize = new Rectangle(rc.x + rc.width - 2, rc.y + rc.height - 2, 4, 4);

        var CPM = sheet.CPM;
        var RPM = sheet.RPM;
        var rcLeftTopCorner = new Rectangle(0, 0, RPM.getRowHeadWidth(), CPM.getColumnHeadHeight());

        // 一定要调用

        var hCur = ActionTool.IDC_CROSS;
        if (!pView.Sheet.designMode) hCur = ActionTool.IDC_DEFAULT;

        var /*Point*/ p = new Point(e.offsetX, e.offsetY);
        if (rcTop.contains(p) || rcBottom.contains(p) || rcLeft.contains(p) || rcRight.contains(p))
        {
            if (sheet.designMode)
            {
                hCur = ActionTool.IDC_MOVESELECTION;
                if (e.controlKey) hCur = ActionTool.IDC_MOVESELECTION2;
            }
        }

        if (rcResize.contains(p))
        {
            hCur = ActionTool.IDC_RESIZESELECTION;

        }

        if (rcLeftTopCorner.contains(p))
        {
            hCur = ActionTool.IDC_SPREADSHEET;
        }

        pView.setCursor(hCur);

        //如果是运行模板，那么在锁定行列之上的区域，都可以resize 行列的尺寸
        if (!pView.Sheet.designMode)
        {
            if (DrawTool.FindTool(DrawShape._columnhead_).canDoResizeColumnWidth(pView, e)
                && !DrawTool.c_IsDraging )
            {
                //如果鼠标正好在单元格中的按钮上，那么也不要resize
                var row = pView.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row)) row = row.row;
                var col = pView.GetColAtPoint(false, e.offsetX, row);
                var canResize = true;
                if (row >= 0 && col >= 0)
                {
                    var cell = sheet.$cells(row, col);
                    if (cell != null)
                    {
                        if (cell.merged) cell = cell.mergedBy();
                        if (cell.getBrickAt(new Point(e.offsetX, e.offsetY)) != null)
                        {
                            canResize = false;
                        }

                    }
                }

                if (canResize)
                {
                    DrawTool.c_drawShape = DrawShape._columnhead_;
                    pView.Clas$.columnHeadTool.m_mousestate = MouseState._CaptureNULL_;

                    return;
                }

            }

            if (DrawTool.FindTool(DrawShape._rowhead_).canDoResizeRowHeight(pView, e) && !DrawTool.c_IsDraging)
            {
                //如果鼠标正好在单元格中的按钮上，那么也不要resize
                var row = pView.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row)) row = row.row;
                var col = pView.GetColAtPoint(false, e.offsetX, row);
                var /*boolean*/ canResize = true;
                if (row >= 0 && col >= 0)
                {
                    var cell = sheet.$cells(row, col);
                    if (cell != null)
                    {
                        if (cell.merged) cell = cell.mergedBy();
                        if (cell.getBrickAt(new Point(e.offsetX, e.offsetY)) != null)
                        {
                            canResize = false;
                        }

                    }
                }

                if (canResize)
                {
                    DrawTool.c_drawShape = DrawShape._rowhead_;
                    pView.Clas$.rowHeadTool.m_mousestate = MouseState._CaptureNULL_;
                    return;
                }
            }
        }
        //工具的切换
        if (pView.isOnColumnHeader(p) && !DrawTool.c_IsDraging)
        {
            DrawTool.c_drawShape = DrawShape._columnhead_;
            pView.Clas$.columnHeadTool.m_mousestate = MouseState._CaptureNULL_;
            return;
        }

        if (pView.isOnRowHeader(p) && !DrawTool.c_IsDraging)
        {
            DrawTool.c_drawShape = DrawShape._rowhead_;
            pView.Clas$.rowHeadTool.m_mousestate = MouseState._CaptureNULL_;
            return;
        }

        // 再交给单元格处理

        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = pView.GetColAtPoint(false, e.offsetX, row);
        //Tools.log(" mousemove " +e.offsetX+ "   "+e.offsetY);

        //需要补偿触发 mouseout事件吗
        // 当鼠标在非单元格上move，或者行列合法，但是对应的单元格是null时，需要补偿触发 mouseOut
        let needCompensateForMouseOutTrigger=true;

        if (row >= 0 && col >= 0)
        {
            var cell = sheet.$cells(row, col);
            if (cell != null)
            {

                needCompensateForMouseOutTrigger =false;

                if (cell.merged) cell = cell.mergedBy();
                cell.OnMouseMove(pView, e);

                //   增加ToolTip的支持
                //   设计时，显示单元格的绑定信息， 运行时显示的提示，已经改到 /*pView.Clas$*/.getToolTip中

                if (pView.Sheet.designMode)
                {


                    var tooltip = cell.getAutoTip(e) + cell.toolTip;
                    if (tooltip == "")
                    {
                        pView.setToolTipText(null);
                    } else
                    {
                        //下面的功能没有实现
                        pView.setToolTipText(tooltip);
                    }

                }else
                {
                    if( this.lastCell != cell)
                    {

                        if( this.lastCell!=null)
                        {
                            //标记20211214
                            this.lastCell.onTooltipEnd(cell.popoverContent!='');//如果当前单元格也有提示信息要显示，那么强行关闭一个，否则让上一个单元格自已决定是否关闭
                            pView.Book.EM.fire("cellOnMouseOut", [pView.Sheet, this.lastCell ]);
                            if( this.mouseEnterIdleHandle) clearTimeout(this.mouseEnterIdleHandle); //如果还没有显示 tooktip，那么就不要做了

                        }
                        this.lastCell= cell;
                        let innerRow = cell.getInnerRowAtPoint(new Point(e.offsetX, e.offsetY) ,false /*只计算子行号，但不设置当前焦点行*/);
                        this.lastCellInnerRow= innerRow;
                        pView.Book.EM.fire("cellOnMouseEnter", [pView.Sheet, cell, innerRow,e]);

                        if( this.mouseEnterIdleHandle) clearTimeout(this.mouseEnterIdleHandle); //如果还没有显示 tooktip，那么就不要做了
                        this.mouseEnterIdleHandle= setTimeout( function()
                        {
                            cell.onTooltipBegin(innerRow); //默认的提示实现
                            pView.Book.EM.fire("tooltipOnCell", [pView.Sheet, cell, innerRow,e]);
                            clearTimeout(that.mouseEnterIdleHandle);
                            that.mouseEnterIdleHandle=0;
                        },500);

                    }else  //如果是在同一个单元格内移动，再看看明细行是不是相等
                    {
                        let innerRow = cell.getInnerRowAtPoint(new Point(e.offsetX, e.offsetY) ,false /*只计算子行号，但不设置当前焦点行*/);
                        if( this.lastCellInnerRow!= innerRow)
                        {
                            //标记20211214
                            this.lastCell.onTooltipEnd(cell.popoverContent!='' );//如果当前单元格也有提示信息要显示，那么强行关闭一个，否则让上一个单元格自已决定是否关闭
                            pView.Book.EM.fire("cellOnMouseOut", [pView.Sheet, this.lastCell]);
                            if (this.mouseEnterIdleHandle) clearTimeout(this.mouseEnterIdleHandle); //如果还没有显示 tooktip，那么就不要做了

                            this.lastCellInnerRow = innerRow;
                            //如果上一次的还没有执行，那么取消执行，重新计时
                            pView.Book.EM.fire("cellOnMouseEnter", [pView.Sheet, cell, innerRow, e]);
                            if (this.mouseEnterIdleHandle) clearTimeout(this.mouseEnterIdleHandle); //如果还没有显示 tooktip，那么就不要做了
                            this.mouseEnterIdleHandle = setTimeout(function () {
                                cell.onTooltipBegin(innerRow); //默认的提示实现
                                pView.Book.EM.fire("tooltipOnCell", [pView.Sheet, cell, innerRow, e]);
                                clearTimeout(that.mouseEnterIdleHandle);
                                that.mouseEnterIdleHandle = 0;
                            }, 50);//不要等500了，就在本单元格内切换提示，不需要等
                        }
                    }
                }
            }
        }

        if( needCompensateForMouseOutTrigger  )
        {
            if( this.lastCell!=null)
            {
                this.lastCell.onTooltipEnd(false); //非强制关闭
                pView.Book.EM.fire("cellOnMouseOut", [pView.Sheet, this.lastCell]);
                if (this.mouseEnterIdleHandle) clearTimeout(this.mouseEnterIdleHandle); //如果还没有显示 tooktip，那么就不要做了
            }

            this.lastCell=null;
            this.lastCellInnerRow=-1;
        }

    },


    /**
     * 2020.10.04  设计时上下文菜单增加了一些属性设置项，便的表单设计，所以本函数还承担了一部分表单设计的功能，
     * 有些臃肿，不够优雅， 先这么着吧，有时间了，再把表单设计部分独立出去。现在是用全局函数方式来处理的
     * @param pView
     * @param e
     * @constructor
     */

    OnRButtonDown(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        this.$uper.OnRButtonDown(pView, e);
        var sheet = pView.Sheet;
        if (sheet.designMode)
        {
            //TODO 显示设计菜单
        }

        // 再交给单元格处理其中的小件
        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        //
        //鼠标点击处判断列号，要把行号代入，因为行可能是禁止列卷滚的,所在在不同的行上点击，得到的列可能是不同的
        var col = pView.GetColAtPoint(false, e.offsetX, row);

        var innerRow = -1;
        var cell = null;
        if (row >= 0 && col >= 0)
        {
            cell = sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                cell.OnRButtonClick(pView, e);
                innerRow = cell.getInnerRowAtPoint(new Point(e.offsetX, e.offsetY) ,true /*计算子行号，并且还要设置当前焦点行*/);
            }


        }

        //  触发上下文菜单事件

        console.info("扩展右键菜单");
        var userMenu = pView.Book.EM.fire("cellContextMenu", [pView.Sheet, cell, innerRow,e]);

        //默认菜单
        var actions;
        var menu;

        if (pView.Sheet.designMode)
        {

            //下面的弹出菜单中的按钮触发事件，比较难优雅地处理响应事件，简单粗爆先用全局函数处理，且必须要有一个全局的book对象
            if (!window['formDesignSetSelectionProperty'])
            {
                window.formDesignSetSelectionProperty = function (propName, propValue) {
                    var sheet = book.getActiveSheet();
                    try
                    {
                        sheet.paintPermit = false;
                        var r = sheet.selection;
                        for (var row = r.startRow; row <= r.endRow; row++)
                        {
                            for (var col = r.startCol; col <= r.endCol; col++)
                            {
                                sheet.cells(row, col).setPropertyValue(propName, propValue);
                            }
                        }
                    } catch (err)
                    {
                    }
                    finally
                    {
                        sheet.paintPermit = true;

                    }
                };


                window.formDesignDoInSelection = function (callback) {
                    var sheet = book.getActiveSheet();
                    try
                    {
                        sheet.paintPermit = false;
                        var r = sheet.selection;
                        for (var row = r.startRow; row <= r.endRow; row++)
                        {
                            for (var col = r.startCol; col <= r.endCol; col++)
                            {
                                callback(sheet.cells(row, col));
                            }
                        }
                    } catch (err)
                    {
                    }
                    finally
                    {
                        sheet.paintPermit = true;
                    }
                };


                window.formDesignMerge = function () {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;
                    sheet.unMerge(r);
                    sheet.merge(r);
                };

                window.formDesignUnMerge = function () {

                    var sheet = book.activeSheet;
                    var r = sheet.selection;
                    sheet.unMerge(r);

                }


                window.formDesignSetBorderAll=function() {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;
                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 8, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderOuter=function () {

                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 6, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderInner=function() {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 7, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderLeft=function() {

                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 0, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderTop=function() {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 2, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderRight=function() {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 1, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderBottom=function () {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 3, 1, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderBottomDotted=function() {


                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 3, 3, 1, book.formDesignLastBorderColor || '#808080');

                }

                window.formDesignSetBorderNull=function () {

                    var sheet = book.activeSheet;
                    var r = sheet.selection;

                    sheet.setRangeBorder(r.startRow, r.startCol, r.endRow, r.endCol, 8, 0, 0, 'gray');

                }


            }

            actions = [];



            var r = sheet.selection;
            var firstCell=sheet.cells( r.startRow, r.startCol);





            //样式
            var css=  firstCell.css;
            var allCSS= [];

            for( var p in sheet.Book.cssMap)
            {
                allCSS.push( p);
            }



            var options=[];
            options.push(`<option value = ""  ${ ''==css?'selected':''} > 无样式</option>`);
            for(var i=0;i<allCSS.length;i++)
            {
               options.push(`<option value = "${allCSS[i]}"  ${ allCSS[i]==css?'selected':''} > ${allCSS[i]} </option>`);
            }

            actions.push(
                {
                    name: `

                    <select title="选择样式" style="border:1px solid lightgray; border-radius:3px;width:215px; 
                                                            height:22px; outline:none;"
                        onchange="formDesignDoInSelection( function(cell){cell.css= this.value}.bind(this)); 
                                    window.formDesignContextMenu.close()"> 
                       ${options.join('')}
                     </select>
               
                    `,
                    onClick: function (evt) {

                        throw {};
                    }
                }
            );







            var fontSize= firstCell.getPropertyValue("font-size",12);
            var family= firstCell.getPropertyValue("font-family",'自动');


            actions.push(
                {
                    name: `

                        <table  style="border:0;"><tr>
                        <td>
                        <select id="font-family" name="font-family" class="roundbox" 
                        style="border:1px solid lightgray; border-radius:3px; outline:none;width:178px;"
                        onchange="formDesignSetSelectionProperty('font-family', this.value);window.formDesignContextMenu.close();"> 

                            <option value="自动">自动</option>
                            <option value="宋体" ${family=='宋体'?'selected':''}>宋体</option>
                            <option value="新宋体" ${family=='新宋体'?'selected':''}>新宋体</option>
                            <option value="隶书" ${family=='隶书'?'selected':''}>隶书</option>
                            <option value="楷体_GB2312" ${family=='楷体_GB2312'?'selected':''}>楷体_GB2312</option>
                            <option value="黑体" ${family=='黑体'?'selected':''}>黑体</option>
                            <option value="微软雅黑" ${family=='微软雅黑'?'selected':''}>微软雅黑</option>
                            <option value="Arial" ${family=='Arial'?'selected':''}>Arial</option>
                            <option value="Courier New" ${family=='Courier New'?'selected':''}>Courier New</option>
                            <option value="Lucida Console" ${family=='Lucida Console'?'selected':''}>Lucida Console</option>
                            <option value="Lucida Sans" ${family=='Lucida Sans'?'selected':''}>Lucida Sans</option>
                            <option value="Lucida Sans Unicode" ${family=='Lucida Sans Unicode'?'selected':''}>Lucida Sans Unicode</option>
                            <option value="Microsoft Sans Serif" ${family=='Microsoft Sans Serif'?'selected':''}>Microsoft Sans Serif</option>
                            <option value="sansserif" ${family=='sansserif'?'selected':''}>sansserif</option>
                            <option value="Simsun" ${family=='Simsun'?'selected':''}>Simsun</option>
                            <option value="Times New Roman" ${family=='Times New Roman'?'selected':''}>Times New Roman</option>
                            <option value="Tahoma" ${family=='Tahoma'?'selected':''}>Tahoma</option>
                            <option value="Verdana" ${family=='Verdana'?'selected':''}>Verdana</option>

                            <option value="FontAwesome"  ${family=='FontAwesome'?'selected':''}>FontAwesome图标字体</option>
                            <option value="physiology"  ${family=='physiology'?'selected':''}>physiology图标字体</option>


                        </select>
                    </td>
                    `+
                    `
                    <td><select name="font-size" id='font-size' class="roundbox"  
                    style="border:1px solid lightgray; border-radius:3px;outline:none;"
                    onchange="formDesignSetSelectionProperty('font-size', this.value);window.formDesignContextMenu.close();">
                        <option value=5 ${fontSize==5?'selected':''}>5</option>
                        <option value=6 ${fontSize==6?'selected':''}>6</option>
                        <option value=7 ${fontSize==7?'selected':''}>7</option>
                        <option value=8 ${fontSize==8?'selected':''}>8</option>
                        <option value=9 ${fontSize==9?'selected':''}>9</option>
                        <option value=10 ${fontSize==10?'selected':''}>10</option>
                        <option value=11 ${fontSize==11?'selected':''}>11</option>
                        <option value=12 ${fontSize==12?'selected':''}>12</option>
                        <option value=14 ${fontSize==14?'selected':''}>14</option>
                        <option value=16 ${fontSize==16?'selected':''}>16</option>
                        <option value=18 ${fontSize==18?'selected':''}>18</option>
                        <option value=20 ${fontSize==20?'selected':''}>20</option>
                        <option value=22 ${fontSize==22?'selected':''}>22</option>
                        <option value=24 ${fontSize==24?'selected':''}>24</option>
                        <option value=26 ${fontSize==26?'selected':''}>26</option>
                        <option value=28 ${fontSize==28?'selected':''}>28</option>
                        <option value=36 ${fontSize==36?'selected':''}>36</option>
                        <option value=48 ${fontSize==48?'selected':''}>48</option>
                        <option value=72 ${fontSize==72?'selected':''}>72</option>
                        <option value=96 ${fontSize==96?'selected':''}>96</option>


                    </select>

                    </td>
                    </tr></table>
               
                    `,
                    onClick:function()
                    {
                        //当点击 select 时，它下面的menuitem也触发 了click ,执行到此处， 然后调用 close()关闭了菜单，同时也关闭了select，
                        // 所以下面抛出一个异常，让后面的 close 不执行。 不良后果就是选择了字体后，菜单也无法关闭
                        throw {};
                    }
                }
            );



            var bold= firstCell.getPropertyValue("font-bold");
            var italic= firstCell.getPropertyValue("font-italic");
            var underline= firstCell.getPropertyValue("font-underline");
            var wordwrap  = firstCell.getPropertyValue("word-wrap");

            //字体属性
            actions.push(
                {
                    name: `

                      <div class="btn-group">
                            <button class="btn btn-xs btn-default ${bold?'btn-primary':''}" id=cb_fontbold 
                            onclick=" formDesignSetSelectionProperty('font-bold',!$(this).hasClass('btn-primary'));">
                            <i class="fa fa-bold"></i>
                            </button>
                            <button class="btn btn-xs btn-default ${italic?'btn-primary':''}" id="cb_fontitalic"                                                            onclick=" formDesignSetSelectionProperty('font-italic',!$(this).hasClass('btn-primary'));">
                            <i class="fa fa-italic"></i>
                            </button>
                            <button class="btn btn-xs btn-default ${underline?'btn-primary':''}" id="cb_fontunderline" 
                            onclick=" formDesignSetSelectionProperty('font-underline',!$(this).hasClass('btn-primary'));">
                            <i  class="fa fa-underline"></i></button>
                            <button class="btn btn-xs btn-default ${wordwrap?'btn-primary':''}" id="cb_fontwordwrap"
                            onclick=" formDesignSetSelectionProperty('word-wrap',!$(this).hasClass('btn-primary'));">
                            <i class="fa fa-wikipedia-w"></i></button>
                        </div>
    
                     <div class="btn-group">
                            <button class="btn btn-xs btn-default" id="cb_merge" title="单元格合并" 
                            onclick="formDesignMerge( );"   >
                            <i class="fa fa-window-maximize"> 合并</i>
                            </button>
                            <button class="btn btn-xs btn-default" id="cb_unmerge" title="单元格拆分"
                            onclick="formDesignUnMerge( );"  >
                            <i class="fa fa-table"> 取消合并</i></button>
        
                    </div>
               
                    `,
                    onClick: function (evt) {


                    }
                }
            );

            //边框

            actions.push(
                {
                    name: `

                    <div class="btn-group">
                        <button class="btn btn-xs btn-default" id="cb_border_all" onclick="formDesignSetBorderAll();"
                        style="width:22px;height:22px;background-image:url(js/spreadsheet/img/bs_all.gif) ;
                        background-repeat:no-repeat no-repeat;
                        background-position: center center;"></button>
                    <button class="btn btn-xs btn-default" id="cb_border_outer" onclick="formDesignSetBorderOuter();"
                        style="width:22px;height:22px;background-image:url(js/spreadsheet/img/bs_outer.gif) ;
                        background-repeat:no-repeat no-repeat;
                        background-position: center center;"></button>
                    <button class="btn btn-xs btn-default" id="cb_border_innerr" onclick="formDesignSetBorderInner();"
                        style="width:22px;height:22px;background-image:url(js/spreadsheet/img/bs_inner.gif) ; display:none;
                        background-repeat:no-repeat no-repeat;
                        background-position: center center;"></button>
            
                    <button class="btn btn-xs btn-default" id="cb_border_left" onclick="formDesignSetBorderLeft();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_left.gif) ;
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
            
                    <button class="btn btn-xs btn-default" id="cb_border_top" onclick="formDesignSetBorderTop();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_top.gif) ;
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
                    <button class="btn btn-xs btn-default" id="cb_border_right" onclick="formDesignSetBorderRight();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_right.gif) ;
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
            
                    <button class="btn btn-xs btn-default" id="cb_border_bottom" onclick="formDesignSetBorderBottom();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_bottom.gif) ;
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
                    <button class="btn btn-xs btn-default" id="cb_border_bottom_dotted"  onclick="formDesignSetBorderBottomDotted();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_bottom_dotted.gif) ;
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
                    <button class="btn btn-xs btn-default" id="cb_border_null" onclick="formDesignSetBorderNull();"
                        style="width:22px;height:22px;
                        background-image:url(js/spreadsheet/img/bs_null.gif) ; 
                        background-repeat:no-repeat no-repeat;background-position: center center;"></button>
                        
                 
                        
                    `,
                    onClick: function (evt) {


                    }
                }
            );

/*

   <button class="btn btn-xs  btn-default  " id="cb_bordercolor" title="边框线颜色">

                                        <i class="fa fa-pencil-square-o  btn-default"
                                           id="view_bordercolor"></i>

                                </button>

            var color = [

                'f9ebea', 'f2d7d5', 'e6b0aa', 'd98880', 'cd6155', 'c0392b', 'a93226', '922b21', '7b241c', '641e16',
                'fdedec', 'fadbd8', 'f5b7b1', 'f1948a', 'ec7063', 'e74c3c', 'cb4335', 'b03a2e', '943126', '78281f',
                'fbeee6', 'f6ddcc', 'edbb99', 'e59866', 'dc7633', 'd35400', 'ba4a00', 'a04000', '873600', '6e2c00',
                'fdf2e9', 'fae5d3', 'f5cba7', 'f0b27a', 'eb984e', 'e67e22', 'ca6f1e', 'af601a', '935116', '784212',
                'fef5e7', 'fdebd0', 'fad7a0', 'f8c471', 'f5b041', 'f39c12', 'd68910', 'b9770e', '9c640c', '7e5109',
                'fef9e7', 'fcf3cf', 'f9e79f', 'f7dc6f', 'f4d03f', 'f1c40f', 'd4ac0d', 'b7950b', '9a7d0a', '7d6608',
                'eafaf1', 'd5f5e3', 'abebc6', '82e0aa', '58d68d', '2ecc71', '28b463', '239b56', '1d8348', '186a3b',
                'e9f7ef', 'd4efdf', 'a9dfbf', '7dcea0', '52be80', '27ae60', '229954', '1e8449', '196f3d', '145a32',
                'e8f6f3', 'd0ece7', 'a2d9ce', '73c6b6', '45b39d', '16a085', '138d75', '117a65', '0e6655', '0b5345',
                'e8f8f5', 'd1f2eb', 'a3e4d7', '76d7c4', '48c9b0', '1abc9c', '17a589', '148f77', '117864', '0e6251',
                'ebf5fb', 'd6eaf8', 'aed6f1', '85c1e9', '5dade2', '3498db', '2e86c1', '2874a6', '21618c', '1b4f72',
                'eaf2f8', 'd4e6f1', 'a9cce3', '7fb3d5', '5499c7', '2980b9', '2471a3', '1f618d', '1a5276', '154360',
                'f5eef8', 'ebdef0', 'd7bde2', 'c39bd3', 'af7ac5', '9b59b6', '884ea0', '76448a', '633974', '512e5f',
                'f4ecf7', 'e8daef', 'd2b4de', 'bb8fce', 'a569bd', '8e44ad', '7d3c98', '6c3483', '5b2c6f', '4a235a',
                'ffffff', 'fbfcfc', 'f7f9f9', 'f4f6f7', 'f0f3f4', 'ecf0f1', 'd0d3d4', 'b3b6b7', '979a9a', '7b7d7d',
                'f8f9f9', 'f2f3f4', 'e5e7e9', 'd7dbdd', 'cacfd2', 'bdc3c7', 'a6acaf', '909497', '797d7f', '626567',
                'f4f6f6', 'eaeded', 'd5dbdb', 'bfc9ca', 'aab7b8', '95a5a6', '839192', '717d7e', '5f6a6a', '4d5656',
                'f2f4f4', 'e5e8e8', 'ccd1d1', 'b2babb', '99a3a4', '7f8c8d', '707b7c', '616a6b', '515a5a', '424949',
                'ebedef', 'd6dbdf', 'aeb6bf', '85929e', '5d6d7e', '34495e', '2e4053', '283747', '212f3c', '1b2631',
                'eaecee', 'd5d8dc', 'abb2b9', '808b96', '566573', '2c3e50', '273746', '212f3d', '1c2833', '17202a'
            ];

            //调色板转一个方向
            var color2 = [];

            for (var j = 0; j < 10; j++)
            {
                var oneRow=[];
                color2.push( oneRow);
                for (var i = 0; i < 20; i++)
                {

                    var index = i * 10 + j;
                    oneRow.push(color[index]);
                    i++
                }
            }

            setTimeout( function()
            {
                $("#cb_bordercolor").spectrum({
                    showPaletteOnly: true,
                    showPalette:true,
                    hideAfterPaletteSelect:true,
                    color: 'gray',
                    palette: color2

                });

            },500);
            */

            var align= firstCell.getPropertyValue("text-align");
            var valign= firstCell.getPropertyValue("vertical-align");


            //对齐设置
            actions.push(
                {
                    name: `
                    
                <div class="btn-group">
                    <button class="btn btn-xs btn-default  ${align==0?'btn-primary':''} cb_alignleft" title="水平左对齐"
                    onclick="formDesignSetSelectionProperty('text-align',0);" >
                    <i class="fa fa-align-left"></i></button>
                    <button class="btn btn-xs btn-default ${align==2?'btn-primary':''} cb_aligncenter" title="水平居中对齐" 
                    onclick="formDesignSetSelectionProperty('text-align',2);" >
                    <i class="fa fa-align-center"></i></button>
                    <button class="btn btn-xs btn-default ${align==1?'btn-primary':''}  cb_alignright" title="水平右对齐"
                    onclick="formDesignSetSelectionProperty('text-align',1);" >
                    <i class="fa fa-align-right"></i></button>
                </div>

                <div class="btn-group">
                    <button class="btn btn-xs btn-default ${valign==0?'btn-primary':''}" id="cb_aligntop" title="垂直顶对齐" 
                     onclick="formDesignSetSelectionProperty('vertical-align',0);" > 
                    <i class="fa fa-align-left fa-rotate-90"></i></button>
                    <button class="btn btn-xs btn-default ${valign==2?'btn-primary':''}" id="cb_alignmiddle" title="垂直居中对齐"
                     onclick="formDesignSetSelectionProperty('vertical-align',2);" > 
                    <i class="fa fa-align-center fa-rotate-90"></i></button>
                    
                    <button class="btn btn-xs btn-default ${valign==1?'btn-primary':''}" id="cb_alignbottom" title="垂直底对齐"
                     onclick="formDesignSetSelectionProperty('vertical-align',1);" > 
                    <i class="fa fa-align-right fa-rotate-90"></i></button>
                </div>
                    `,
                    onClick: function (evt) {


                    }
                }
            );


            actions= actions.concat([
            {
                name: `<i class="fa fa-cut fa-fw  text-primary" ></i>&nbsp;&nbsp;剪&nbsp;&nbsp;&nbsp;&nbsp;切`,
                    onClick: function () {
                        pView.Sheet.cut();

                    }
            },
            {
                name: `<i class="fa fa-copy  fa-fw  text-primary" ></i>&nbsp;&nbsp;复&nbsp;&nbsp;&nbsp;&nbsp;制`,
                    onClick: function () {
                        pView.Sheet.copy();

                    }
            },
            {
                name: `<i class="fa fa-paste  fa-fw  text-primary" ></i>&nbsp;&nbsp;粘&nbsp;&nbsp;&nbsp;&nbsp;粘`,
                    onClick: function () {
                        pView.Sheet.paste();

                    }
            },

            {
                name: `<i class="fa fa-paste  fa-fw  text-primary" ></i>&nbsp;&nbsp;粘粘Excel`,
                    onClick: function () {
                        pView.Sheet.pasteFromExcel();

                    }
            },
            {
                name: `<i class="fa fa-copy  fa-fw text-primary" ></i>&nbsp;&nbsp;超级复制`,
                    onClick: function () {
                        pView.Sheet.exportSelectionDesign();

                    }
            },
            {
                name: `<i class="fa fa-paste  fa-fw  text-primary" ></i>&nbsp;&nbsp;超级粘粘`,
                    onClick: function () {
                        pView.Sheet.importDesign();

                    }
            }
           ]);



            actions.push(
                {
                    name: `<i class="fa fa-trash fa-fw  text-primary" ></i>&nbsp;&nbsp;清除格式`,
                    onClick: function () {



                        //对所有选中的单元格，清除样式，并重新设置格式
                        formDesignDoInSelection(function(cell)
                        {
                            cell.setPropertyObject(cell.Sheet.Book.PM[0] ); //设置成缺省的属性对象
                        });


                        toastr.info("格式已清除，样式仍保留");

                    }
                }
            );

            actions.push(
                {
                    name: `<i class="fa fa-trash fa-fw  text-primary" ></i>&nbsp;&nbsp;清除样式保留格式`,
                    onClick: function () {
                        var info = cell.getPropertyObject().property;

                        //下面的做法有点low，是设计器中用于设置样式的input，这里直接给clear了
                        $('#cssName').val('');

                        //对所有选中的单元格，清除样式，并重新设置格式
                        formDesignDoInSelection(function(cell)
                        {
                            cell.css='';
                            for( let propName in info)
                            {
                                cell.setPropertyValue(propName, info[propName]);
                            }
                        });


                        toastr.info(" 样式已清除，但保留了格式");

                    }
                }
            );

        } else   // 运行模式下
        {
            actions=[];

            if (userMenu && Util.isArray( userMenu)) actions= actions.concat(userMenu);

            actions.push(
                {
                    name: `<i class="fa fa-copy  fa-fw  text-primary" ></i>&nbsp;&nbsp;复&nbsp;&nbsp;&nbsp;&nbsp;制`,
                    onClick: function () {
                        pView.Sheet.copy();

                    }
                }


            );

        }

        if (cell != null && pView.Sheet.Book.EM.fire('isSysContextMenuEnable', [pView.Sheet, false]))
        {
            if (cell.Bind != null)
            {
                actions.push(
                    {
                        name: `<i class="fa fa-database  fa-fw  text-primary" ></i>&nbsp;&nbsp;复制绑定信息`,
                        onClick: function () {
                            var info = cell.Bind.dataSource + "." + cell.Bind.DBCol;
                            Tools.copyToClipboard(info);
                            toastr.info(info + " 已复制到剪贴板上");

                        }
                    }
                );

                actions.push(
                    {
                        name: `<i class="fa fa-puzzle-piece  fa-fw  text-primary" ></i>&nbsp;&nbsp;复制select`,
                        onClick: function () {
                            var dataSource = cell.Bind.dataSource;
                            var ds = sheet.Book.getDataSource(dataSource).dataStore;
                            var sql = ds.getSelectLastRetrieved();
                            if (sql == '') sql = ds.getSelect();
                            Tools.copyToClipboard(sql);
                            toastr.info(" sql语句已复制到剪贴板上");

                        }
                    }
                );

            }

            actions.push(
                {
                    name: `<i class="fa fa-newspaper-o  fa-fw  text-primary" ></i>&nbsp;&nbsp;复制配置信息`,
                    onClick: function () {
                        var info = cell.serializeTo();
                        Tools.copyToClipboard(JSON.stringify(info, null, 4));
                        toastr.info("配置信息已复制到剪贴板上");

                    }
                }
            );

            actions.push(
                {
                    name: `<i class="fa fa-newspaper-o  fa-fw  text-primary" ></i>&nbsp;&nbsp;复制属性信息`,
                    onClick: function () {
                        var info = cell.getPropertyObject().property;

                        Tools.copyToClipboard(JSON.stringify(info, null, 4));
                        toastr.info(" 属性已复制到剪贴板上");

                    }
                }
            );


        }





        //临时关闭了打印相关的菜单
        if (!pView.Sheet.designMode && pView.Sheet.printPermit && false)
        {
            actions.push(
                {
                    name: `<i class="fa fa-file-o  fa-fw  text-success" ></i>&nbsp;&nbsp;页面设置`,
                    onClick: function () {
                        if (form) form.print_pageSetup();
                    }
                });
            actions.push(
                {
                    name: `<i class="fa fa-file-image-o  fa-fw  text-success" ></i>&nbsp;&nbsp;打印预览`,
                    onClick: function () {
                        if (form) form.print_preview();

                    }
                });
            actions.push(
                {
                    name: `<i class="fa fa-print  fa-fw  text-success" ></i>&nbsp;&nbsp;打印...`,
                    onClick: function () {
                        if (form) form.print_printout();

                    }
                });

        }

        menu = new BootstrapMenu('#' + pView.Sheet.guid, {actions: actions});

        //当菜单项并非只是一个点击项时，操作此菜单中的内容后菜单不能自动关闭，需要手工关闭，因此需要把菜单变量记录下来便于调用它的关闭操作
        window.formDesignContextMenu =menu;



    },

    OnMouseDrag(/*pView.Clas$*/ pView, /*Event*/ e)
    {
        var sheet = pView.Sheet;
        if (this.m_mousestate == MouseState._ResizeSelection_)
        {

            var row1 = this.oldSelection.startRow;
            var col1 = this.oldSelection.startCol;

            var row = pView.GetRowAtPoint(false, e.offsetY);
            if (Util.isObject(row)) row = row.row;
            var row2 = Math.abs(e.offsetY - DrawTool.c_down.y) > Math.abs(e.offsetX - DrawTool.c_down.x) ?
                row : this.oldSelection.endRow;
            var col2 = Math.abs(e.offsetY - DrawTool.c_down.y) < Math.abs(e.offsetX - DrawTool.c_down.x) ?
                pView.GetColAtPoint(false, e.offsetX, row2) : this.oldSelection.endCol;

            sheet.setSelection(new Range(row1, col1, row2, col2));
        }

        if (this.m_mousestate == MouseState._DoSelection_)
        {

            if (sheet.designMode)
            {

                var row1 = this.oldSelection.startRow;
                var col1 = this.oldSelection.startCol;

                var row2 = pView.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row2)) row2 = row2.row;

                var col2 = pView.GetColAtPoint(false, e.offsetX, row2);

                sheet.setSelection(new Range(row1, col1, row2, col2));
            } else
            {
                var deltaX = e.offsetX - DrawTool.c_down.x;
                var deltaY = e.offsetY - DrawTool.c_down.y;

                if (Math.abs(deltaX) > Math.abs(deltaY))
                {
                    sheet.hScroll(5 * pView.devicePixelRatio * (deltaX < 0 ? 1 : -1));
                } else
                {
                    sheet.vScroll(5 * pView.devicePixelRatio * (deltaY < 0 ? 1 : -1));
                }


            }
        }

        if (this.m_mousestate == MouseState._MoveSelection_)
        {

            var row = pView.GetRowAtPoint(false, e.offsetY);
            if (Util.isObject(row)) row = row.row;
            var col = pView.GetColAtPoint(false, e.offsetX, row);

            var /*Range*/ r = sheet.selection;

            var w = r.endCol - r.startCol;
            var h = r.endRow - r.startRow;
            var rc = sheet.RPM.rowCount;
            var cc = sheet.CPM.columnCount;

            var row1 = Math.min(Math.max(0, row - this.deltaRow), rc - 1 - h);
            var col1 = Math.min(Math.max(0, col - this.deltaCol), cc - 1 - w);
            var row2 = row1 + h;
            var col2 = col1 + w;

            sheet.setMovingSelection(new Range(row1, col1, row2, col2));

        }

        var /*Point*/ p = new Point(e.offsetX, e.offsetY);
        var client = pView.getBounds();

        // 计算拖拽时，拖出可视区的距离，用于自动卷滚的计量
        this.outSizeX = 0;
        this.outSizeY = 0;
        if (p.x < 0) this.outSizeX = p.x;
        if (p.y < 0) this.outSizeY = p.y;
        if (p.x > client.width) this.outSizeX = p.x - client.width;
        if (p.y > client.height) this.outSizeY = p.y - client.height;

        // 一定要显示调用
        this.$uper.OnMouseDrag(pView, e);

        // 再交给单元格处理其中的小件
        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        var col = pView.GetColAtPoint(false, e.offsetX, row);

        if (row >= 0 && col >= 0)
        {
            var cell = sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged) cell = cell.mergedBy();
                cell.OnMouseDrag(pView, e);
            }
        }

        DrawTool.FindTool(DrawShape._columnhead_).OnMouseDrag(pView, e);

        //如果在边界处，那么自动滚屏
        if (e.offsetY > client.height - 30 * pView.devicePixelRatio)
        {

            setTimeout(function () {
                pView.Sheet.vScroll(5 * pView.devicePixelRatio);
            }, 500);

        }

        //如果在边界处，那么自动滚屏
        if (e.offsetX > client.width - 30 * pView.devicePixelRatio)
        {

            setTimeout(function () {
                pView.Sheet.hScroll(5 * pView.devicePixelRatio);
            }, 500);

        }

    },


    OnMouseEntered(/*pView.Clas$*/ pView, /*Event*/ e)
    {


    },

    /*@Override*/
    OnMouseExited(/*pView.Clas$*/ pView, /*Event*/ e)
    {


    },

    /*@Override*/
    keyPressed(/*pView.Clas$*/ pView, /*Event*/ e)
    {

        this.$uper.keyPressed(pView, e);

        if (this.m_mousestate == MouseState._MoveSelection_)
        {

            var hCur = ActionTool.IDC_MOVESELECTION;
            if (e.controlKey) hCur = ActionTool.IDC_MOVESELECTION2;
            pView.setCursor(hCur);

        }

    },

    /*@Override*/
    keyReleased(/*pView.Clas$*/ pView, /*Event*/ e)
    {

        this.$uper.keyReleased(pView, e);

        if (this.m_mousestate == MouseState._MoveSelection_)
        {

            var hCur = ActionTool.IDC_MOVESELECTION;
            if (e.controlKey) hCur = ActionTool.IDC_MOVESELECTION2;
            pView.setCursor(hCur);

        }
    }


});

export default SelectTool;
