/**
 * Created by 三宝爹 on 2017/10/13.
 */


import ActionTool from './ActionTool.js';
import MouseState from './MouseState.js';
import DrawShape from './DrawShape.js';
import Point from '../gdi/Point.js';
import Range from '../core/Range.js';

import DrawTool from './DrawTool.js';
import Rectangle from '../gdi/Rectangle.js';
import Util from '../util/Util.js';


var RowHeadTool = DrawTool.extend({

    constructor: function () {
        this.$uper.constructor();

        this.m_drawShape = DrawShape._rowhead_;

        this.m_mousestate = MouseState._Release_;

        this.m_row;
        this.m_DownCol;
        this.m_LastDrawPos = new Point();
        this.m_headrect = new Rectangle();

        this.block = null;

        DrawTool.c_tools.push(this);
    },

    OnLButtonDown: function (/*WorkSheetView*/  pView, e) {
        // 需要在最开始调用父类的方法
        this.$uper.OnLButtonDown(pView, e);

        var point = new Point(e.offsetX, e.offsetY);
        this.m_mousestate = MouseState._CaptureNULL_;

        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ client;
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();
        var /*Rectangle*/ rectCenter = new Rectangle();
        // 得到头部的rect
        client = pView.getBounds();
        var CPM = pView.Sheet.CPM;
        var RPM = pView.Sheet.RPM;

        var w = Math.max(20, pView.Sheet.RPM.getRowHeadWidth() + pView.Sheet.CPM.getFixedColumnWidth());
        this.m_row = pView.GetRowHeadRect(point, rect);
        this.m_DownCol = this.m_row;
        this.m_LastDrawPos.x = rect.x;
        this.m_LastDrawPos.y = rect.y + rect.height;
        this.m_headrect = rect.clone();
        var delta = 3 * pView.devicePixelRatio;
        rectLT.setBounds(rect.x, rect.y, rect.width / 4, delta);
        rectLB.setBounds(rect.x, rect.y + rect.height - 3, rect.width / 4, delta);
        rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, delta);
        rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - delta, w, delta);
        rectCenter.setBounds(rect.x, rect.y + delta, rect.width, rect.height - 2 * delta);

        if (this.m_row > -1)
        {
            if (rectLT.contains(point))
            {
                pView.setCursor(ActionTool.IDC_LT2);
                this.m_mousestate = MouseState._LeftTopDown_;
            }
            if (rectLB.contains(point))
            {
                pView.setCursor(ActionTool.IDC_LB2);
                this.m_mousestate = MouseState._LeftBottomDown_;
            }
            if (rectRT.contains(point))
            {
                pView.setCursor(ActionTool.IDC_RT2);
                this.m_mousestate = MouseState._RightTopDown_;
            }
            if (rectRB.contains(point))
            {
                pView.setCursor(ActionTool.IDC_RB2);
                this.m_mousestate = MouseState._RightBottomDown_;
            }

            if (rectCenter.contains(point))
            {
                pView.setCursor(ActionTool.IDC_RIGHT);
                this.m_mousestate = MouseState._MoveRowDown_;
                var row = pView.GetRowAtPoint(false, e.offsetY);
                if (Util.isObject(row)) row = row.row;
                var cc = CPM.getColumnCount();
                pView.Sheet.setSelection(new Range(row, 0, row, cc - 1));
            }

        }

        if (this.m_mousestate == MouseState._LeftTopDown_ ||
            this.m_mousestate == MouseState._LeftBottomDown_ ||
            this.m_mousestate == MouseState._RightTopDown_ ||
            this.m_mousestate == MouseState._RightBottomDown_)
        {

            var rhw = e.offsetX + 6; // pView.Sheet.RPM.getRowHeadWidth();
            //标记线不要到头，让鼠标不要落到它上面，不然，鼠标落在这个block上，鼠标事件就不能接收了
            var blockHTML = `
                                 <div id=block-resizerow 
                                 style="position:absolute;left:0px;height:0px;right:0;border-top:1px  dotted green;
                                 pointer-events :  none;
                                 background-color:white;"></div>
                               `;

            this.block = $(blockHTML);

            var container = $('#' + pView.Book.View.containerID + ' .viewContainser');

            this.block.appendTo($(container));

            this.block.css("top", e.offsetY + "px");
        }


    },

    OnMouseExited: function (/*WorkSheetView*/  pView, /*Event*/ e) {
        if (this.block)
        {
            if (!DrawTool.c_IsDraging)
            {
                this.block.remove();
                this.block = null;
            }
        }

    },

    OnLButtonDblClk: function (/*WorkSheetView*/  pView, e) {

    },
    OnLButtonUp: function (/*WorkSheetView*/  pView, e) {
        // //需要在最开始调用父类的方法
        this.$uper.OnLButtonUp(pView, e);

        if (this.block)
        {
            this.block.remove();
            this.block = null;
        }


        var point = new Point(e.offsetX, e.offsetY);
        var s;
        var row1, row2; // 需要调整宽度的两个列的列号
        var /*Rectangle*/ client;
        var /*Rectangle*/ rect = new Rectangle();
        var delta, delta2, w1, w2;
        var CPM = pView.Sheet.CPM;
        var RPM = pView.Sheet.RPM;

        var areaCount = RPM.getRowCount();
        client = pView.getBounds();
        if (this.m_row > -1)
        {
            // 鼠标落在第n个单元格的左边，调整的是第 n - 1 个单元格的宽度
            switch (this.m_mousestate)
            {
                case MouseState._LeftTopDown_ : // 两个列之间的宽度按调整
                case MouseState._LeftBottomDown_ : // 两个列之间的宽度按调整
                    if (this.m_mousestate == MouseState._LeftTopDown_)
                    {
                        row1 = this.m_row - 1;
                        row2 = this.m_row;
                    }
                    else
                    {
                        row1 = this.m_row;
                        row2 = this.m_row;
                        do // 找到下一个高度不为0的列
                        {
                            row2++;
                            if (row2 >= areaCount - 1) break;
                            if (RPM.getRowHeight(row2) > 0) break;
                        } while (true);
                    }
                    if (row2 >= areaCount) break;// 到最后一列时，不存在两个列
                    delta = Math.max(0, point.y - (CPM.getColumnHeadHeight() + RPM.getRowY(row1) -
                        (row1 >= RPM.getFixedRowCount() ? pView.Sheet.getYOffset() : 0))); // 调整的高度不能小于0

                    pView.Sheet.setHeightBetweenTwoRow(row1, row2, delta);
                    break;

                case MouseState._RightTopDown_ : // 调整一个列的高度
                case MouseState._RightBottomDown_ : // m_col - 1肯定是合法的
                    if (this.m_mousestate == MouseState._RightTopDown_)
                    {
                        row1 = this.m_row - 1;
                    }
                    else
                    {
                        row1 = this.m_row;
                    }
                    delta = Math.max(0, point.y - (CPM.getColumnHeadHeight() + RPM.getRowY(row1) -
                        (row1 >= RPM.getFixedRowCount() ? pView.Sheet.getYOffset() : 0))); // 调整的高度不能小于0
                    pView.Sheet.setRowHeight(row1, delta);
                    break;

                case MouseState._MoveRowDown_ :

                    pView.setCursor(ActionTool.IDC_RIGHT);

                    break;
            }// end switch

        }// end col

        pView.repaint();
        this.m_mousestate = MouseState._Release_;

    },

    canDoResizeRowHeight: function (/*WorkSheetView*/  pView, e) {
        var point = new Point(e.offsetX, e.offsetY);


        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();

        var s;
        // HCURSOR hCur;
        // 如果鼠标没有按下，则获取鼠标所在的头部的rect
        // 否则设置鼠标所在的rect为鼠标按下时的rect
        if (this.m_mousestate == MouseState._Release_ || this.m_mousestate == MouseState._CaptureNULL_)
        {
            this.m_row = pView.GetRowHeadRect(point, rect);
            this.m_headrect = rect.clone();
        }
        else
        {
            rect = this.m_headrect.clone();
        }
        if (this.m_row > -1)
        {
            var  ab=0; // 开关， 用于控制是否只要在锁定列左边，就可以改变行高， 1表示是，0表示否（只能在行头上才能调整行高)
            var w = Math.max(20, pView.Sheet.RPM.getRowHeadWidth() + pView.Sheet.CPM.getFixedColumnWidth()*ab);
            var delta = 3 * pView.devicePixelRatio;
            rectLT.setBounds(rect.x, rect.y, rect.width / 4, delta);
            rectLB.setBounds(rect.x, rect.y + rect.height - 3, rect.width / 4, delta);
            rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, delta);
            rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - 3, w, delta);

            if (rectLT.contains(point)) return true;
            if (rectRT.contains(point)) return true;
            if (rectLB.contains(point)) return true;
            if (rectRB.contains(point)) return true;

        }
        return false;

    },

    OnMouseMove: function (/*WorkSheetView*/  pView, e) {

        if (this.block != null)
        {
            this.$uper.OnMouseMove(pView, e);
            this.OnMouseDrag(pView, e);

            return;

        } else
        {

        }

        var point = new Point(e.offsetX, e.offsetY);


        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();
        var /*Rectangle*/ rectCenter = new Rectangle();

        var hCur = ActionTool.IDC_ARROW;

        // HCURSOR hCur;
        // 如果鼠标没有按下，则获取鼠标所在的头部的rect
        // 否则设置鼠标所在的rect为鼠标按下时的rect
        if (this.m_mousestate == MouseState._Release_ || this.m_mousestate == MouseState._CaptureNULL_)
        {
            this.m_row = pView.GetRowHeadRect(point, rect);
            this.m_headrect = rect.clone();
        }
        else
        {
            rect = this.m_headrect.clone();
        }
        if (this.m_row > -1)
        {
            var w = Math.max(20, pView.Sheet.RPM.getRowHeadWidth() + pView.Sheet.CPM.getFixedColumnWidth());
            var delta = 3 * pView.devicePixelRatio;
            rectLT.setBounds(rect.x, rect.y, rect.width / 4, delta);
            rectLB.setBounds(rect.x, rect.y + rect.height - delta, rect.width / 4, delta);
            rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, delta);
            rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - delta, w, delta);
            rectCenter.setBounds(rect.x, rect.y + delta, rect.width, rect.height - 2 * delta);

            // TRACE( " change cursor on column ");

            if (rectLT.contains(point)) hCur = ActionTool.IDC_LT2;
            if (rectRT.contains(point)) hCur = ActionTool.IDC_RT2;
            if (rectLB.contains(point)) hCur = ActionTool.IDC_LB2;
            if (rectRB.contains(point)) hCur = ActionTool.IDC_RB2;
            if (rectCenter.contains(point)) hCur = ActionTool.IDC_RIGHT;

            pView.setCursor(hCur);
        }// end if_0

        // 如果鼠标没有按下并且位置在头部，但是不是在resize , 则还原光标
        // if( this.m_row==-1 && m_col==-1)pView.SetCussor(AfxGetApp().LoadStandardCursor ( ActionTool.IDC_ARROW ));

        // 调用的位置是很重要的
        this.$uper.OnMouseMove(pView, e);

        // 如果鼠标没有按下并且位置不在列 的头部，则设置鼠标工具为selection
        //// 增加　 hCur == ActionTool.IDC_ARROW　表示不是在resize行高
        if (!pView.isOnRowHeader(point) && !DrawTool.c_IsDraging && hCur == ActionTool.IDC_ARROW)
        {
            //把工具还原为　_selection_ ,更多的判断交给 SelectTool.OnMouseMove中去判断
            pView.setCursor(ActionTool.IDC_ARROW);
            DrawTool.c_drawShape = DrawShape._selection_;
            // TRACE( " change to selection \n");
        }
    },

    OnMouseDrag: function (/*WorkSheetView*/  pView, e) {

        if (this.block)
        {
            this.block.css("top", (e.offsetY + 1 * pView.devicePixelRatio ) + "px");
        }
        ////需要在最后调用父类的方法
        this.$uper.OnMouseDrag(pView, e);


    },

    OnRButtonDown: function (/*WorkSheetView*/  pView, e) {
        this.$uper.OnRButtonDown(pView, e);
    }


});

export default RowHeadTool;
