/**
 * Created by 三宝爹 on 2017/10/13.
 */


import ActionTool from './ActionTool.js';
import MouseState from './MouseState.js';
import DrawShape from './DrawShape.js';
import Point from '../gdi/Point.js';
import Util from '../util/Util.js';
import DrawTool from './DrawTool.js';
import Range from '../core/Range.js';
import Rectangle from '../gdi/Rectangle.js';
import ALIGNMENT from "../core/ALIGNMENT.js";


var ColumnHeadTool = DrawTool.extend({

    constructor: function () {
        this.$uper.constructor(DrawShape._columnhead_);
        this.m_drawShape = DrawShape._columnhead_;
        this.m_mousestate = MouseState._Release_;


        this.m_col = 0;
        this.m_DownCol = 0;
        this.m_LastDrawPos = new Point();
        this.m_headrect = new Rectangle();

        this.m_lastInfo = "";

        this.block = null;
        DrawTool.c_tools.push(this);
    },

    OnLButtonDown: function (/*(WorkSheetView*/  pView, e) {
        //需要在最开始调用父类的方法
        this.$uper.OnLButtonDown(pView, e);

        var point = new Point(e.offsetX, e.offsetY);
        this.m_mousestate = MouseState._CaptureNULL_;

        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ client;
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();
        var /*Rectangle*/ rectCenter = new Rectangle();
        //得到头部的rect
        client = pView.getBounds();
        var CPM = pView.Sheet.CPM;
        var RPM = pView.Sheet.RPM;

        var fixedRowHeight = Math.max(20, RPM.getFixedRowHeight());

        this.m_col = pView.GetColumnHeadRect(point, rect);
        this.m_DownCol = this.m_col;
        this.m_LastDrawPos.x = rect.x;
        this.m_LastDrawPos.y = rect.y + rect.height;
        this.m_headrect = rect.clone();
        var delta = 3 * pView.devicePixelRatio;
        rectLT.setBounds(rect.x, rect.y, delta, rect.height / 4);
        rectLB.setBounds(rect.x, rect.y + rect.height / 4, delta, rect.height * 3 / 4 + fixedRowHeight*1);
        // 增加，只要在固定行之上，那么就可resize列宽
        rectRT.setBounds(rect.x + rect.width - delta, rect.y, delta, rect.height / 4);
        rectRB.setBounds(rect.x + rect.width - delta, rect.y + rect.height / 4, delta, rect.height * 3 / 4 + fixedRowHeight*1);
        rectCenter.setBounds(rect.x + delta, rect.y, rect.width - 2 * delta, rect.height);
        if (this.m_col > -1)
        {

            //如果是在合并单元格的内部，那么即使鼠标在列的分界部分，也不要显示成resize
            if (!this.inMergedCellCenter(pView, e))
            {
                if (rectLT.contains(point))
                {
                    pView.setCursor(ActionTool.IDC_LT);
                    this.m_mousestate = MouseState._LeftTopDown_;
                }
                if (rectLB.contains(point))
                {
                    pView.setCursor(ActionTool.IDC_LB);
                    this.m_mousestate = MouseState._LeftBottomDown_;
                }
                if (rectRT.contains(point))
                {
                    pView.setCursor(ActionTool.IDC_RT);
                    this.m_mousestate = MouseState._RightTopDown_;
                }
                if (rectRB.contains(point))
                {
                    pView.setCursor(ActionTool.IDC_RB);
                    this.m_mousestate = MouseState._RightBottomDown_;
                }

                if (rectCenter.contains(point))
                {
                    pView.setCursor(ActionTool.IDC_DOWN);
                    this.m_mousestate = MouseState._MoveColumnDown_;

                    var col = pView.GetColAtPoint(false, e.offsetX);
                    var rc = RPM.getRowCount();
                    pView.Sheet.setSelection(new Range(0, col, rc - 1, col));

                }
            }

        }

        if (this.m_mousestate == MouseState._LeftTopDown_ ||
            this.m_mousestate == MouseState._LeftBottomDown_ ||
            this.m_mousestate == MouseState._RightTopDown_ ||
            this.m_mousestate == MouseState._RightBottomDown_)
        {


            var chh = e.offsetY + 6; // pView.CPM.getColumnHeadHeight();
            //坐标不要到头，不然，鼠标落在这个block上，鼠标事件就不能接收了
            var blockHTML = `
                                 <div id=block-resizecolumn 
                                 style="position:absolute;top:0px;width:0px;bottom:0;border-left:1px dotted green;
                                 pointer-events :  none;
                                 background-color:white;"></div>
                               `;
            console.info(blockHTML);
            this.block = $(blockHTML);

            //注意，得到的vieContainer 不一定是workbookView 中的DOM，可能是单元格嵌入的SheetContainer的DOM中的viewContainer
            // 而这恰恰就是所需要的。 当sheet嵌入到sheetContainer中时， 它的鼠标操作，是需要相对container的，而不是整个workBookView
            var container = $('#' + pView.Book.View.containerID + ' .viewContainser');

            this.block.appendTo($(container));

            this.block.css(  "left" , e.offsetX + "px");


        }

    },


    OnMouseExited: function (/*WorkSheetView*/  pView, /*Event*/ e) {
        if (this.block)
        {
            if (!DrawTool.c_IsDraging)
            {
                this.block.remove();
                this.block = null;
            }
        }

    },

    OnLButtonDblClk: function (/*(WorkSheetView*/  pView, e) {

    },

    OnLButtonUp: function (/*(WorkSheetView*/  pView, e) {


        ////需要在最开始调用父类的方法
        this.$uper.OnLButtonUp(pView, e);

        if (this.block)
        {
            this.block.remove();
            this.block = null;
        }

        var point = new Point(e.offsetX, e.offsetY);

        var col1, col2; //需要调整宽度的两个列的列号
        var /*Rectangle*/ client;
        var /*Rectangle*/ rect = new Rectangle();
        var delta, delta2, w1, w2;
        var CPM = pView.Sheet.CPM;
        var RPM = pView.Sheet.RPM;

        var areaCount = CPM.getColumnCount();
        client = pView.getBounds();
        if (this.m_col > -1)
        {
            // 鼠标落在第n个单元格的左边，调整的是第 n - 1 个单元格的宽度
            switch (this.m_mousestate)
            {
                case MouseState._LeftTopDown_: // 两个列之间的宽度按调整
                case MouseState._RightTopDown_: // 两个列之间的宽度按调整
                    if (this.m_mousestate == MouseState._LeftTopDown_)
                    {
                        col1 = this.m_col - 1;
                        col2 = this.m_col;
                    } else
                    {
                        col1 = this.m_col;
                        col2 = this.m_col;
                        do //找到下一个宽度不为0的列
                        {
                            col2++;
                            if (col2 >= areaCount - 1) break;
                            if (CPM.getColumnWidth(col2) > 0) break;
                        } while (true);
                    }
                    // pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    if (col2 >= areaCount) break;// 到最后一列时，不存在两个列

                    delta = Math.max(0, point.x - (RPM.getRowHeadWidth() + CPM.getColumnX(col1) -
                        (col1 >= CPM.getFixedColumnCount() ? pView.Sheet.getXOffset() : 0))); //调整的宽度不能小于0
                    pView.Sheet.setWidthBetweenTwoColumn(col1, col2, delta);

                    break;

                case MouseState._LeftBottomDown_: // 调整一个列的宽度
                case MouseState._RightBottomDown_: // this.m_col - 1肯定是合法的
                    if (this.m_mousestate == MouseState._LeftBottomDown_)
                    {
                        col1 = this.m_col - 1;
                    } else
                    {
                        col1 = this.m_col;
                    }
                    //  pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    delta = Math.max(0, point.x - (RPM.getRowHeadWidth() + CPM.getColumnX(col1) -
                        (col1 >= CPM.getFixedColumnCount() ? pView.Sheet.getXOffset() : 0)));

                    pView.Sheet.setColumnWidth(col1, delta);

                    break;
                case MouseState._MoveColumnDown_:

                    pView.setCursor(ActionTool.IDC_ARROW);

                    break;
            }// end switch

        }// end    col

        pView.repaint();
        this.m_mousestate = MouseState._Release_;

    },

    canDoResizeColumnWidth: function (/*(WorkSheetView*/  pView, e) {
        var point = new Point(e.offsetX, e.offsetY);


        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();
        var /*Rectangle*/ rectCenter = new Rectangle();
        if (this.m_mousestate == MouseState._Release_ || this.m_mousestate == MouseState._CaptureNULL_)
        {
            this.m_col = pView.GetColumnHeadRect(point, rect);
            this.m_headrect = rect.clone();

        }

        var fixedRowHeight = Math.max(20, pView.Sheet.RPM.getFixedRowHeight());
        var delta = 3 * pView.devicePixelRatio;
        rectLT.setBounds(rect.x, rect.y, delta, rect.height / 4);
        rectLB.setBounds(rect.x, rect.y + rect.height / 4, delta, rect.height * 3 / 4 + fixedRowHeight*1);
        rectRT.setBounds(rect.x + rect.width - delta, rect.y, delta, rect.height / 4);
        rectRB.setBounds(rect.x + rect.width - delta, rect.y + rect.height / 4, delta, rect.height * 3 / 4 + fixedRowHeight*1);
        rectCenter.setBounds(rect.x + delta, rect.y, rect.width - 2 * delta, rect.height);

        if (rectLT.contains(point)) return true;

        if (rectRT.contains(point)) return true;

        if (rectLB.contains(point)) return true;

        if (rectRB.contains(point)) return true;

        return false;
    },


    inMergedCellCenter: function (pView, e) {
        // 219.06 增加判断 ：当鼠标处于合并单元格内，且处于两列分界处，也不要显示成Resize光标
        var point = new Point(e.offsetX, e.offsetY);


        var row = pView.GetRowAtPoint(false, e.offsetY);
        if (Util.isObject(row)) row = row.row;
        //
        //鼠标点击处判断列号，要把行号代入，因为行可能是禁止列卷滚的,所在在不同的行上点击，得到的列可能是不同的
        var col = pView.GetColAtPoint(false, e.offsetX, row);


        var cell = null;
        if (row >= 0 && col >= 0)
        {
            cell = pView.Sheet.$cells(row, col);
            if (cell != null)
            {
                if (cell.merged)
                {
                    cell = cell.mergedBy();

                    var rc = pView.getShowRectangleOfCell(false, row, col);
                    rc.x += 3;
                    rc.y += 3;
                    rc.width -= 6;
                    rc.height -= 6;
                    if (rc.contains(point)) return true;
                }

            }

        }
        return false;
    },

    OnMouseMove: function (/*(WorkSheetView*/  pView, e) {

        if (this.block != null)
        {
            this.$uper.OnMouseMove(pView, e);
            this.OnMouseDrag(pView, e);

            return;

        } else
        {

        }

        var point = new Point(e.offsetX, e.offsetY);

        var delta = new Point(3, 0);
        var /*Rectangle*/ client;
        var /*Rectangle*/ rect = new Rectangle();
        var /*Rectangle*/ rectLT = new Rectangle();
        var /*Rectangle*/ rectLB = new Rectangle();
        var /*Rectangle*/ rectRT = new Rectangle();
        var /*Rectangle*/ rectRB = new Rectangle();
        var /*Rectangle*/ rectCenter = new Rectangle();


        var hCur = ActionTool.IDC_ARROW;

        //HCURSOR   hCur;
        //如果鼠标没有按下，则获取鼠标所在的头部的rect
        //否则设置鼠标所在的rect为鼠标按下时的rect
        if (this.m_mousestate == MouseState._Release_ || this.m_mousestate == MouseState._CaptureNULL_)
        {
            this.m_col = pView.GetColumnHeadRect(point, rect);
            this.m_headrect = rect.clone();
        } else
        {
            rect = this.m_headrect.clone();
        }


        var inMergedCellCenter = false;

        if (this.m_col > -1)
        {


            inMergedCellCenter = this.inMergedCellCenter(pView, e);
            //如果是在合并单元格的内部，那么即使鼠标在列的分界部分，也不要显示成resize
            if (!inMergedCellCenter)
            {

                var fixedRowHeight = Math.max(20, pView.Sheet.RPM.getFixedRowHeight());
                var delta = 3 * pView.devicePixelRatio;
                rectLT.setBounds(rect.x, rect.y, 3, rect.height / 4);
                rectLB.setBounds(rect.x, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight*1);
                rectRT.setBounds(rect.x + rect.width - 3, rect.y, 3, rect.height / 4);
                rectRB.setBounds(rect.x + rect.width - 3, rect.y + rect.height / 4, 3, rect.height * 3 / 4 + fixedRowHeight*1);
                rectCenter.setBounds(rect.x + 3, rect.y, rect.width - 2 * 3, rect.height);

                //TRACE( " change  cursor  on column ");

                if (rectLT.contains(point)) hCur = ActionTool.IDC_LT;
                if (rectRT.contains(point)) hCur = ActionTool.IDC_RT;
                if (rectLB.contains(point)) hCur = ActionTool.IDC_LB;
                if (rectRB.contains(point)) hCur = ActionTool.IDC_RB;

                if (rectCenter.contains(point)) hCur = ActionTool.IDC_DOWN;

                pView.setCursor(hCur);
            }

        }//end if_0

        //如果鼠标没有按下并且位置在头部，但是不是在resize , 则还原光标
        //if( m_row==-1 && this.m_col==-1)pView.SetCussor(AfxGetApp().LoadStandardCursor ( ActionTool.IDC_ARROW  ));

        // 调用的位置是很重要的
        this.$uper.OnMouseMove(pView, e);

        //如果鼠标没有按下并且位置不在列 的头部，则设置鼠标工具为selection
        // 增加　 hCur == ActionTool.IDC_ARROW　表示不是在resize列宽
        if (!pView.isOnColumnHeader(point) && !DrawTool.c_IsDraging && hCur == ActionTool.IDC_ARROW)
        {
            pView.setCursor(ActionTool.IDC_ARROW);
            DrawTool.c_drawShape = DrawShape._selection_;

        }
    },


    OnMouseDrag: function (/*(WorkSheetView*/  pView, e) {

        if (this.block)
        {
            this.block.css("left", (e.offsetX + 1 * pView.devicePixelRatio ) + "px");
        }

        ////需要在最后调用父类的方法
        this.$uper.OnMouseDrag(pView, e);


    },

    OnRButtonDown: function (/*(WorkSheetView*/  pView, e) {
        this.$uper.OnRButtonDown(pView, e);
    }


});

export default ColumnHeadTool;
