/**
 * Created by 三宝爹
 *
 * 对日期进行处理的函数
 *
 */


import FU from './FuncUtil.js';
import AJAX from '../../util/ajax.js';
import Color from '../../gdi/Color.js';


var $rpc = AJAX.rpc;

var SySFunc = {

    newGUID: function () {
        return newGuid();
    },

    newGuid: function () {
        var ret = $rpc("script", "debug.ScriptAgent", "utilFunction",
            {
                method: 'newGUID'
            }
        );
        return ret.value;
    },

    iif: function (b, v1, v2) {

        if(b) return v1;
        return v2;
    },

    rgb: function (r, g, b) {
        var color = new Color(r, g, b, 1);
        return '#' + Color.toHex(color.color);
    },

    rgba: function (r, g, b, a) {
        if (a == undefined) a = 1;
        var color = new Color(r, g, b, a);
        return '#' + Color.toHex(color.color);
    },

    innerAction:function(title , action)
    {
        return {text:title , action:action,spreadsheetInnerAction:true};
    }



};

export default SySFunc;
