/**
 * Created by 三宝爹
 *
 * 对日期进行处理的函数
 *
 */


import FU from './FuncUtil.js';


function getStringFromSQL(sql)
{
    return getStringFromSQL2("default", sql)
}

function getNumberFromSQL(sql)
{
    return getNumberFromSQL2("default", sql)
}

function getDoubleFromSQL(sql)
{
    return getDoubleFromSQL2("default", sql)
}

function getDoubleFromSQL2(dsn, sql)
{
    return getNumberFromSQL2(dsn, sql)
}


function getDateFromSQL(sql)
{
    return getDateFromSQL2("default", sql)
}

function getIntFromSQL(sql)
{
    return getIntFromSQL2("default", sql)
}


function getStringFromSQL2(dsn, sql)
{

    var ds = newDataStore(dsn, sql);

    ds.setOnceRetrieveCount(1);
    ds.retrieve();
    if (ds.getRowCount() == 0) return "";
    var ret = '' + ds.getString(0, 0);

    ds = null;

    return ret;

}


function getNumberFromSQL2(dsn, sql)
{

    var ds = newDataStore(dsn, sql);

    ds.setOnceRetrieveCount(1);
    ds.retrieve();
    if (ds.getRowCount() == 0) return 0;
    var ret = ds.getDouble(0, 0);
    ds = null;
    return ret;

}

function getDateFromSQL2(dsn, sql)
{

    var ds = newDataStore(dsn, sql);

    ds.setOnceRetrieveCount(1);
    ds.retrieve();
    if (ds.getRowCount() == 0) return null;
    var ret = ds.getDate(0, 0);
    ds = null;
    return ret;

}

function getIntFromSQL2(dsn, sql)
{

    var ds = newDataStore(dsn, sql);

    ds.setOnceRetrieveCount(1);
    ds.retrieve();
    if (ds.getRowCount() == 0) return 0;
    var ret = ds.getInt(0, 0);
    ds = null;
    return ret;

}


function getValueFromSQL(sql)
{
    return getValueFromSQL2("", sql);
}

function getValueFromSQL2(dsn, sql)
{

    var ds = newDataStore(dsn, sql);

    ds.setOnceRetrieveCount(1);
    ds.retrieve();
    if (ds.getRowCount() == 0) return 0;
    var ret = ds.getValue(0, 0);
    ds = null;
    return ret;

}


function thisrow()
{
    return window['datastore_internal_thisrow'];
}


var DBFunc= {


    getStringFromSQL: getStringFromSQL,
    getNumberFromSQL: getNumberFromSQL,
    getDoubleFromSQL: getDoubleFromSQL,
    getDateFromSQL: getDateFromSQL,
    getIntFromSQL: getIntFromSQL,
    getValueFromSQL: getValueFromSQL,
    getStringFromSQL2: getStringFromSQL2,
    getNumberFromSQL2: getNumberFromSQL2,
    getDateFromSQL2: getDateFromSQL2,
    getIntFromSQL2: getIntFromSQL2,
    getDoubleFromSQL2: getDoubleFromSQL2,
    getValueFromSQL2: getValueFromSQL2,
    thisrow: thisrow

};



export  default DBFunc;


