/**
 * Created by 三宝爹 on 2018/08/26.
 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';
import Point from '../gdi/Point.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';

var TreeEdit = BasicEdit.extend({


    constructor: function (domObj, editStyle) {

        //注意， 不需要侦听focus 事件，但是需要在document上点击时，模拟 focusLost 
        this.$uper.constructor(domObj, false,true);
        this.ES = editStyle;

    },


    customizeBeginEdit: function () {

        let x = this.editRC.x;
        let y = this.editRC.y + this.editRC.height + 2;

        if (this.Sheet.pSheetContainer)
        {
            var p = this.Sheet.View.viewContainer.getBoundingClientRect();

            x = x + p.x;
            y = y + p.y;
        }

        let w = $(document).width();
        if (x + parseInt(this.ES.treeWidth) > w) x = w - this.ES.treeWidth - 20;


        let guid = Tools.newGUID();

        // jconfirm 库它把自已的z-index 设置成 99999999 ，列表必须比它高一层， 不然被遮挡

        var html = `
            
                            
                <div id=treePanel_${guid} style="position:absolute;left:${x}px; 
                                            top:${y}px; 
                                            z-index:999999990;
                                            width:${this.ES.treeWidth || 350}px;
                                            height:${this.ES.treeHeight || 300}px; 
                                            background-color: #efefef;
                                            border:0px solid lightgrey;
                                            -moz-box-shadow:0px 0px 5px gray;
                                            -webkit-box-shadow:0px 0px 5px gray;
                                            box-shadow:0px 0px 3px gray;  ">
                    <div style=" position:relative; padding:5px; top:0px; left:0;height:36px;  
                                 width:auto;right:0; border:0px solid red;overflow: auto; ">
                        <input type="text" id="treeNodeSearch_${guid}"  placeholder="过滤" title="过滤"
                               style="position:absolute; left:5px; padding-left:10px;padding-right:10px; width:auto;right:100px;
                               outline:none; border-radius: 12px;height:24px;border:1px solid lightgray;-webkit-appearance:none ;"/>
                
                        <button class="btn btn-xs btn-alt themed-color"  
                                style="position:absolute; width:20px;right:105px; top:7px; outline:none; border:0 ;background-color:#efefef;"
                                id="cb_refresh_${guid}" title="重新构建树"><i class="fa fa-refresh"></i></button>
                
                
                        <button class="btn btn-xs btn-alt themed-color"  
                                style="position:absolute; width:20px;right:85px; top:7px; outline:none; border:0 ;background-color:#efefef;"
                                id="cb_expand_${guid}" title="展开或收拢整棵树"><i class="fa fa-folder"></i></button>
                
                       
                
                        <button class="btn btn-xs btn-alt btn-primary themed-color"  
                                style="position:absolute;width:60px; right:20px; top:7px; 
                                outline:none; border:1px solid lightgrey ;abackground-color:#efefef;"
                                id="cb_ok_${guid}" title="确定选择，关闭编辑面板"><i class="fa fa-check"></i>确定</button>
                                
                        <button class="btn btn-xs btn-alt themed-color "  
                                style="position:absolute; width:20px;right:0px; top:7px; outline:none; border:0 ;background-color:#efefef;"
                                id="cb_cancel_${guid}" title="放弃选择，关闭编辑面板"><i class="fa fa-remove "></i></button>
                        
                
                    </div>
                    <div style=" position:absolute; padding:5px; top:38px; left:0;height:auto; bottom:0px;background-color: white;
                                                        width:auto;right:0; border:0px solid red;overflow: auto;
                                                       ">
                        <div id="tree_${guid}" class="ztree" style="width:100%; "></div>
                    </div>
                </div>
            `;


        this.treeDOM = $(html);

        let pDOM = this.Sheet.Book.View.getViewContainerDOM();

        if (this.Sheet.pSheetContainer != null) pDOM = document.body;

        this.treeDOM.appendTo(pDOM);

        this.treeDOM.bind('click', function (e) {
            //阻事件继续冒泡，这样document就不会触发click事件，也不会关闭本编辑
            e.stopPropagation();
        });

        var setting = {

            data: {
                key: {
                    title: "t"
                },

                simpleData: {
                    enable: true
                }
            },
            callback: {

                onClick: onClick
            }
        };

        //如果是多选，那么配置多选属性
        if (this.ES.treeSelectMulti)
        {
            Util.merge(setting,
                {
                    view: {
                        selectedMulti: true
                    },
                    check: {
                        enable: true,

                        chkboxType: {"Y": "s", "N": "s"},
                    }
                }, true);

        }


        function onClick(event, treeId, treeNode, clickFlag)
        {

            if (!that.ES.treeSelectMulti)
            {

                that.canvasClickedForceLostFocus(null); // null表示不是真实的点击，而是模拟的
            }

        }


        let innerRow = this.currentDBRow;
        let cell = this.Sheet.cells(this.Row, this.Col);

        //得到树的节点数据，
        let zNodes = this.ES.getTreeNodesForEdit(cell, innerRow);


        let zTreeObj = $.fn.zTree.init($(`#tree_${guid}`), setting, zNodes);

        this.zTreeObj = zTreeObj; //回填时需要用到

        //2021.09.08 增加开始就展开全部
        if( this.ES.treeExpandOnLoad )
        {
            treeExpand();
        }else {
            treeCollapse();
        }


        let hiddenNodes = [];	//用于存储被隐藏的结点
        function nodeSearch()
        {
            //显示上次搜索后背隐藏的结点
            zTreeObj.showNodes(hiddenNodes);

            //查找不符合条件的叶子节点
            function filterFunc(node)
            {
                if (node.isParent) return false; //中间节点始终显示
                var _keywords = $(`#treeNodeSearch_${guid}`).val().toLowerCase();
                if (node.name.toLowerCase().indexOf(_keywords) != -1) return false;
                if ('id=' + node.id == _keywords) return false;
                if (node.code) if (node.code.indexOf(_keywords) != -1) return false;

                return true;
            };

            //获取不符合条件的叶子结点
            hiddenNodes = zTreeObj.getNodesByFilter(filterFunc);

            //隐藏不符合条件的叶子结点
            zTreeObj.hideNodes(hiddenNodes);
            zTreeObj.expandAll(true);
        }


        var that = this;

        //重建树
        function treeRefresh()
        {
            that.ES.treeNodesInited = false;

            let cell = that.Sheet.cells(that.Row, that.Col);
            treeCancel();
            setTimeout(function () {
                cell.beginEdit();

                if( that.ES.treeExpandOnLoad )
                {
                    treeExpand();
                }else
                {
                    treeCollapse();
                }
            }, 100);


        }

        function treeExpandOrCollapse()
        {
            var I=$(`#cb_expand_${guid}`).find("i");
            if( I.hasClass("fa-folder-open"))
            {
                treeCollapse();
            }else
            {
                treeExpand();
            }

        }

        function treeExpand()
        {
            zTreeObj.expandAll(true);
            var I=$(`#cb_expand_${guid}`).find("i");
            I.removeClass("fa-folder");
            I.addClass("fa-folder-open");
        }

        function treeCollapse()
        {
            zTreeObj.expandAll(false);
            var I=$(`#cb_expand_${guid}`).find("i");
            I.addClass("fa-folder");
            I.removeClass("fa-folder-open");
        }

        function treeOK()
        {
            that.canvasClickedForceLostFocus(null); // null表示不是真实的点击，而是模拟的
        }

        function treeCancel()
        {
            that.Escape = true; //表示是按下escape键 ， 不会回填数据
            that.canvasClickedForceLostFocus(null); // null表示不是真实的点击，而是模拟的
        }

        $(`#treeNodeSearch_${guid}`).bind('keyup', nodeSearch);
        $(`#cb_refresh_${guid}`).bind("click", treeRefresh);
        $(`#cb_expand_${guid}`).bind("click", treeExpandOrCollapse);
       // $(`#cb_Collapse_${guid}`).bind("click", treeCollapse);
        $(`#cb_ok_${guid}`).bind("click", treeOK);
        $(`#cb_cancel_${guid}`).bind("click", treeCancel);

        if (this.readOnly)
        {
            $(`#cb_ok_${guid}`).attr("disabled", "disabled");


        }

    },


    //@override
    removeSelf: function () {
        this.$uper.removeSelf();
        this.treeDOM.remove();
    }
    ,

    // 构造编辑框显示的内容
    buildEditText: function (value) {
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }
        this.setValue(s);
    }
    ,

    /**
     *
     * @override
     *
     *
     * @param value
     */
    setValue: function (value) {
        console.info(value);


        value = value || '';

        //多选
        if (this.ES.treeSelectMulti)
        {
            var treeObj = this.zTreeObj;

            var vs = value.split(',');

            function filter(node)
            {
                if( node.data !=null  && node.data  == '' ) return false; // 如果节点的数据为空字符串，则不选中

                if (vs.contains(node.data)) return true;
                if (vs.contains(node.name)) return true;
                if (vs.contains(node.id)) return true;
                return false;

            }

            treeObj.checkAllNodes(false); //取清全部选中的节点

            var nodes = treeObj.getNodesByFilter(filter);

            for (var i = 0; i < nodes.length; i++)
            {
                treeObj.checkNode(nodes[i], true, false);
            }


        } else
        {
            var treeObj = this.zTreeObj;

            function filter(node)
            {
                if (node.data == value) return true;
                if (node.name == value) return true;
                if (node.id == value) return true;
                return false;

            }

            treeObj.checkAllNodes(false); //取清全部选中的节点

            var nodes = treeObj.getSelectedNodes();
            if (nodes.length > 0)
            {
                treeObj.cancelSelectedNode(nodes[0]);
            }


            nodes = treeObj.getNodesByFilter(filter);


            if (nodes.length > 0)
            {
                treeObj.selectNode(nodes[0]);
            }

        }

        if (this.readOnly)
        {
            var nodes = this.zTreeObj.getNodes();
            for (var i = 0, l = nodes.length; i < l; i++)
            {
                this.zTreeObj.setChkDisabled(nodes[i], true, true, true);
            }
        }

    },

    // 回填的值
    getWriteBackValue: function () {
        var s = '';
        var nodes;

        if (this.ES.treeSelectMulti)
        {
            //多选
            nodes = this.zTreeObj.getCheckedNodes(true);
        } else
        {//单选
            nodes = this.zTreeObj.getSelectedNodes();
        }

        var vs = [];
        for (var i = 0; i < nodes.length; i++)
        {
            let node = nodes[i];
            let v = null;
            if (node.data !== undefined)
            {
                v = node.data;
            } else
            {
                v = node.id;
            }
            if (v != null && v != '') vs.push(v);
        }
        s = vs.join(',');


        var v = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow]);
        if (v == undefined) v = s;
        if (v == null) return null;
        s = '' + v;
        if (s == '') s = null;
        return s;
    }
    ,

    getText: function () {
        return this.getWriteBackValue();
    },


    mouseClicked: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            this.setValue('');
            this.removeSelf();

        }

    },

    mouseMoved: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            var cur = "js/spreadsheet/mouse/cursor/hand.gif";
            this.domObj.css("cursor", "url(" + cur + ") 10 10,pointer");

        } else
        {
            this.domObj.css("cursor", "text");

        }
    }


});

export default TreeEdit ;
