/**
 * Created by 三宝爹 on 2017/10
 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';
import Point from '../gdi/Point.js';
import Tools from '../util/Tools.js';
import UniformDataType from '../core/UniformDataType.js';
import ObjectTool from '../db/ObjectTool.js';

import MathFunc from '../eval/function/MathFunc.js';

const VK_UP = 0x26;
const VK_DOWN = 0x28;
const VK_LEFT = 0x25;
const VK_RIGHT = 0x27;
const VK_HOME = 0x24;
const VK_END = 0x23;
const VK_TAB = 9;
const VK_ENTER = 13;
const VK_ESCAPE = 0x1B;
const VK_C = 0x43;
const VK_V = 0x56;
const VK_X = 0x58;
const VK_BACK_SPACE = '\b';
const VK_DELETE = 0x7F;

var keys = [VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT, VK_HOME, VK_END, VK_TAB, VK_ENTER, VK_ESCAPE,
    VK_C, VK_V, VK_X, VK_BACK_SPACE, VK_DELETE];


var NumericEdit = BasicEdit.extend({

    static: {
        format: function (dblValue, decimalCount, showComma, decimalSeparator, groupingSeparator, forEdit) {


            if (forEdit == undefined) forEdit = false;

            if (dblValue == null) dblValue = 0;
            var pattern = Tools.getDecimalPattern(decimalCount, decimalSeparator, showComma, groupingSeparator);


            var p = pattern.indexOf(decimalSeparator);
            var leftPattern;
            var rightPattern;
            if (p > 0)
            {
                leftPattern = pattern.substring(0, p);
                rightPattern = pattern.substring(p + 1);
            } else
            {
                leftPattern = pattern;
                rightPattern = '';

            }

            var strVal = '' + dblValue;
            p = strVal.indexOf(decimalSeparator);
            var leftVal;
            var rightVal;
            if (p > 0)
            {
                leftVal = strVal.substring(0, p);
                rightVal = strVal.substring(p + 1);
            } else
            {
                leftVal = strVal;
                rightVal = '';

            }

            var fitToPattern = function (val, pattern) {
                var ret = [];
                for (var i = 0, j = 0; i < pattern.length; i++)
                {
                    var p = pattern.charAt(i);
                    var v = val.charAt(j);

                    if (p == '#')
                    {
                        ret.push(v);
                        j++;
                        continue;
                    }

                    if (p == '0')
                    {

                        ret.push(v == '' ? '0' : v);
                        j++;
                        continue;
                    }
                    //如果是千分位，如果还有数据，那么千分位是需要的
                    if (p == ',')
                    {
                        if (v != '' && v != '-') ret.push(p);
                    }


                }
                return ret.join('');
            };


            var ret_left = fitToPattern(leftVal.split('').reverse().join(''),
                leftPattern.split('').reverse().join('')).split('').reverse().join('');
            var ret_right = fitToPattern(rightVal, rightPattern);

            if (decimalCount == 0) return ret_left;

            if (forEdit && ret_left == '0') ret_left = ''; //如果是编辑时，0.00在编辑框中显示成 .00 而不是0.00 这样小数点前的0就不需要手工删除

            return ret_left + decimalSeparator + ret_right;


        }
    }

    ,

    constructor: function (domObj, editStyle) {
        this.$uper.constructor(domObj);

        this.ES = editStyle;
        this.m_ShowComma = this.ES.showComma;
        this.m_DecimalCount = this.ES.decimalCount;


        this.m_DecimalSeparator = '.';// 小数点分隔符
        this.m_GroupingSeparator = ',';//千分位分隔符

    },


    initCaretPosition: function () {

        this.setCaretPosition(Math.max(this.DotPos(), 0));
    },

    // 构造编辑框显示的内容
    buildEditText: function (value) {
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }
        this.setValue(s);

    },

    // 回填的值
    getWriteBackValue: function () {
        var s = this.getValue();//不能是getText()

        var v = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow]);
        if (v == undefined) v = s;
        if (v == null) return null;
        s = '' + v;
        if (s == '') s = null;
        return s;
    },

    getValue: function () {
        var s = this.getText();
        s = s.replace(/[,]/g, '');
        if (s == '') return 0;
        return parseFloat(s);
    },


    /**
     *  set the new stored value
     * @param dblValue
     */
    setValue: function (dblValue) {
        //要转换一下，
        dblValue = ObjectTool.changeType(dblValue, UniformDataType.$Numeric);
        var t = this.toString(dblValue, true);
        this.setText(t);
    },


    getPattern: function () {
        return Tools.getDecimalPattern(this.m_DecimalCount, this.m_DecimalSeparator, this.m_ShowComma, this.m_GroupingSeparator);
    },


    /**
     *
     * @param num
     * @param n 保留几位小数
     * @returns {*}
     */
    round(num, n)
    {
        return MathFunc.round(num, n);
    },

    toString(dblValue, forEdit)
    {
        return this.Clas$.format(dblValue, this.m_DecimalCount, this.m_ShowComma,
            this.m_DecimalSeparator, this.m_GroupingSeparator, forEdit);
    },


    //编辑点与小数点的距离
    CaretFarAwayDot: function () {
        var p = this.getCaretPosition();
        var n = this.getText().length;
        if (this.mx_DecimalCount == 0)
        {
            return n - p;
        } else
        {
            return n - p - this.m_DecimalCount - 1;
        }
    },

    //得到小数点的位置
    DotPos: function () {
        var n = this.getText().length;
        if (this.m_DecimalCount == 0)
        {
            return n;
        } else
        {
            return n - this.m_DecimalCount - 1;
        }
    },


    focusGained: function (e) {
        var n = this.getText().length;
        if (this.m_DecimalCount == 0)
        {
            this.setCaretPosition(n);
        } else
        {
            this.setCaretPosition(Math.max(n - this.m_DecimalCount - 1, 0));
        }


    },


    ProcessBackSpace: function () {
        this.ReplaceSel();
        var cp = this.getCaretPosition();
        if (cp == 0) return; // 在最左边，那么直接返回
        var t = this.getText();
        if (t.charAt(0) == '-' && cp == 1) return;
        var s;
        var cfad = this.CaretFarAwayDot(); //距离小数点的距离
        var c = t.charAt(cp - 1);
        //如果碰到小数点和千分位，直接将光标左移动一格
        if (c == this.m_DecimalSeparator || c == this.m_GroupingSeparator)
        {
            this.setCaretPosition(cp - 1);
            return;
        }

        s = t.substring(0, cp - 1) + t.substring(cp);
        s = s.replace(/[,]/g, '');

        var d = parseInt(s);

        this.setValue(d);
        if (cfad >= 0)
        {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        }
        else
        {
            this.setCaretPosition(Math.max(this.DotPos() - cfad - 1, 0));
        }

    },

    ProcessDelete: function () {

        this.ReplaceSel();

        var cp = this.getCaretPosition();
        var t = this.getText();
        if (cp == t.length)
        {
            return;
        }

        var c = t.charAt(cp); //光标右侧的字符

        if (c == this.m_GroupingSeparator || c == '-')
        {
            this.setCaretPosition(cp + 2);
        } else
        {
            this.setCaretPosition(cp + 1);
        }
        this.ProcessBackSpace();

    },

    ProcessNumber: function (pch) {
        this.ReplaceSel();
        var cp = this.getCaretPosition();

        var t = this.getText();
        var s;
        var cfad = 0;
        if (cp == t.length)  //   补丁：当没有小数时，也没有小数点，于是几乎每次都会是这样
        {
            s = t + pch;
        }
        else
        {

            cfad = this.CaretFarAwayDot(); //距离小数点的距离

            var c = t.charAt(cp); //光标右侧的字符
            //如果编辑关标在减号的左边，那么移动关标
            if (c == '-') cp++;

            s = t.substring(0, cp) + pch + t.substring(cp);

        }

        s = s.replace(/[,]/g, '');

        var d = parseFloat(s);

        this.setValue(d);
        if (cfad >= 0)
        {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        }
        else
        {
            this.setCaretPosition(Math.max(this.DotPos() - cfad + 1, 0));
        }

        // 处理 -0.0000 ....1 这种情况
        if (d == 0 && t.charAt(0) == '-')
        {
            cp = this.getCaretPosition();
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }

    },

    ReplaceSel: function () {
        this.replaceSelection("");
        if (this.getText().indexOf('.') < 0)
        {
            this.setValue(this.getValue());
            this.setCaretPosition(this.DotPos());
        }

    },

    //按下小数点
    ProcessDot: function () {
        this.ReplaceSel();
        if (this.m_DecimalCount == 0)
        {
            return;
        }
        this.setCaretPosition(this.DotPos() + 1);
    },

    ProcessMINUS: function () {
        this.ReplaceSel();
        var d = this.getValue();
        var cp = this.getCaretPosition();
        var t = this.getText();
        cp += (t.charAt(0) == '-') ? -1 : 1;
        this.setValue(-d);
        this.setCaretPosition(cp);
        if (d == 0 && t.charAt(0) != '-')
        {
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }

    },

    ProcessPLUS: function () {
        this.ReplaceSel();
        var d = this.getValue();
        if (d >= 0)
        {
            return;
        }
        this.ProcessMINUS();

    },


    /**
     *
     * 控制键，非可见按键比如backspace 在此事件 中用 getKeyCode 不能得到正确的值，返回的都是 0
     * 所以只能用 getKeyChar
     * */

    keyTyped: function (e) {

        var c = e.key;
        if (c >= '0' && c <= '9')
        {
            this.ProcessNumber(c);
            e.preventDefault();
        }

        if (c == '.')
        {
            this.ProcessDot();
        }
        if (c == '-')
        {
            this.ProcessMINUS();
        }
        if (c == '+')
        {
            this.ProcessPLUS();
        }

        switch (e.keyCode)
        {
            case  VK_BACK_SPACE :

                this.ProcessBackSpace();
                e.preventDefault();
                break;
            case   VK_DELETE :
                this.ProcessDelete();
                e.preventDefault();
                break;


            default :
                break;
        }

        this.$uper.keyTyped.call(this, e);

        var kc = e.keyCode;

        for (var i = 0; i < keys.length; i++)
        {
            if (kc == keys[i])
            {
                return;  //关键是这里，return ,不要执行下面的 e.consume ,因为 consume 将中断按钮的处理。不这么处理，那么光标键，del, backspace等都不生效了
            }
        }

        e.preventDefault();
    }


});

export default NumericEdit;
