/**
 * Created by 三宝爹 on 2017/10
 *
 * 2019.04.19 增加autocomplete的支持
 *
 * 2020.01.09 增加0输入显示列表，列表定制显示多列数据 ， 选中后， 回填多列数据
 *
 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';

import ajax from '../util/ajax.js';
import Util from '../util/Util.js';
import Tools from '../util/Tools.js';
import DataSourceConfig from '../core/DataSourceConfig.js';

var NormalEdit = BasicEdit.extend({


    static:
        {
            autocomplateDataStoreCache: {}
        },

    constructor: function (domObj,editStyle) {
        this.$uper.constructor(domObj);
        this.ES=editStyle;

        this.lastAutocompleteKey = 'just null'; //初始化为一个不可能输入的值，避免刚开始时， soure不构建

    },


    // 构造编辑框显示的内容
    buildEditText: function (value) {
        console.info("NormalEdit.buildEditText");
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }
        this.setValue(s);
        //如果有自动完成相关的配置，那么初始化autocomplete

        let me = this;
        let currentSheet= this.Sheet;

        let cell = this.Sheet.cells(this.Row, this.Col);
        let appData = cell.appData;

        if (!appData) return;  // RETURN


        //jQuery UI API - 自动完成部件（Autocomplete Widget）详细文档参看
        // https://www.runoob.com/jqueryui/api-autocomplete.html

        let sourceType = appData.valueChangedToAutoCompleteType || '';

        //字段回填对应关系
        let colMaps = appData.valueChangedToAutoCompleteCopyMap || '';
        let renderExpression = appData.valueChangedToAutoCompleteRender || '';

        colMaps = colMaps.trim();
        renderExpression = renderExpression.trim();

        if (!sourceType) return;

        //构建数据候选清单的函数
        let source = function (request, response) {

            console.info( request.term);
            if (me.lastAutocompleteKey == request.term)
            {
                //到这里，几率很小，并且焦点失去后，这个lastAutocompleteKey就没了，
                console.info("不需要重复构建");
                return;
            }
            me.lastAutocompleteKey = request.term;

            if (sourceType == 'url')
            {
                let url = appData['valueChangedToAutoCompleteURL'];
                if (url == '') return;


                let param = appData['valueChangedToAutoCompleteParam'];
                param = param.trim();

                let resultFunc = appData['valueChangedToAutoCompleteResultFunc'];
                if (!window[resultFunc])
                {
                    toastr.info("结果处理回调函数没有定义");
                    return;
                }

                let sheet = me.Sheet;
                let moreVars = {$$$: request.term};//把当前输入的内容，传入。在表达式中，可以使用变量 $$$ 来获取当前输入的值

                url = sheet.parseInnerParameter(url, me.currentDBRow, false, moreVars); //url也可能有占位符

                if (param != '')
                {
                    param = sheet.parseInnerParameter(param, me.currentDBRow, false, moreVars);
                    try
                    {
                        param = JSON.parse(param);
                    } catch (err)
                    {

                        toastr.error(err);
                        return;
                    }
                }
                else  //没有定义参数时
                {
                    param = {};
                }

                //用jquery的实现
                $.ajax({
                    url: url,
                    dataType: "jsonp",
                    data: param,
                    success: function (data) {
                        var d = window[resultFunc](data);
                        if (Util.isString(d)) d = JSON.parse(d);
                        response(d);
                    }
                });


                return;
            }

            if (sourceType == 'script')
            {
                let url = "runTask?task=" + appData['valueChangedToAutoCompleteScriptCode'];
                let param = appData['valueChangedToAutoCompleteParam'];

                let sheet = me.Sheet;
                let moreVars = {$$$: request.term};//把当前输入的内容，传入。在表达式中，可以使用变量 $$$ 来获取当前输入的值
                param = sheet.parseInnerParameter(param, me.currentDBRow, false, moreVars);

                param = JSON.parse(param);

                ajax.post(url,
                    param,
                    function (ret) {
                        var data = JSON.parse(ret);
                        response(data);

                    }, 'text', true);

                return;
            }

            if (sourceType == 'sql')
            {
                let dbpool = appData['valueChangedToAutoCompleteDBPool'];
                let context = appData['valueChangedToAutoCompleteContext']; //数据包
                let sql = appData['valueChangedToAutoCompleteQuery_encrypted'];
                let maxCount = appData['valueChangedToAutoCompleteMaxCount'];



                let data = me.Sheet.Book.EM.fire("buildDataForValueChangeToAutoComplete",
                    [me.Sheet, cell, dbpool, sql , context , {$$$:request.term},maxCount , me.currentDBRow]);

                if( data==null) //优先使用上述安全模式，如果未提供上述实现，则使用前端模式，仅仅是为了兼容旧程序，在合适的时候，可以删除下面的代码块
                {
                    sql= appData['valueChangedToAutoCompleteQuery'];
                    let ds = me.Clas$.autocomplateDataStoreCache[sql];
                    if (ds == undefined)
                    {

                        ds = newDataStore(dbpool, sql);// newDataStore 在另外的工程的提供，这里直接使用，不太优雅，

                        ds.EM.addListener(
                            {

                                parseInnerParameter: function (expression) {
                                    //用当前Sheet，而不要用book.activeSheet .对于弹出Sheet，或嵌入Sheet，
                                    // 当前sheet并不是activeSheet
                                    var sheet = currentSheet;
                                    //// ds.evaluateInnerRow , ds.$moreVars在使用时再赋值,参看标记20190419
                                    return sheet.evaluate(expression, ds.evaluateInnerRow, false, '', ds.$moreVars);

                                }
                            });

                        ds.setOnceRetrieveCount(1);
                        me.Clas$.autocomplateDataStoreCache[sql] = ds;
                    }

                    //标记20190419  下面的两个数据，在解析内联参数时有用到
                    ds.evaluateInnerRow = me.currentDBRow; //
                    ds.$moreVars = {$$$: request.term};//把当前输入的内容，传入。在表达式中，可以使用变量 $$$ 来获取当前输入的值
                    ds.setOnceRetrieveCount(maxCount || 20);//设置检索数据行数，避免过多数据
                    ds.retrieve();
                    data = [];

                    let RC = ds.rowCount;
                    let CC = ds.columnCount;

                    //如果定制复制数据关系
                    if (colMaps != '' || renderExpression != '')
                    {
                        for (let ri = 0; ri < RC; ri++)
                        {
                            //data.push( ds.getJSON(i,false)); //当字段没有数据时，必须设置它为空字符串，所以不能用 这个
                            var one = {};
                            var firstV;
                            for (let ci = 0; ci < CC; ci++)
                            {
                                var v = ds.getValue(ri, ci);
                                if (v == null) v = "";
                                one[ds.getColumnName(ci)] = v;
                                if (ci == 0) firstV = v;
                            }
                            //如果SQL中有一个名为value 的字段，那么就用它做需要回填被编辑格的数据
                            //否则使用第一列，填到被编辑的单元格
                            if (one.value == null)
                            {
                                one.value = firstV;
                            }
                            data.push(one);
                        }
                    } else
                    {

                        //关于数据的约定：如果只有一列，那么就构建单值数据数组，如果有2个以上列，第一个列是数据值，第二个是显示值，其它列忽略
                        for (let i = 0; i < RC; i++)
                        {
                            data.push(CC == 1 ? ds.getValue(i, 0) : {
                                value: ds.getValue(i, 0),
                                label: ds.getString(i, 1)
                            });
                        }
                    }
                }


                if(data.length==0)
                {
                    data.push({value:'', label:''});
                }


                if( data.length==0)
                {

                    //没有候选数据，把对应列，也清除掉
                    if (colMaps != '') //更多的数据回填
                    {
                        var sheet = me.Sheet; //用编辑 的单元格所在的Sheet来解析别名
                        var colMap = Tools.buildColMap(colMaps);

                        for (let ci = 0; ci < colMap.length; ci++)
                        {
                            let cp = colMap[ci];

                            if (cp.target.alias)
                            {
                                var toCell = sheet.cells(cp.target.alias);
                                if (toCell)
                                {

                                    toCell.setValue(null);
                                    console.info("补全回填触发清除操作：" + cp.target.alias);
                                } else
                                {
                                    toastr.error(" 补全定义,不存在" + cp.target.alias + "别名的单元格");
                                }
                            } else
                            {
                                let dsc = sheet.Book.getDataSource(cp.target.ds);
                                let ds2 = dsc.dataStore;
                                let dbRow = 0;
                                if (dsc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                                {
                                    dbRow = dsc.currentBindRow;
                                }
                                ds2.setValue(dbRow, cp.target.col, null);
                                console.info("补全回填 触发清除操作 ->" + cp.target.col);
                            }
                        }


                    }

                }
                response(data);


            }

        }


        // 如果需要定制列表的显示方式，需要用jQuery UI的控件扩展，参看下面链接
        // https://stackoverflow.com/questions/3813061/jquery-ui-autocomplete-renderitem

        var autocompleteMethod = "autocomplete"; //默认是这个函数


        if (renderExpression != '')//如果有定制的渲染模板
        {
            autocompleteMethod = autocompleteMethod + ((new Date()).getTime());
            //扩展ui.autocomplete ,注意其中的名称 autocompleteMethod，在下面调用时也需要把 autocomplete换成此autocompleteMethod


            //解析渲染模板
            //原理说明: 使用js的多行字符串特性中可以使用 ${变量} 占位符来引用变量的值。
            //  声明一个局部的obj变量， 然后动态构建一个函数，在函数中定义局部变量，指向它外面的obj对象的属性
            // 这样就实现了将对象的变量名，降维到普通的变量名， 然后在多行字符串中使用降维的变量名占位符构建动态字符串
            var renderFunc = function (item) {

                var obj = item;

                var script = [];
                var funcName = "renderFunc" + (new Date()).getTime();

                script.push("function " + funcName + "() ");
                script.push("{");


                for (var p in item)
                {
                    script.push("var " + p + "=obj['" + p + "']; ");
                }

                script.push("return  `" + renderExpression + "`;");
                script.push("}");
                script.push(funcName + "()");


                try
                {
                    return eval(script.join('\n'));
                } catch (err)
                {
                    console.dir(err);
                    return null;
                }

            };


            //https://www.runoob.com/jqueryui/jqueryui-widget-extend.html
            //扩展autoComplete控件，定制它的渲染
            $.widget("custom." + autocompleteMethod, $.ui.autocomplete, {

                _renderItem: function (ul, item) {

                    var html = renderFunc(item);

                    return $("<li>")
                        .attr("data-value", JSON.stringify(item))
                        .append(html)
                        .appendTo(ul);
                }
            });
        }


        $(this.domObj)[autocompleteMethod]({
            delay: 10,
            autoFocus: false,
            source: source,
            minLength: appData.valueChangedToAutoCompleteMinLen,
            open: function (event, ui) {
                BasicEdit.moveAutocomplateToAppropriatePosition(me.domObj);

            },
            //列表某项选中（点击）事件
            select: function (event, ui) {

                if (colMaps != '') //更多的数据回填
                {
                    var sheet = me.Sheet; //用编辑 的单元格所在的Sheet来解析别名
                    var colMap = Tools.buildColMap(colMaps);

                    for (let ci = 0; ci < colMap.length; ci++)
                    {
                        let cp = colMap[ci];
                        let v = ui.item[cp.source];
                        if (cp.target.alias)
                        {
                            var toCell = sheet.cells(cp.target.alias);
                            if (toCell)
                            {
                                if( toCell.Bind!=null)
                                {
                                    let dsc = sheet.Book.getDataSource( toCell.Bind.dataSource);
                                    let ds2 = dsc.dataStore;
                                    let dbRow = 0;
                                    if (dsc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                                    {
                                        dbRow = dsc.currentBindRow;
                                    }
                                    ds2.setValue(dbRow,  toCell.Bind.DBCol, v);
                                    console.info("补全回填 "+v+" ->" +  + toCell.alias+"绑定的结果集中");
                                }else
                                {
                                    toCell.setValue(v);
                                    console.info("补全回填 " + v + " ->" + cp.target.alias);
                                }
                            } else
                            {
                                toastr.error(" 补全定义,不存在" + cp.target.alias + "别名的单元格");
                            }
                        } else
                        {
                            let dsc = sheet.Book.getDataSource(cp.target.ds);
                            let ds2 = dsc.dataStore;
                            let dbRow = 0;
                            if (dsc.dataSourceType == DataSourceConfig.MultiRowDataSource)
                            {
                                dbRow = dsc.currentBindRow;
                            }
                            ds2.setValue(dbRow, cp.target.col, v);
                            console.info("补全回填 "+v+" ->" + cp.target.col);
                        }
                    }

                    me.Escape = true; // 不要再用编辑框的数据回填了，参看  BaseiEdit.focusLost


                }

                setTimeout(function () {

                    me.giveUpFocus();
                    me.Sheet.View.OnKeyDown_Enter({controlKey: false});

                    //模所按回车后，如果下一个可编辑单元格还是自已，则不要进入编辑状态，否则让它进入编辑状态
                    var selection = me.Sheet.getSelection();
                    var self = me.Sheet.cells(me.Row, me.Col);
                    if (!(selection.startRow == self.rowIndex &&
                            selection.startCol == self.columnIndex ))
                    {
                        me.Sheet.View.beginEdit();
                    } else
                    {
                        me.Sheet.View.removeLastEdit();
                    }

                }, 10);
            }

        }).focus(function () { //注意：这里的focus中 this.domObj的focus事件，不是列表的focus事件
            setTimeout(function () { $(me.domObj)[autocompleteMethod]("search", s); }, 10);
        });


    },

    mouseClicked: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            this.domObj.val('');

        }

    },

    mouseMoved: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            var cur = "js/spreadsheet/mouse/cursor/hand.gif";
            this.domObj.css("cursor", "url(" + cur + ") 10 10,pointer");

        } else
        {
            this.domObj.css("cursor", "text");

        }
    },


    // 回填的值dfd
    getWriteBackValue: function () {
        var s = this.getText();

        var v = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow]);
        if (v == undefined) v = s;
        if (v == null) return null;
        s = '' + v;
        if (s == '') s = null;
        return s;
    }


});

export default NormalEdit;
