/**
 * Created by 三宝爹
 *
 * 2017/10  初稿
 *
 *
 * 2020.04.06 增加移动设备适配
 *
 * 列表使用的是jquery autocomplete控件 ，默认情况下。它自动定位，位置通常放在输入框的下边，左对齐
 * 但是当输入框的下面空间不足以放置列表框时，就需要把列表框放在输入框的上面。 这个由  BasicEdit.moveAutocomplateToAppropriatePosition
 * 来实现。
 *
 * 当在移动设备上使用列表框时， 通常会在屏幕下半部分弹出一个面板，将列表框置于其中， 弹出面板使用的是jquery-comfirm . 需要在 autocomplete
 * 显示后（open事件中）将自已移到弹出面板中，并重新设置相对坐标（默认autocomplete列表框是相对body绝对定位的，）
 *
 * 整个关键部分就是在合适的时机，调整列表框的坐标，让它在合适的位置显示。
 *
 *
 */


import BasicEdit from './BasicEdit.js';
import Edit from './Edit.js';
import Tools from '../util/Tools.js';


var DropDownListEdit = BasicEdit.extend({


    constructor: function (domObj, editStyle) {

        //2020.04.04 适配移动设备， 移动设备上，列表框不需要可编辑，避免弹出手机的输入框

        this.$uper.constructor(domObj, !Tools.isMobile(), false);
        this.ES = editStyle;

    },


    // 构造编辑框显示的内容
    buildEditText: function (value) {
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }


        var showText = this.ES.ddlb_data2text(s);


        this.setValue(showText);

        //稳动设备上， 不需要编辑
        if (!this.ES.dropDownListEditable &&  !Tools.isMobile())
        {
            this.domObj.attr("readonly", true);

        } else
        {
            //2019.03 修复bug ,可编辑列表，出现不能编辑的情况
            this.domObj.attr("readonly", false);
            this.domObj.disabled = false;
        }


        var me = this;
        var innerRow = this.currentDBRow;
        var cell = this.Sheet.cells(this.Row, this.Col);
        //显示列表
        var thatDomObj = $(this.domObj);
        var showTexts = this.ES.getDropDownDataForEdit(cell, innerRow).showText;

        var itemMaxCount= showTexts.length;
        var source = null;

        var minLenInput = this.ES.minLenInput;

        //jQuery UI API - 自动完成部件（Autocomplete Widget）详细文档参看
        // https://www.runoob.com/jqueryui/api-autocomplete.html


        if (!this.ES.dropDownListEditable)
        {
            source = showTexts; //如果列表不可编辑，那么直接就是显示值做列表项
            minLenInput = 0;
        } else
        {


            if (minLenInput == 0)
            {
                source = showTexts
            } else
            {
                source = function (request, response) {
                    // request对象只有一个term属性，对应用户输入的文本
                    // response是一个函数，在你自行处理并获取数据后，将JSON数据交给该函数处理，以便于autocomplete根据数据显示列表
                    var key = request.term;

                    if (key == '')
                    {
                        //不限制必须输入内容，那么，没有输入内容时，就显示整个列表
                        if (minLenInput == 0)
                        {
                            response(showTexts);
                            return;
                        }
                        response([]);
                    } else
                    {
                        if (key.length < minLenInput)
                        {
                            response([]); //输入内容必须大于等于指定长度
                            return;
                        }

                        var data = [];

                        for (var i = 0; i < showTexts.length; i++)
                        {
                            if (showTexts[i].indexOf(key) >= 0)
                            {
                                data.push(showTexts[i]);
                            }
                        }
                        response(data);
                    }
                };
            }

        }


        var autocomplate = function (  init) {


            $(me.domObj).autocomplete({
                delay: 10,
                autoFocus: false,
                source: source,
                minLength: minLenInput,
                open: function (event, ui) {


                    if(Tools.isMobile())
                    {

                        if( init)  init();

                    }else
                    {
                        BasicEdit.moveAutocomplateToAppropriatePosition(me.domObj);
                    }



                },
                //列表某项选中（点击）事件
                select: function (event, ui) {

                    me.domObj.attr("readonly", true);

                    let isKeyEvent = event.keyCode != undefined;  //是按键事件
                    let isMouseEvent = event.clientX != undefined; //是鼠标事件

                    setTimeout(function () {

                        if (Tools.isMobile())
                        {
                            if (me.popupDialog)
                            {
                                //标记select

                                me.Escape=false; //表示放弃，下面的 focusLost 中不会触发回填
                                me.popupDialog.close();

                            }
                        }else
                        {
                            me.giveUpFocus();
                        }
                        // 2020.03.30 出现这么一种情况， 当本单元格是最后一个可编辑单元格，按回车后，或点选后，
                        // 下面模拟发送一个回车， 进入下一个编辑单元格，但是本单元格就是最后一个可编辑单元格
                        // 于是编辑焦点又回来了。并不是焦点失去没有触发


                        setTimeout(function () {

                            return ;

                            //如果需要在选择一个项目后，自动进入下一个编辑单元格，那么把上面的return去掉

                            me.Sheet.View.OnKeyDown_Enter({controlKey: false});

                            //模所按回车后，如果下一个可编辑单元格还是自已，则不要进入编辑状态，否则让它进入编辑状态
                            var selection = me.Sheet.getSelection();
                            var self = me.Sheet.cells(me.Row, me.Col);
                            if (!(selection.startRow == self.rowIndex &&
                                    selection.startCol == self.columnIndex ))
                            {
                                me.Sheet.View.beginEdit();
                            } else
                            {
                                me.Sheet.View.forceCurrentEditControlGiveUpFocus();

                            }
                        }, 100);


                    }, 10);
                }

            }).focus(function () { //注意：这里的focus中 this.domObj的focus事件，不是列表的focus事件
                setTimeout(function () { me.showDDLB(); }, 10);
            });
        };
        //
        if (!Tools.isMobile())
        {
            autocomplate();
            return;
        }


        let moreConfig = {backgroundDismiss: true, valign: 'bottom', padding: 10};

        let that = this;

        let height = 300;  // itemHeight + padding
        let domObjHeight  =  30;

        if( this.ES.dropDownListEditable)  height+= domObjHeight+5;

        let popContainerID = "ddlbPopupPanel" ;

        var p = {
            lazyOpen: true,
            theme: 'light',
            boxWidth: "100%",
            useBootstrap: false,
            backgroundDismiss: true, // this will just close the modal
            icon: '',
            offsetBottom: 0,
            offsetTop: 0,
            closeIcon: false,
            animation: 'zoom',
            closeAnimation: 'zoom',
            title: '',
            content: `<div  id="${popContainerID}"   
                            style="width:100%; 
                                    height:${height}px ;
                                    border:0 solid lightgray;" >
                            <div>`,


            onContentReady: function () {




            },

            onOpenBefore: function () {

                $('.jconfirm-cell').css('vertical-align', 'bottom'); //容器靠底边
                $('.jconfirm-box').css({'padding': '10px'}); // 边框
                $('.jconfirm-content-pane').css({margin:0, border:'0'} ); // 默认底边有15px的留白， 去掉




            },
            onOpen: function () {

                // domObj还负责定位列表框，所以需要把domObj调整到合适的位置上

                //当列表可过滤时，输入框
                $('#' + popContainerID).append(that.domObj);



                if( that.ES.dropDownListEditable)
                {


                    $(that.domObj).css({left: 0, top: 0, width: '100%' ,
                        'border':'1px solid gray',
                        'color':'black',
                        'padding':'2px',
                        'padding-left': (domObjHeight/2)+'px',
                        'padding-right':(domObjHeight/2)+'px',
                        'font-size':'16px',
                        'height':(domObjHeight)+'px',
                        'line-height':(domObjHeight)+'px',
                        'border-radius': (domObjHeight/2)+'px' ,
                        'display':'',
                        '-webkit-appearance':'none' //移除 ios 上 input 的默认样式
                    });

                    that.domObj.attr("readonly", false);
                    that.domObj.attr("placeholder", "可一边输入一边过滤");

                    that.domObj.val(showText);
                    that.domObj.disabled = false;

                }else
                {
                    //列表不可编辑过滤时，直接把dobObj 视觉上隐藏直接
                    $(that.domObj).css({left: 0, top: 0, width: '100%', height: '0px', border: '0', color: 'white'});
                }




                autocomplate( function()
                {
                    $('.ui-autocomplete').appendTo( $('#' + popContainerID));
                    var top=  that.ES.dropDownListEditable? domObjHeight+5:0;
                    $('.ui-autocomplete').css({left:0,top:top+'px',width:'100%', height: height+'px'});



                });


                me.showDDLB();
                //弹出容器可能会因为在外面点击而被关闭，而在关闭时会调用 giveUpFocus及foclsLost
                // 默认Escape=true ，这样在focusLost时就不会将数据回填。因为在外面点击本就是放弃的意思
                // 在 autoComplete的 select事件中（参看标记select) 将Escape设置成false，则表示需要执行回填
                me.Escape=true;

                $('.ui-autocomplete').css({  border:'0'} ); //



            },
            onClose: function () {

                me.giveUpFocus();

                me.focusLost(null);

                me.popupDialog = null;

            }
        };


        this.popupDialog = $.dialog(p);

        this.popupDialog.open();


    },


    mouseClicked: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            this.domObj.val('');

        }
        if (!Tools.isMobile()) this.showDDLB();
    },

    mouseMoved: function (e) {

        var rc = this.getBounds();
        if (e.offsetX > rc.width - 16 && e.offsetY <= 16)
        {
            var cur = "js/spreadsheet/mouse/cursor/hand.gif";
            this.domObj.css("cursor", "url(" + cur + ") 10 10,pointer");

        } else
        {
            this.domObj.css("cursor", "text");

        }
    },

    showDDLB: function () {
        if (this.ES.dropDownListEditable && ! Tools.isMobile()) //如果是允许编辑的，那么按当前值过滤列表
        {
            $(this.domObj).autocomplete("search");
        } else //如果是不可编辑的，那么不要过滤列表，而是显示全部
        {
            $(this.domObj).autocomplete("search", '');
        }
    },

    keyPressed: function (e) {

        this.Sheet.Book.View.lastKeyEvent = e;

        this.isShiftDown = e.shiftKey;
        this.isControlDown = e.ctrlKey;

        var keyCode = e.keyCode;

        switch (keyCode)
        {

            case Edit.VK_UP:
            case Edit.VK_DOWN:
                //上下键，交给jquery autocomplete去处理，在列表中上下选择，而不是交给BasicEdit处理，
                return;
            default:
                this.$uper.keyPressed.call(this, e);

        }
    },

    // 回填的值
    getWriteBackValue: function () {
        var s = this.getText();

        var v = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow]);
        if (v == undefined) v = s;

        return this.ES.ddlb_text2data(v);

    }


});


export default DropDownListEdit;

