/**
 * Created by 三宝爹 on 2017/10/30.
 */


import BasicEdit from './BasicEdit.js';
import EditStyle from '../core/EditStyle.js';
import Point from '../gdi/Point.js';
import Property from '../core/Property.js';
import Graphics2D from '../gdi/Graphics2D.js';
import Color from '../gdi/Color.js';
import Rectangle from '../gdi/Rectangle.js';
import ALIGNMENT from '../core/ALIGNMENT.js';
import Edit from './Edit.js';


var CheckboxEdit = BasicEdit.extend({


    constructor: function (domObj, editStyle) {
        this.$uper.constructor(domObj);
        this.ES = editStyle;
        this.checked = true;


    },


    // 构造编辑框显示的内容
    buildEditText: function (value) {
        var s;
        if (value == null || value == '')
        {
            s = this.valueWhenBeginEdit();
        }
        else
        {
            s = value;
        }
        this.setValue(s);

        var cell = this.Sheet.cells(this.Row, this.Col);
        this.checked = cell.isCheckOn(this.currentDBRow);

        this.paint();


    },

    // 回填的值
    getWriteBackValue: function () {

        var v = null;

        if (this.checked) v = this.ES.checkOnValue;
        if (!this.checked) v = this.ES.checkOffValue;


        var ev = this.Sheet.EM.fire('afterEditFocusLostAndBeforeWriteBackToCell',
            [this.Sheet, this.Sheet.cells(this.Row, this.Col), v, this.currentDBRow]);

        if (ev == null) return v;
        if (ev == undefined) return v;
        return ev;
    },

    //本编辑格式使用的DOM对象是canvas,不是input ,所以要覆盖此方法，返回当前编辑的视觉数据
    //override
    getText: function () {
        return '' + this.getWriteBackValue();
    },

    keyPressed: function (e) {
        switch (e.keyCode)
        {
            case Edit.VK_SPACE :
                this.checked = !this.checked;
                this.paint();
                break;
            case Edit.VK_C : //不能这么处理，换用 onCopy事件
                if (e.ctrlKey) this.copyCell();

            default :

                this.$uper.keyPressed.call(this, e);
        }
    },

    copyCell: function () {
        var v = null;

        if (this.checked) v = this.ES.checkOnValue;
        if (!this.checked) v = this.ES.checkOffValue;
        v = '' + v;
        clipboardData.setData("text", v);//浏览器windows的属性

    },

    paint: function () {

        var cell = this.Sheet.cells(this.Row, this.Col);

        var rc = this.getBounds();

        var w = rc.width;
        var h = rc.height;

        rc.x =   0;
        rc.y = 0;



        var /*Property*/ prop = cell.getPropertyObject();// 不要直接用成员变量this.property,因为它可能为空
        var /*Color*/ font_color_default = prop.get(Property.color, Color.BLACK);
        var /*String*/ font_color_expression = prop.get(Property.font_color_expression, "");
        var /*String*/ background_color_expression = prop.get(Property.background_color_expression, "");


        var /*Color*/ groupRowBackground = new Color(0x0000ff);
        var /*String*/ font_family = "FontAwesome"; //prop.get(Property.font_family, "");

        var /*int*/ font_size = prop.get(Property.font_size, 12);
        var /*boolean*/ font_bold = prop.get(Property.font_bold, false);
        var /*boolean*/ font_italic = prop.get(Property.font_italic, false);
        var /*boolean*/ font_underline = prop.get(Property.font_underline, false);
        var /*int*/ align_h = prop.get(Property.text_align, ALIGNMENT.Left);
        var /*int*/ align_v = prop.get(Property.vertical_align, ALIGNMENT.Center);


        var /*boolean*/ word_wrap = prop.get(Property.word_wrap, false);


        var graphics = new Graphics2D(this.domObj);


        var background_color = prop.get(Property.background_color, Color.WHITE);
        if (background_color != '')
        {
            graphics.setColor(background_color);
            graphics.fillRect(0, 0, w, h);
        }
        //如果是在一个多行绑定行中，那么正在编辑的行肯定说法是当前亮显行
        var mrdsn = this.Sheet.RPM.getMultiRowDataSourceName(this.Row);
        if (mrdsn != '')
        {
            graphics.setColor(  this.Sheet.Book.options.gridFocusRowBackgroundColor);
            graphics.fillRect(0, 0, w, h);

        }


        var str = this.checked ? this.ES.checkOnChar : this.ES.checkOffChar ;
        var t= this.ES.checkCaption||'';
        if( t!='')  str=str+" "+t;

        graphics.drawStringWordwrap(rc, str, 0, background_color, font_color_default,
            font_family, font_size, font_bold, font_italic, font_underline,
            cell.$AutoHalign(align_h), align_v, word_wrap);
    },

    mouseClicked: function (e) {
        //点击后，数据立即入
        this.checked = !this.checked;
        //  强制回填数据 ,这一段改篇　BasicEdit.focusLost()
        var value = this.getWriteBackValue();
        var cell = this.Sheet.cells(this.Row, this.Col);
        //dbRow 并不一定就是dbRow,它仅表示鼠标点击可能点击的dbRow
        // 第3个参数用来控制单元格不要重绘
        cell.setValue(value, this.currentDBRow,false);
        // 触发事件
        this.Sheet.Book.EM.fire("cellValueChangedByEdit", [this.Sheet, cell, value, this.currentDBRow]);
        // 增加，这样在点击时就触发cellClick事件
        this.$uper.mouseClicked.call(this, e);

        this.paint();

    },

    /**
     * 通常是返回  cellRect 做编辑框的坐标，但是对于 radio checkbox 等，它不需要外框，只需要text 绘制部分的坐标
     * 所以应该返回 editRC ,而不是 cellRect
     */
    getBounds: function () {
        return this.editRC.clone();
    },


});

export default CheckboxEdit;
