/**
 *
 * 数据库方言
 * Created by zengjun on 2017/5
 */


import Dialect from './Dialect.js';

var  DialectH2 = Dialect.extend({


    constructor: function (ds) {

        this.$uper.constructor(ds, "H2");
        this.m_DateSeparator = '-'; //日期是用-号做分隔符号
    },

    /**
     *  日期需要用-分隔，同不是用.号
     * @param sql
     * @returns {*}
     */
    toLocalSyntax: function (sql) {
        /*

         " \\s*([a-zA-Z0-9_]+)\\s*([><=!]{1,2})\\s*('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}')"
         \\s* 表示字段名前面可以有或或者没有空格
         ([a-zA-Z0-9_]+) 表示到少一个字符表示的字段名  ( rq>=   或　aa.rq>=都匹配
         \\s*\\(*\\s*表示字段名后可以有或者没有空格，可能会有(
         ([><=!]{1,2})表示其中的字符出现一个，或两个
         \\s*表示算符后可以有０到n个空格
         ('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}')  表示　yyyy.mm.dd 表示的格式并且用单引号引着
         \\s*\\)*\\s*表示字段名后可以有或者没有空格，可能会有)

         */
        //TODO
        return sql;
    }


});

export default DialectH2 ;
