/**
 * Created by zengjun on 2017/5
 */

import Class from '../base/Class.js';
import AggregateType from './AggregateType.js';
import AggregateDefine from './AggregateDefine.js';
import ObjectTool from "./ObjectTool.js";
import ObjectType from "./ObjectType.js"
import UniformDataType from '../core/UniformDataType.js';

var ColumnProperty = Class.extend({

    constructor: function (ds) {
        this.m_ds = ds;
        /*DataStore  */
        this.m_Name = "";  //别名    name as realName  其中 m_Name == 'realName'  m_DBName == 'name'
        this.m_DBName = ""; //数据库字段名
        this.m_DBTable = "";
        this.m_DatabaseName = '';
        this.m_UpdateWhereClause = '';
        this.m_Updatable = false;//是否允许更新
        this.m_DataType = 0;
        /*int*/
        this.m_UniformDataType = 0;
        /*int*/
        this.m_DataTypeName = '';
        this.m_ObjType = 0;										//int 对象类型

        this.m_Formula = '';										//表达式
        this.m_DependMap = null;
        /*HashMap*/			//依赖列表
        this.m_AffectMap = null;
        /*HashMap*/			//影响列表

        this.m_ColumnLabel = "";									//标签名称
        this.m_ColumnTag = null;									// 附加数据
        this.m_DefaultValue = null;        //缺省数据，在InsertRow后，自动填充到字段
        this.m_ColumnClassName = "";
        this.m_IncludeUnsureFunction = false; //是不是包含有非确定性函数或变量
        this.m_FillBack = "";
        this.m_typeRedefine = "";

        this.ColumnDisplaySize = '';
        /*int*/
        this.Precision = 0;
        /*int*/
        this.Scale = 0;
        /*int*/
        this.Nullable = true;
        /*boolean*/
        this.m_Property = null;
        /*HashMap*/
        this.m_format = ""; // 输出成字符串时的格式
        this.m_AggregateDefine = null;
        /*AggregateDefine*/

        this.m_InsteadOfNull = null;					// 一定设成私有
        this.m_Data2ViewMap = null;


    },

    /**
     * 当本列中的某行中的值为空时，在表达式中（计算列的表达式等）用这个函数的返回值代替
     * @return
     */
    /*Object*/ getValueInsteadOfNull: function () {
        if (this.m_InsteadOfNull != null)
        {
            return this.m_InsteadOfNull;
        }

        switch (this.m_UniformDataType)
        {
            case UniformDataType.$Integer :
                this.m_InsteadOfNull = 0;
                break;
            case UniformDataType.$Numeric :
                this.m_InsteadOfNull = 0.0;
                break;
            case UniformDataType.$String :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Datetime :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Binary :
                this.m_InsteadOfNull = '';
                break;
            case UniformDataType.$Other :
                this.m_InsteadOfNull = '';
                break;

        }
        return this.m_InsteadOfNull;
    },

    /**
     * 在解析表达式时，如果值为空，就用this.m_InsteadOfNull代替。系统会缺省给出这个值（如果没有指定的话）
     * 也可以用本函数强制指定代替空值的值
     * @param obj
     * @return boolean
     */
    setValueInsteadOfNull: function (obj) {
        if (obj == null) return false;
        this.m_InsteadOfNull = ObjectTool.ChangeType(obj, this.m_UniformDataType);
        return true;

    },

    /**
     * @api {getUniformDataType} 函数   getUniformDataType
     *
     * @apiDescription  getUniformDataType()
     * <br><br> 得到本字段的粗略类型
     *
     * @apiName  getUniformDataType
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     *
     * @apiSuccess (返回值){int} - 将详细的字段类型归集到粗略的大类型
     * 它们可以是如下之一：
     * <ul>
     *     <li>1:整数</li>
     *     <li>2:小数</li>
     *     <li>3:字符串</li>
     *     <li>4:日期</li>
     *     <li>5:二进制</li>
     *     <li>6:其它</li>
     *     <li>7:boolean</li>
     *     <li>99:自动</li>
     * </ul>
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty(0).getUniformDataType();
     *
     */
    getUniformDataType: function () {
        return this.m_UniformDataType;
    },

    serializerToXML: function (XmlWriter) {

    },


    /**
     * @api {getColumnLabel} 函数   getColumnLabel
     *
     * @apiDescription  getColumnLabel()
     * <br><br> 得到本字段的说明，即中文含义
     *
     * @apiName  getColumnLabel
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     *
     * @apiSuccess (返回值){String} - 得到本字段的说明，即中文含义
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getColumnLabel();
     *
     */
    getColumnLabel: function () {
        return this.m_ColumnLabel;
    },

    /**
     * @api {setColumnLabel} 函数   setColumnLabel
     *
     * @apiDescription  setColumnLabel(label)
     * <br><br> 设置本字段的说明，即中文含义
     *
     * @apiName  setColumnLabel
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiParam {String} label 中文含义
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  ds.getColumnProperty('name').setColumnLabel('姓名');
     *
     */
    setColumnLabel: function (columnLabel) {
        this.m_ColumnLabel = columnLabel;
    },

    /**
     * @api {getColumnTag} 函数   getColumnTag
     *
     * @apiDescription  getColumnTag()
     * <br><br> 得到该列的附加数据
     *
     * @apiName  getColumnTag
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     *
     * @apiSuccess (返回值){Variant} - 得到该列的附加数据，任意类型
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getColumnTag();
     *
     */
    getColumnTag: function () {
        return this.m_ColumnTag;
    },

    /**
     * @api {setColumnTag} 函数   setColumnTag
     *
     * @apiDescription  setColumnTag(columnTag)
     * <br><br> 为该列设置一个附加数据
     *
     * @apiName  setColumnTag
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiParam {Variant} columnTag  任意类型数据
     *
     * @apiSuccess (返回值){void} - 无
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  ds.getColumnProperty('name').setColumnTag('abcdefg....');
     *
     */
    setColumnTag: function (columnTag) {
        this.m_ColumnTag = columnTag;
    },

    /**
     * @api {isUpdatable} 函数   isUpdatable
     *
     * @apiDescription  isUpdatable( )
     * <br><br> 该列是否允许更新，当字段通过 setValue 设置数据后，当调用 ds.update(true)时， 更新将提交到数据库，如果字段不允许更新，那么
     * 它并不会提交到数据库中
     *
     * @apiName  isUpdatable
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){boolean} - 是否允许更新
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').isUpdatable();
     *
     */
    isUpdatable: function () {
        return this.m_Updatable;
    },

    /**
     * @api {setUpdatable} 函数   setUpdatable
     *
     * @apiDescription  setUpdatable(updatable)
     * <br><br> 设置该列是否允许更新提交
     *
     * @apiName  setUpdatable
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiParam {boolean} updatable 是否允许更新提交
     *
     * @apiSuccess (返回值){void} - 无
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  ds.getColumnProperty('name').setUpdatable( true);
     *
     */
    setUpdatable: function (updatable) {
        if (this.m_ObjType != ObjectType.isColumn) return;
        this.m_Updatable = updatable;
    },


    /**
     * @api {isInUpdateWhereClause} 函数   isInUpdateWhereClause
     *
     * @apiDescription  isInUpdateWhereClause( )
     * <br><br> 得到该列是否参与构造where 子句
     *
     * @apiName  isInUpdateWhereClause
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){boolean} - 得到该列是否参与构造where 子句
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').isInUpdateWhereClause();
     *
     */
    isInUpdateWhereClause: function () {
        return this.m_UpdateWhereClause;
    },

    /**
     * @api {setUpdateWhereClause} 函数   setUpdateWhereClause
     *
     * @apiDescription  setUpdateWhereClause(updateWhereClause)
     * <br><br> 设置该列是否参与构造where子句
     *
     * @apiName  setUpdateWhereClause
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiParam {boolean} updateWhereClause 是否参与构造where子句
     *
     * @apiSuccess (返回值){void} - 无
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  ds.getColumnProperty('name').setUpdateWhereClause( true);
     *
     */
    setUpdateWhereClause: function (updateWhereClause) {
        this.m_UpdateWhereClause = updateWhereClause;
    },

    /**
     * @api {getDataType} 函数   getDataType
     *
     * @apiDescription  getDataType( )
     * <br>  得到该列的数据类型
     *
     * @apiName  getDataType
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){int} - 字段类型
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getDataType();
     *
     */
    getDataType: function () {
        return this.m_DataType;
    },

    /**
     * @api {getDataTypeName} 函数   getDataTypeName
     *
     * @apiDescription  getDataTypeName( )
     * <br>  得到该列的数据类型名称
     *
     * @apiName  getDataTypeName
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){String} - 字段类型名称
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getDataTypeName();
     *
     */
    getDataTypeName: function () {
        return this.m_DataTypeName;
    },




    /**
     * @api {getDBName} 函数   getDBName
     *
     * @apiDescription  getDBName( )
     * <br>  该列对应的数据库中的字段名称
     *
     * @apiName  getDBName
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){String} - 该列对应的数据库中的字段名称
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getDBName();
     *
     */
    getDBName: function () {
        return this.m_DBName;
    },



    /**
     * @api {getDBTable} 函数   getDBTable
     *
     * @apiDescription  getDBTable( )
     * <br>  得到该列所属的表
     *
     * @apiName  getDBTable
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){String} - 得到该列所属的表
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getDBTable();
     *
     */
    getDBTable: function () {
        return this.m_DBTable;
    },

    /**
     * @api {setDBTable} 函数   setDBTable
     *
     * @apiDescription  setDBTable( table)
     * <br>  设置该字段所属的表
     *
     * @apiName  setDBTable
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiParam {String} table 表名称
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  ds.getColumnProperty('name').setDBTable('t1');
     *
     */
    setDBTable: function (table) {
        this.m_DBTable = table;
    },

    /**
     * @api {getFormula} 函数   getFormula
     *
     * @apiDescription  getFormula( )
     * <br>  如果本列是计算列，那么得到它的公式
     *
     * @apiName  getFormula
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){String} - 如果本列是计算列，那么得到它的公式
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getFormula();
     *
     */
    getFormula: function () {
        return this.m_Formula;
    },


    /**
     * @api {getName} 函数   getName
     *
     * @apiDescription  getName( )
     * <br>  得到本列的名称(别名)
     *
     * @apiName  getName
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){String} - 得到本列的名称
     *
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *  var ds=newDataStore("","select id , name as 名称 from app_user ");
     *  var t1= ds.getColumnProperty(1).getDBName();  // t1== name
     *  var t2= ds.getColumnProperty(1).getName(); // t2== 姓名
     *
     *
     */
    getName: function () {
        return this.m_Name;
    },

    /**
     * @api {getObjType} 函数   getObjType
     *
     * @apiDescription  getObjType( )
     * <br>  得到本列的类型
     *
     * @apiName  getObjType
     * @apiGroup ColumnProperty
     * @apiVersion 1.0.0
     *
     * @apiSuccess (返回值){int} - 如果本列是计算列，那么得到它的公式
     * 可以是如下值之一：
     * <ul>
     *     <li>0 : 字段</li>
     *     <li>1 : sql语句中的计算列</li>
     *     <li>2 : 计算列 </li>
     *     <li>4 : 缓冲区临时字段</li>
     *     <li>8 ：聚合计算列</li>
     *     <li>99: 未知</li>
     * </ul>
     *
     * @apiExample   {js}示例：
     *
     *  //示例
     *
     *  var t= ds.getColumnProperty('name').getObjType();
     *
     */
    getObjType: function () {
        return this.m_ObjType;
    },


    getColumnDisplaySize: function () {
        return this.ColumnDisplaySize;
    },

    setColumnDisplaySize: function (columnDisplaySize) {
        this.ColumnDisplaySize = columnDisplaySize;
    },

    isNullable: function () {
        return this.Nullable;
    },

    setNullable: function (nullable) {
        this.Nullable = nullable;
    },

    getPrecision: function () {
        return this.Precision;
    },

    setPrecision: function (precision) {
        this.Precision = precision;
    },


    getScale: function () {
        return this.Scale;
    },

    setScale: function (scale) {
        this.Scale = scale;
    },


    getDefaultValue: function () {

        return this.m_DefaultValue;
    },


    setDefaultValue: function (value) {
        this.m_DefaultValue = value;

    },


    getPropertyObject: function (indexOrName) {

        if( isNaN(indexOrName)) return this.getPropertyObjectByName(indexOrName);
        let index= indexOrName;
        if (index < 0) return null;
        if (index >= this.getPropertyCount()) return null;
        if (this.m_Property == null) return null;
        var n = 0;
        for (var p in this.m_Property)
        {
            if (n == index) return this.m_Property[p];
            n++;
        }

        return null;

    },


    getPropertyObjectByName: function (propName) {
        if (this.m_Property == null) return null;
        return this.m_Property[propName.toLocaleString()];

    },


    getPropertyCount: function () {
        if (this.m_Property == null) return 0;
        var n = 0;
        for (var p in this.m_Property)
        {
            n++;
        }
        return n;
    },


    setProperty: function (propName, value) {
        if (this.m_Property == null) this.m_Property = {};
        this.m_Property[propName.toLowerCase()] = value;

    },


    getData2ViewMap: function () {
        return this.m_Data2ViewMap;
    },


    setData2ViewMap: function (map) {
        this.m_Data2ViewMap = map;

    },


    getViewText: function (data) {
        if (data == null) return "";
        var s = this.m_ds.getDataAdapter().getFormatedTextValue(data, this.m_DataType, this.Scale);


        if (this.m_Data2ViewMap == null)
        {
            if (data == null) return "";
            return s;
        }

        return m_Data2ViewMap[ObjectTool.changeType(data, UniformDataType.$String)];


    },


    getFillBack: function () {

        return this.m_FillBack;
    },


    setFillBack: function (dbcol) {
        this.m_FillBack = dbcol;

    },


    isIncludeUnsureFunction: function () {
        return this.m_IncludeUnsureFunction;
    },


    setIncludeUnsureFunction: function (includeUnsureFunction) {
        this.m_IncludeUnsureFunction = includeUnsureFunction;
    },


    getColumnClassName: function () {
        return this.m_ColumnClassName;
    },


    getDBTypeAndPrecision: function () {

        var /*DataAdapter*/   da = this.m_ds.getDataAdapter();
        try
        {
            return da.assembleColumnType(this.getDataTypeName(), this.getPrecision(), this.getScale(), this.getColumnTypeRedefine());
        } catch (e)
        {
            return e;
        }


    },


    getColumnTypeRedefine: function () {

        return this.m_typeRedefine;
    },


    setColumnTypeRedefine: function (type) {
        this.m_typeRedefine = type;

    },


    getDatabaseName: function () {
        return this.m_DatabaseName;
    },


    setFormat: function (format) {
        this.m_format = format;

    },


    getFormat: function () {

        return this.m_format;
    }


});



export default ColumnProperty;
