/**
 * Created by zengjun on 2017/4/27.
 * 数据类型枚举
 */



var UniformDataType = {
    $Integer: 1,
    $Numeric: 2,
    $String: 3,
    $Datetime: 4,
    $Binary: 5,
    $Other: 6,
    $Boolean: 7,
    $Auto: 99,
    /**
     * 把字段类型规范成上述几种类型
     * @param dataType
     * @returns {number}
     */
    normalize: function (dataType) {
        var dt = dataType.toLowerCase();
        var p = dt.indexOf(' ');// 比如  int identity
        if (p > 0) dt = dt.substring(0, p);

        switch (dt)
        {

            case 'int':
            case 'int4':
            case 'int8':
            case 'bigint':
            case 'tinyint':
            case 'smallint':
            case 'bit':
            case 'identity':
            case 'serial': //Postgresql  自增量

                return UniformDataType.$Integer;

            case 'numeric':
            case 'number':

            case 'decimal':
            case 'real':
            case 'float':
            case 'smallmoney':
            case 'money':
                return UniformDataType.$Numeric;

            case 'varchar' :
            case 'nvarchar':
            case 'varchar2' :
            case 'nvarchar2':

            case 'longtext':  // sql server
            case 'text':
            case  'char':
            case 'nchar':
            case 'ntext':
            case 'json': //mysql json just as varchar
                return UniformDataType.$String;

            case  'date':
            case 'datetime':
            case 'datetime2':
            case 'datetimeoffset':
            case 'smalldatetime':
            case 'time':
            case 'timestamp':
                return UniformDataType.$Datetime;

            case 'uniqueidentifier':
            case 'binary':
            case 'varbinary':
            case 'image':
                return UniformDataType.$Binary;

            case 'xml':
            case  'tvp':
            case 'udt':
            case 'geography':
            case 'geometry':
            case 'variant':
            case 'sysname':
                return UniformDataType.$Other;
            default:
                console.error('UniformDataType没有处理的类型' + dt);
                return UniformDataType.$Auto;
        }
    }

};

Object.freeze(UniformDataType);

export default UniformDataType;
