/**
 * Created by 三宝爹 on 2018/11/14.
 */


import DrawTool from '../../mouse/DrawTool.js';
import Tools from '../../util/Tools.js';
import Util from '../../util/Util.js';

var startX = 0, startY = 0, endX = 0, endY = 0;
var lastDelta = 0;
var timer = 0;


var ITouchListener = {


    touchStart: function (event) {

        // 如果这个元素的位置内只有一个手指的话
        if (event.targetTouches.length == 1)
        {
            // event.preventDefault();// 阻止浏览器默认事件，重要
            var touch = event.targetTouches[0];

            this.lastTouchX = touch.pageX;
            this.lastTouchY = touch.pageY;

            //按下时的坐标
            this.startTouchX = this.lastTouchX;
            this.startTouchY = this.lastTouchY;
        }

        this.lastDeltaX = 0;
        this.lastDeltaY = 0;


        clearInterval(timer); //清楚历史定时器
        //2020.05.01修正，当在手机上，一个单元格正在编辑时，此时划屏，应该放弃编辑，不然输入框浮在界面上
        this.forceCurrentEditControlGiveUpFocus();

    },

    touchMove: function (event) {

        // 如果这个元素的位置内只有一个手指的话
        if (event.targetTouches.length == 1)
        {
            event.preventDefault();// 阻止浏览器默认事件，重要
            var touch = event.targetTouches[0];

            //println( event.pageX);

            var endX = touch.pageX;
            var endY = touch.pageY;

            var deltaX = this.lastTouchX - endX;
            var deltaY = this.lastTouchY - endY;

            if (isNaN(deltaX)) deltaX = 0;
            if (isNaN(deltaY)) deltaY = 0;

            this.lastTouchX = endX;
            this.lastTouchY = endY;

            console.info(" pagex:" +touch.pageX+"   pageY: "+ touch.pageY);

            //println( deltaX+","+ deltaY);

            var sheet = this.Sheet;

            // 看看谁的变化量大，就往一个方向划，不要两个方向都划
            if (Math.abs(deltaX) > Math.abs(deltaY))
            {
                //println("move  X");
                let v = deltaX; //*  this.devicePixelRatio
                sheet.hScroll(v);
                this.lastDeltaX = v;// * this.devicePixelRatio;
                this.lastDeltaY = 0;
            } else
            {
                // println(" move Y");
                let v = deltaY; //*this.devicePixelRatio;
                sheet.vScroll(v);
                this.lastDeltaY = v;// * this.devicePixelRatio ;
                this.lastDeltaX = 0;
            }


        }


    },

    touchEnd: function (event) {
        // e.preventDefault();

        var sheet = this.Sheet;

        clearInterval(timer); //清楚历史定时器
        if (this.lastDeltaY == 0 && this.lastDeltaX == 0) return;

        var that = this;

        let animateCount = 0;

        timer = setInterval(function () {

            //获取步长 确定移动方向(正负值) 步长应该是越来越小的，缓动的算法。

            //动画原理： 目标位置 = 当前位置 + 步长
            //实现越来越慢的效果

            let step = that.lastDeltaY / 20;
            that.lastDeltaY -= step;

            //console.info(" touch end ..." + that.lastDeltaY);

            var scrolled = sheet.vScroll(step * 40);


            //检测缓动动画有没有停止
            if (Math.abs(that.lastDeltaY) <= 2 || !scrolled)  //如果步进为0，或者已经划到头了，那么停止
            {

                clearInterval(timer);
                timer = 0;


                //如果向上划，那么必须是慢慢划，并松开时，才触发刷新，不然，一不小心划到顶就刷新了也不好

                if (sheet.releaseDragToLoadMoreTop) //这个是判断是不是划到顶了
                {
                    if (sheet.loadMoreWhenScrollToBottom)  //这个是开关项
                    {
                        if (animateCount == 0)
                        {

                            let t = sheet.workBook.EM.fire("loadMoreTipInfoWhenScrollToTop", [this]);
                            if (t != undefined) t = "按住一会儿再松开则刷新";
                            sheet.Book.View.loadMoreDOM.html(t);

                            setTimeout(function () {
                                sheet.Book.EM.fire("loadMoreWhenScrollToTop", [sheet]);
                                sheet.Book.View.loadMoreDOM.css("top", "-1000px");

                            }, 200);
                        } else
                        {
                            sheet.Book.View.loadMoreDOM.css("top", "-1000px");
                        }
                    } else
                    {
                        sheet.Book.View.loadMoreDOM.css("top", "-1000px");
                    }
                }


                //向下划，只要到底就触发刷新


                if (sheet.releaseDragToLoadMoreBottom) //这个是当前划动动作是不是划到底
                {
                    if (sheet.loadMoreWhenScrollToBottom) //这个是开关项
                    {
                        sheet.Book.EM.fire("loadMoreWhenScrollToBottom", [sheet]);

                    }
                    //不管触不触发事件， 它都是要隐藏的
                    sheet.Book.View.loadMoreDOM.css("top", "-1000px");
                }


            }
            animateCount++;
        }, 16.7);

    }


};

export default ITouchListener;
