/**
 * Created by 三宝爹 on 2017/10/15.
 */


import DrawTool from '../../mouse/DrawTool.js';
import RowPropertyManage from '../RowPropertyManage.js';
import ColumnPropertyManage from '../ColumnPropertyManage.js';
import Range from '../Range.js';
import EditStyle from '../EditStyle.js'

const VK_ENTER = 13;
const VK_TAB = 9;
const VK_ESCAPE = 27;
const VK_BACK_SPACE = 32;
const VK_SPACE = 32;


var IKeyListener = {


    keyReleased: function (/*KeyEvent*/ e, /*int*/ editingRow, /*int*/ editingCol, /*int*/ dbRow) {
        this.Book.View.lastKeyEvent = e;
        // 触发事件

        this.EM.fire('keyReleased', [this.Sheet, e, editingRow, editingCol, dbRow]);

    },

    keyTyped(e, editingRow, editingCol, dbRow)
    {
        this.Book.View.lastKeyEvent = e;

        var keyChar = e.key;
        var keyCode = e.keyCode;

        if (keyCode == VK_ESCAPE) return; // 如果是按了Esc，不做什么事
        if (keyCode == VK_TAB) return; // 如果是按了回车，不做什么事


        //如果控制键按下了，且不是同时按下回车键，那么可能是功能组合键，那么不做编辑操作
        if (e.altKey || e.controlKey || e.shiftKey)
        {
            if (keyCode != VK_ENTER) return; //回车
        }


        var r = this.Sheet.selection;
        var row = r.startRow;
        var col = r.startCol;

        var /*String*/ value = '';

        // 排除控制键
        if (keyCode > 32) value = keyChar; //可见字符，带入编辑框
        e.preventDefault();
        this.$beginEdit(row, col, value, null, -1); // 不是由鼠标引起的编辑，所以最后一个参数为null

        this.EM.fire('keyTyped', [this.Sheet, e, editingRow, editingCol, dbRow]);

    },

    keyPressed: function (e, editingRow, editingCol, dbRow) {
        this.Book.View.lastKeyEvent = e;

        /* Ctrl C   Ctrl V 这些系统快捷键，在这里是不触发的，只能通过
         $(document).on('copy', function()       {  });
         的方式来侦听
         */

        var func = this['OnKeyDown_' + e.key];
        if (func) func.call(this, e, editingRow, editingCol, dbRow);
        // 触发事件
        this.EM.fire('keyPressed', [this.Sheet, e, editingRow, editingCol, dbRow]);
    },


    OnKeyDown_F6: function (e) {
        if (e.controlKey)
        {

            var CPM = this.Sheet.CPM;
            var h = this.CPM.getColumnHeadHeight();
            if (h == 0)
            {
                h = RowPropertyManage.defaultRowHeight;
            } else
            {
                h = 0;
            }
            this.CPM.setColumnHeadHeight(h);


            var RPM = this.Sheet.RPM;
            var w = this.RPM.getRowHeadWidth();
            if (w == 0)
            {
                w = 50;
            } else
            {
                w = 0;
            }
            this.RPM.setRowHeadWidth(w);
            this.repaint();
        }
    },


    OnKeyDown_F7: function (e) {
        if (e.controlKey)
        {
            var b = this.Sheet.CPM.isShowColumnIndex();
            this.Sheet.CPM.setShowColumnIndex(!b);
        }
    },


    OnKeyDown_Enter: function (e) {
        if (e.controlKey || this.Sheet.enterKeyAsArrowDown)
        {
            this.OnKeyDown_ArrowDown(e);

        } else
        {
            this.OnKeyDown_Tab(e);

        }
    },


    OnKeyDown_ArrowUp: function (/*KeyEvent*/ e) {
        if (this.Sheet.designMode)
        {
            this.OnKeyDown_UP_DesignMode(e);
        } else
        {
            this.OnKeyDown_UP_RunMode(e);
        }
    },

    OnKeyDown_UP_RunMode: function (/*KeyEvent*/ e) {
        var r = this.Sheet.selection;
        var row = r.startRow;
        var col = r.startCol;
        this.JumpToPriorRowEditableObject(row, col);
        //确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);
    },

    OnKeyDown_UP_DesignMode: function (/*KeyEvent*/ e) {
        var /*Range*/  r = this.Sheet.selection;
        if (e.shiftKey)// 如果按住了Shift，那么认为就是在调节EndSelectedRow
        {
            var /*int*/ row = r.endRow;
            if (row <= r.startRow) return;
            row--;
            this.Sheet.setSelection(new Range(r.startRow, r.startCol, row, r.endCol));

        } else
        // 否则就是在向上移
        {
            var /*int*/ row = r.startRow;
            if (row == 0) return;
            row--;
            this.Sheet.setSelection(new Range(row, r.startCol, row, r.endCol));
        }

        // 确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);

    },

    OnKeyDown_ArrowDown: function (/*KeyEvent*/ e) {

        if (this.Sheet.designMode)
        {
            this.OnKeyDown_DOWN_DesignMode(e);
        } else
        {
            this.OnKeyDown_DOWN_RunMode(e);
        }

    },

    OnKeyDown_DOWN_RunMode: function (/*KeyEvent*/ e) {
        var /*Range*/  r = this.Sheet.selection;
        var /*int*/ row = r.endRow;
        var /*int*/ col = r.startCol;  //2021.05.20 改成 r.startCol , 找下一行的可编辑单元格，要从当前正在编辑的列开始找起，不能从合并区的最右列找起


        // 如果正在编辑的单元格是DDLB编辑方式，那么不要跳到下一行，而是打开下拉列表
        var /*Cell*/
            cell = this.Sheet.$cells(row, col);
        if (cell != null)
        {
            if (cell.isEditing())
            {
                let es = cell.getEditStyle();
                if (es != null)
                {
                    if (es.getEditType() == EditStyle.$DDLB) return;
                }
            }
        }


        this.JumpToNextRowEditableObject(row, col);
        //确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);
    },

    OnKeyDown_DOWN_DesignMode: function (/*KeyEvent*/ e) {
        var /*Range*/  r = this.Sheet.selection;
        var /*int*/ row = r.endRow;
        if (row + 1 == this.RPM.getRowCount()) return;
        row++;
        this.Sheet.setSelection(new Range(e.shiftKey ? r.startRow : row, r.startCol, row, r.endCol));
        // 确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);

    },

    OnKeyDown_ArrowLeft: function (/*KeyEvent*/ e) {
        var /*Range*/  r = this.Sheet.selection;
        if (e.shiftKey)// 如果按住了Shift，那么认为就是在调节EndSelectedCol
        {
            var /*int*/ col = r.endCol;
            if (col <= r.startCol) return;
            col--;
            this.Sheet.setSelection(new Range(r.startRow, r.startCol, r.endRow, col));

        } else
        // 否则就是在向左移
        {
            var /*int*/ col = r.startCol;
            if (col == 0) return;
            col--;
            this.Sheet.setSelection(new Range(r.startRow, col, r.endRow, col));

        }
        // 确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);

    },

    OnKeyDown_ArrowRight: function (/*KeyEvent*/ e) {
        var /*Range*/  r = this.Sheet.selection;
        var /*int*/ col = r.endCol;
        if (col + 1 == this.CPM.columnCount) return;
        col++;
        this.Sheet.setSelection(new Range(r.startRow, e.shiftKey ? r.startCol : col, r.endRow, col));
        // 确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);

    },

    OnKeyDown_PageUp: function (/*KeyEvent*/ e) {

    },
    OnKeyDown_PageDown: function (/*KeyEvent*/ e) {

    },

    OnKeyDown_Tab: function (/*KeyEvent*/ e) {
        if (this.Sheet.designMode)
        {
            this.OnKeyDown_Tab_DesignMode(e);
        } else
        {
            this.OnKeyDown_Tab_RunMode(e);
        }

    },


    OnKeyDown_Tab_RunMode: function (/*KeyEvent*/ e) {
        this.Sheet.setPaintPermit(false);
        var /*Range*/  r = this.Sheet.selection;
        var /*boolean*/ isShiftDown = false;
        //		因为从WorkSheetView_.mouseClicked中调用$beginEdit ,中间会模拟按回车，而此时e==null
        if (e != null) isShiftDown = e.shiftKey;
        if (isShiftDown)
        {
            var /*int*/ row = r.endRow;
            var /*int*/ col = r.endCol;
            this.JumpToPriorColumnEditableObject(row, col);
        } else
        {
            //一定要用 getEndXXX 不然，碰到有行合并的，如果用getStartXXX，那么可能
            // 就会始终下不去
            var /*int*/ row = r.endRow;
            var /*int*/ col = r.endCol;
            this.JumpToNextColumnEditableObject(row, col);
        }
        //确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);
        this.Sheet.setPaintPermit(true);
    }
    ,


    OnKeyDown_Tab_DesignMode: function (/*KeyEvent*/ e) {
        var r = this.Sheet.selection;
        var col = r.endCol;
        if (col + 1 == this.CPM.columnCount) // 如果到了最后一列，那么就跳到下一行的第0列
        {
            var row = r.endRow;
            if (row + 1 == this.RPM.rowCount) return; // 如果已经是最后一行，那么无处可去了
            row++;
            this.Sheet.setSelection(new Range(row, 0, row, 0));
            this.Sheet.setXOffset(0); // 把水平卷滚条拉回来

        } else
        {
            col++;
            this.Sheet.setSelection(new Range(r.endRow, col, r.endRow, col));
        }

        // 确保选中区域在屏幕上
        this.insureSelectionOnScreen(null);

    }


};

export default IKeyListener;
