/**
 * Created by 三宝爹 on
 *
 * 2017/10/16 初稿
 *
 * 2020.04.06 增加编辑时对移动设备的适配。
 *    当在手机上点击进入编辑时，如果编辑框的坐标在半屏以下，那么自动卷调整yOffset ，让它移到半屏以上
 *
 *
 */


import Rectangle from '../../gdi/Rectangle.js';
import Range from '../Range.js';
import DataSourceConfig from '../DataSourceConfig.js';

import EditStyle from '../EditStyle.js';
import Point from '../../gdi/Point.js';
import Tools from '../../util/Tools.js';


var IEdit = {


    beginEdit: function (row, col) {

        if (row == undefined && col == undefined)
        {
            var edit = this.$getCurrentEditingEdit();
            if (edit != null)
            {
                edit.reloadEdit();
            } else
            {

                var /*Range*/  r = this.Sheet.getSelection();
                var row = r.endRow;
                var col = r.endCol;

                this.$beginEdit(row, col, null, null, -1);
            }
        } else
        {
            this.$beginEdit(row, col, null, null, -1);
        }

    },

    /**
     * 让当前编辑框失去焦点，与一个可编辑单元格进入编辑状态
     */
    beginEditNextCell: function () {
        this.OnKeyDown_Tab(null);
        this.beginEdit();
    },


    removeLastEdit: function () {
        var lastEdit = this.$getCurrentEditingEdit();
        if (lastEdit != null)
        {

            var lastCell = lastEdit.getCell();
            lastCell.repaint();
            lastEdit.giveUpFocus();

        }

    },

    $beginEdit: function (row, col, value, mouseEvent, innerRow) {
        //	记下当前正编辑的单元格

        if (!this.Sheet.Book.initOK)
        {
            toastr.info("初始化中，请稍等...");
            return
        }

        var lastEdit = this.$getCurrentEditingEdit();
        var lastRow = -1;
        var lastCol = -1;
        var lastInnerRow = -1;


        //要先把控件删除，不然，当按shift+enter时无法回到上一个编辑控件
        //但是值回填，
        //  先触发旧控件的 endEdit ,  valueChanged事件，再触发新编辑控件的beginEdit
        // 最后触发　editFocusChanged事件 ，那么就可以在 editFocusChanged 事件中按需要可以重新定位
        //到新的编辑单元格里

        //如果不是设计模式，那么判断单元格允不允许编辑
        var cell = this.Sheet.$cells(row, col);

        if (!this.Sheet.designMode)
        {

            if (cell == null) return; // 如果是运行模式，且单元格是空的，那么直接返回
        }

        //既然都要开始编辑了，那就要确保这个单元格已经创建
        cell = this.Sheet.cells(row, col);

        //既然将要处于编辑状态了，那么把Selection设置成它吧
        this.Sheet.setSelection(cell);

        var /*DBBindConfig*/ dbc = cell.bind;
        if (dbc != null)
        { // 如果是绑定到数据源，但其中没有数据，那么也不能编辑
            if (this.Sheet.Book.getDataSource(dbc.dataSource).dataStore.rowCount == 0) return;

            var /*DataSourceConfig*/ dsc = this.Sheet.Book.getDataSource(dbc.dataSource);
            // 如果是绑定到单行DataStore上
            if (dbc.dataSourceType == DataSourceConfig.SingleRowDataSource)
            {
                innerRow = 0;
            } else if (dbc.dataSourceType == DataSourceConfig.AsSingleRowDataSource)
            {
                innerRow = dsc.currentBindRow;
            } else
            {
                if (innerRow == -1) innerRow = dsc.currentBindRow;
            }

            if (innerRow < 0) return;
        }

        var /*boolean*/ readOnlyMode = false;
        var /*EditStyle*/ es = cell.getEditStyle();

        if (!this.Sheet.designMode)
        {

            //当 mouse==null 时，通常是程序强制到某单元格进行编辑
            // 当mouse!=null时，是点击鼠标操作，这时，点击的单元格不一定是可编辑的

            var /*boolean*/ canEdit = cell.isEditable() && cell.Sheet.Editable;
            if (canEdit)
            {
                canEdit = this.Book.EM.fire("isCellEditable", [this.Sheet, cell, innerRow], true);
            }
            if (!canEdit)
            {
                if (mouseEvent == null)
                {
                    //如果指定的单元格不允许编辑，那么就编辑下一个允许编辑的单元格吧
                    this.OnKeyDown_Tab(null);
                    //可能还需要做点什么让它处于编辑状态

                }

                if (lastEdit != null) lastEdit.giveUpFocus();

                if (es != null)
                { //如果是有字段绑定的，是多行或富文本的，那么不允许编辑时，则以只读方式显示编辑器，以方便卷滚，如果没有绑定，那么不要
                    if (es.getEditType() == EditStyle.$MultiLine ||
                        es.getEditType() == EditStyle.$RichText && cell.bind != null)
                    {
                        readOnlyMode = true;
                    } else if (es.getEditType() == EditStyle.$Tree && es.treeSelectMulti)
                    {
                        readOnlyMode = true;
                    } else
                    {
                        return;
                    }
                } else
                {
                    return;
                }
            } else  //2020.04.29修正，当树在编辑时，直接点击另一个可编辑单元格， 会发生异常，所以增加了此处的修正
            {
                // 当点击的本单元格是允许编辑的，那么下面就让它进入编辑，
                //注意 ， 在进入编辑前， 前一个正在编辑的控件即 lastEdit ,通常可以在本单元格进入编辑时，由blur事件触发 focusLost
                //但是有一些编辑方式比如树，它并不是由blur触发的，此时，需要手工触发让它失去焦点
                if (lastEdit != null && lastEdit.outsideClickedForceLostFocus) lastEdit.handle_canvasClickedForceLostFocus();
            }

        }

        console.info("移动设备上，编辑框保持在半屏以上，但 checkbox， radiobox除外");

        var needInHalfScreen = false;
        if (Tools.isMobile() &&  es!=null)
        {
            let et = es.getEditType();
            switch (et)
            {
                //这几项不需要控制必须显示在上半屏
                case EditStyle.$CheckBox:
                case EditStyle.$RadioButton:
                case EditStyle.$MultiCheckBox:
                    needInHalfScreen = false;
                    break;
                default:
                    needInHalfScreen = true;
                    break;

            }

        }
        //调整insureSelectionOnScreen以适应移动设备
        this.insureSelectionOnScreen(mouseEvent == null ? null : new Point(mouseEvent.offsetX, mouseEvent.offsetY),
            needInHalfScreen);
        // 强制显示在可视区中

        if (lastEdit != null)
        {


            var lastCell = lastEdit.getCell();
            lastCell.repaint();


            lastRow = lastCell.rowIndex;
            lastCol = lastCell.columnIndex;
            lastInnerRow = lastEdit.currentDBRow;
        }

        var NE = this.Book.View.createEditComponent(es);

        //编辑控件加到父容器中
        var container = $(this.canvas.parentNode);

        NE.domObj.appendTo(container);

        this.$setCurrentEditingEdit(NE);

        //用于焦点区的跳转
        if (dbc != null) this.$setCurrentEditintDSN(dbc.dataSource);

        //设置当前编辑焦点区，便于按回车后的下一个可编辑单元格的跳转

        this.Sheet.moveToFocusRange(row, col);

        // 由于上面的InsureSelectionOnScreen函数的调用, mouse 可能被做了相应调整，参看*0815
        var rc = this.getShowRectangleOfCell(false, row, col);

        console.dir(NE.domObj);

        NE.beginEdit(this.Sheet, this, row, col, value, rc, mouseEvent, innerRow, readOnlyMode);

        //如果当前编辑位置与上一个编辑位置相同，那么直接放弃焦点
        if (lastRow == row && lastCol == col && lastInnerRow == innerRow)
        {
            NE.giveUpFocus();
        }

        //
        // 最后触发编辑焦点改变事件，这样将可以在该事件里里用beginEdit函数重新调整当前编辑单元格
        this.Book.EM.fire("editFocusChanged", [this.Sheet, lastRow, lastCol, row, col]);


    },


    $getCurrentEditingEdit: function (already) {

        if (this.currentEditingEdit != null) return this.currentEditingEdit;

        if (already == undefined) already = [];

        if (already.contains(this)) return null; //已经搜索过自己了，那么直接返回

        already.push(this);

        //TODO 内嵌sheet中找
        /*
        for (var  i = 0; i < this.Sheet.cellPanelList.length; i++)
        {
            var  view = this.Sheet.cellPanelList[i].getInnerSheet().View;
            var  edit = view.$getCurrentEditingEdit(already);
            if (edit != null) return edit;

        }
        */


        //TODO 或者看看自已是不是被包含了，看的父this.Sheet中有没有编辑

        /*


        var cp = this.Sheet.getContainerCellPanel();
        if (cp != null)
        {
            if (cp.getParentthis.Sheet() == null) return null;
            var view =     cp.getParentthis.Sheet().View
            var  edit = view.$getCurrentEditingEdit(already);
            return edit;
        }
        */

        return null;

    },

    /**
     * 当单元格开始编辑时，把当前的编辑控件保存在起来。以备后用
     * 现在用到它的地方就是在当单元格正在编辑时，如果又对它设置值，那么需要在编辑控件上
     * 也反映出当前的数据。
     *
     * 当编辑控件失去焦点时，再把当前编辑控件记录清空（其实这也是不必要的）
     * @param edit
     */
    $setCurrentEditingEdit: function (edit) {
        if (edit == null) return;
        this.currentEditingEdit = edit;
    },

    /**
     * 清除当前编辑控件。
     * 注意当一个cell 在编辑时，另一个cell却要执行清除工作时，要判断edit与当前编辑控件是不是同一个，是，那么才清除
     * @param edit
     */
    $clearCurrentEditingEdit: function (edit) {
        if (edit == this.currentEditingEdit)
        {
            this.currentEditingEdit = null;
        }
    },

    $getCurrentEditintDSN: function () {
        return this.currentEditintDSN;
    },

    $setCurrentEditintDSN: function (currentEditintDSN) {
        this.currentEditintDSN = currentEditintDSN;
    }


};

export default IEdit;
