/**
 * Created by zengjun on 2017/7/6.
 *
 * 合并或取消合并
 */


import MergedRange from "../MergedRange.js";
import Range from '../Range.js';

var ISheetMergeOrNot = {


    /**
     * 合并单元格
     * @param startRow
     * @param startCol
     * @param endRow
     * @param endCol
     * @returns {boolean}
     */
    $merge: function (startRow, startCol, endRow, endCol) {
        var rc = this.RPM.rowCount;
        var cc = this.CPM.columnCount;

        if (startRow < 0) startRow = 0;
        if (startRow + 1 > rc) startRow = rc - 1;
        if (startCol < 0) startCol = 0;
        if (startCol + 1 > cc) startCol = cc - 1;

        if (endRow < 0) endRow = 0;
        if (endRow + 1 > rc) endRow = rc - 1;
        if (endCol < 0) endCol = 0;
        if (endCol + 1 > cc) endCol = cc - 1;

        var fr = this.RPM.getFixedRowCount();
        var fc = this.CPM.getFixedColumnCount();

        //if (startRow < fr && endRow >= fr) return false; // 固定行不能与滚动行合并
        //if (startCol < fc && endCol >= fc) return false; // 固定列不能与滚动行合并

        if (startRow == endRow && startCol == endCol) return false;

        for (var row = startRow; row <= endRow; row++)
        {
            for (var col = startCol; col <= endCol; col++)
            {

                var /*Cell*/  cell = this.$cells(row, col);// 在这里进行判断时，不需要单元格一定已经创建
                if (cell == null) continue;
                // 如果其中的单元格已经合并了，那么不能再合并
                if (cell.isMerged()) return false;
            }
        }

        // 记录下合并区的起始和结束的Cell ，如果它们还不存在，那么下面的cells的调用会确保它们会被创建
        var /*Cell*/  cellStart = this.cells(startRow, startCol);
        var /*Cell*/     cellEnd = this.cells(endRow, endCol);
        var /*MergedRange*/  r = new MergedRange(cellStart, cellEnd);
        for (var row = startRow; row <= endRow; row++)
        {
            for (var col = startCol; col <= endCol; col++)
            {
                // 确保它们被创建
                var /*Cell*/            cell = this.cells(row, col);
                this.MergeMap.put(cell, r);
            }
        }

        // 重绘
        if (this.View != null) this.View.repaint();
        return true;

    },


    $unMerge(startRow, startCol, endRow, endCol)
    {
        var
            rc = this.RPM.rowCount;
        var
            cc = this.CPM.columnCount;

        if (startRow < 0) startRow = 0;
        if (startRow + 1 > rc) startRow = rc - 1;
        if (startCol < 0) startCol = 0;
        if (startCol + 1 > cc) startCol = cc - 1;

        if (endRow < 0) endRow = 0;
        if (endRow + 1 > rc) endRow = rc - 1;
        if (endCol < 0) endCol = 0;
        if (endCol + 1 > cc) endCol = cc - 1;

        var realDo = false;

        var /*Range*/ r0 = new Range(startRow, startCol, endRow, endCol);

        for (var row = startRow; row <= endRow; row++)
        {
            for (var col = startCol; col <= endCol; col++)
            {
                var /*Cell*/     cell = this.$cells(row, col);// 在这里进行判断时，不需要单元格一定已经创建
                if (cell == null) continue;
                if (!cell.isMerged()) continue;

                realDo = true;
                var /*MergedRange*/  mr = this.MergeMap.get(cell);
                this.MergeMap.remove(cell);
                // 如果这个单元格所处的合并区域并不是本函数指定的区域，那么把它所在的合并区域也给取消合并
                var /*Range*/ r = mr.getMergedRange();
                if (!r.equals(r0)) this.$unMerge(r.startRow, r.startCol, r.endRow, r.endCol);

            }
        }
        // 重绘
        if (this.View) this.View.repaint();
        return realDo;
    }

};

export default ISheetMergeOrNot ;
