/**
 * Created by 三宝爹 on 2017/7/13.
 *
 * 插入或删除行，列
 */


import Range from '../Range.js';

var ISheetInsertDelete = {

    $$insertRowBefore: function (beforeRow) {
        if (beforeRow < 0) beforeRow = 0;

        var rc = this.SheetRows.length;
        if (beforeRow >= rc)
        {
            this.SheetRows.push(null); // 在最后追加
        } else
        {
            this.SheetRows.splice(beforeRow, 0, null); // 在beforeRow 位置追加
        }
    },

    /**
     * 插入列
     *
     * @param beforeCol
     */
    $$insertColumnBefore: function (beforeCol) {
        if (beforeCol < 0) beforeCol = 0;

        //  由 cc=getColumnCount 改成直接从数据中取数，因为在
        // 一次插入多列数据时，列属性尚未进行扩展
        var cc = this.columnCount;

        var append = (beforeCol >= cc);

        var rc = this.rowCount;
        for (var row = 0; row < rc; row++)
        {
            var /*Row*/  R = this.SheetRows[row];
            if (R == null) continue;
            R.$insertBefore(beforeCol, append);
        }
    },

    $$deleteRow: function (row) {
        if (row < 0) return;

        var rc = this.rowCount;
        if (rc == 1) return; //至少保留 一行
        if (row >= rc) return;

        //注释掉掉下面几行，不知没有没其它影响
        //	Cell cell = getFreezedCell();
        //	if (cell != null) if (cell.getRowIndex() == row) unFreezeCell();

        this.SheetRows.removeAt(row);

    },

    $$deleteColumn: function (col) {
        if (col < 0) return;

        var cc = this.columnCount;
        if (cc == 1) return; //至少保留一列
        if (col >= cc) return;

        // 注释掉掉下面几行，不知没有没其它影响
        //Cell cell = getFreezedCell();
        //if (cell != null) if (cell.getColumnIndex() == col) unFreezeCell();

        var rc = this.rowCount;
        for (var row = 0; row < rc; row++)
        {
            var /*Row*/     R = this.SheetRows[row];
            if (R == null) continue;
            R.$delete(col);
        }
    },


    $insertMultiColumn: function (startCol, endCol) {
        // 数据行
        for (var i = startCol; i <= endCol; i++)
        {
            this.$$insertColumnBefore(i);
        }

        // 行属性对象

        this.CPM.$insertMultiColumn(startCol, endCol);

        // 检查插入的行是不是贯穿了合并区
        this.MergeCheckAfterInsert(0, startCol, this.rowCount - 1, endCol);

        // 重新设置水平卷滚条
        this.resetHScrollBarScrollRange();
        // 重绘

        //2 如果在冻结行前插入，那么冻结行自动增加
        if (startCol <= this.freezedCol && this.freezedCol > 0)
        {
            this.freezedCol += Math.abs(endCol - startCol) + 1;
        }
        if (this.View != null) this.View.repaint();

        return true;
    },

    // 检查插入的行是不是贯穿了合并区

    MergeCheckAfterInsert: function (startRow, startCol, endRow, endCol) {

        var al = this.getAllMergeRange(); // 得到所有的合并区域

        for (var row = startRow; row <= endRow; row++)
        {
            for (var col = startCol; col <= endCol; col++)
            {
                for (var ai = 0; ai < al.length; ai++)
                {
                    var /*Range*/ r = al[ai];
                    if (r.contains(row, col)) // 如果新插入的行中的某个单元格正好处理合并区内，
                    { // 那么这把它也要设置成被合并的
                        var /*Cell*/   cell = this.cells(row, col);
                        this.MergeMap.put(cell, this.MergeMap.get(this.cells(r.startRow, r.startCol)));
                        break;
                    }
                }
            }
        }
    },

    // 检查插入的行是不是贯穿了合并区

    MergeCheckBeforeDelete: function (startRow, startCol, endRow, endCol, checkRow, checkCol) {

        var oldMergeRanges = [];
        for (var row = startRow; row <= endRow; row++)
        {
            for (var col = startCol; col <= endCol; col++)
            {
                var /*Cell*/ cell = this.$cells(row, col); // 注意是 $var /*Cell*/
                if (cell == null) continue;
                if (!cell.isMerged()) continue;

                var /*MergedRange*/   mr = this.MergeMap.get(cell);
                var r = mr.getMergedRange();
                oldMergeRanges.push(r);
                this.unMerge(r);

            }
        }
        return oldMergeRanges;
    },


    $insertMultiRow: function (startRow, endRow) {
        // 数据行
        for (var i = startRow; i <= endRow; i++)
        {
            this.$$insertRowBefore(i);
        }

        // 行属性对象

        this.RPM.$insertMultiRow(startRow, endRow);

        // 检查插入的行是不是贯穿了合并区
        this.MergeCheckAfterInsert(startRow, 0, endRow, this.CPM.getColumnCount() - 1);

        // 重新设置垂直卷滚条
        this.resetVScrollBarScrollRange();

        // 如果在冻结行前插入，那么冻结行自动增加
        if (startRow <= this.freezedRow && this.freezedRow > 0)
        {
            this.freezedRow += Math.abs(endRow - startRow) + 1;
        }
        // 重绘
        if (this.View != null) this.View.repaint();

        return true;
    },


    $deleteMultiRow: function (startRow, endRow) {

        var oldMergeRanges = this.MergeCheckBeforeDelete(startRow, 0, endRow, this.CPM.getColumnCount() - 1, true, false);

        // 数据行,注意一定要倒着删除

        for (var i = endRow; i >= startRow; i--)
        {
            this.$$deleteRow(i);
        }

        // 行属性对象 ,注意一定要倒着删除
        for (var i = endRow; i >= startRow; i--)
        {
            this.RPM.$deleteRow(i);
        }

        // 重新设置垂直卷滚条
        this.resetVScrollBarScrollRange();

        // 如果在冻结行前插入，那么冻结行自动增加

        if (startRow <= this.freezedRow && this.freezedRow > 0)
        {
            this.freezedRow -= Math.abs(endRow - startRow) + 1;
            this.freezedRow = Math.max(0, this.freezedRow);
        }

        //重新合并回来

        for (var i = 0; i < oldMergeRanges.length; i++)
        {
            var r = oldMergeRanges[i];

            r.endRow = r.endRow - (  Math.min(r.endRow, endRow) - Math.max(r.startRow, startRow) + 1);
            this.merge(r);

        }

        // 重绘
        if (this.View != null) this.View.repaint();

        return true;
    },


    $deleteMultiColumn: function (startCol, endCol) {
        var cc = this.columnCount;
        // 不允许全部删除
        if (startCol == 0 && endCol == cc - 1) return false;

        var /*Range*/    r = this.getSelection();
        var sr = r.startRow;
        var er = r.endRow;
        var sc;
        var ec;
        if (endCol < cc - 1)
        {
            sc = startCol;
        } else
        {
            sc = startCol - 1;
        }

        this.setSelection(new Range(0, 0, 0, 0));
        var oldMergeRanges = this.MergeCheckBeforeDelete(0, startCol, this.rowCount - 1, endCol, false, true);

        // 数据行,注意一定要倒着删除

        for (var i = endCol; i >= startCol; i--)
        {
            this.$$deleteColumn(i);
        }

        // 列属性对象 ,注意一定要倒着删除
        for (var i = endCol; i >= startCol; i--)
        {
            this.CPM.$deleteColumn(i);
        }

        // 重新设置水平卷滚条
        this.resetHScrollBarScrollRange();

        //如果在冻结行前插入，那么冻结行自动增加
        if (startCol <= this.freezedCol && this.freezedCol > 0)
        {
            this.freezedCol -= Math.abs(endCol - startCol) + 1;
            this.freezedCol = Math.max(0, this.freezedCol);
        }

        //重新合并回来

        for (var i = 0; i < oldMergeRanges.length; i++)
        {
            var r = oldMergeRanges[i];

            r.endCol = r.endCol - (  Math.min(r.endCol, endCol) - Math.max(r.startCol, startCol) + 1);
            this.merge(r);

        }

        // 重绘
        if (this.View != null) this.View.repaint();

        return true;
    }


};

export default ISheetInsertDelete ;
