/**
 * Created by 三宝爹 on 2017/12/20.
 */




var IExcel = {

    /**
     * @api {readXLS} 函数   readXLS
     *
     * @apiDescription readXLS(callback)
     * <br><br> 弹出一个选择excel文件的对话框选择一个excel文件，系统从excel中读取出数据，并调用 callback回调函数
     *
     * @apiName  readXLS
     * @apiGroup WorkBook
     * @apiVersion 1.0.0
     *
     * @apiParam {Function} callback  回调函数
     *
     *
     * @apiSuccess (返回值){void} - 无返回值
     *
     * @apiExample   {js}示例：
     *
     *  book.readXLS( function(data)
     *  {
     *      var sheet1 = data[Object.keys(data)[0]]; //获取第一个Sheet的数据
     *      var safeValue =function  (sheet, row, col) {
	            if (row > sheet.length - 1) return null;
	            var dataRow = sheet[row];
	            if( dataRow==null) return null;
	            if (col > dataRow.length - 1) return null;
	            return dataRow[col];
	        };

        alert( safeValue( sheet1 , 1,1));
        alert( safeValue( sheet1 , 1,2));



     *  });
     */
    readXLS: function (callback) {

        var rABS = true; //使用二进制方式读文件
        if (!XLSX)
        {
            console.error('请包含xlsx.XXXX.js');
            return;
        }

        var input = $('#' + this.View.containerID + "_input_file");
        if (input.length == 0)
        {
            var html = `<form id=${this.View.containerID}_form>
                            <input type="file" id="${this.View.containerID}_input_file"  
                                   accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
                                       style="display:none; position:absolute; left:0px;top:0px; "> 
                      
                                </form>
                             `;

            //$('#' + this.containerID).append(input);
            var tabContainer = $('#' + this.View.containerID + " .tabContainer");
            tabContainer.append($(html));

            input = $('#' + this.View.containerID + "_input_file");

            input.change(function (e) {


                var reader = new FileReader();
                reader.onload = function (e) {

                    var data = e.target.result;
                    if (!rABS) data = new Uint8Array(data);
                    var workbook = XLSX.read(data, {type: rABS ? 'binary' : 'array'});

                    var result = {};
                    workbook.SheetNames.forEach(function (sheetName) {
                        var roa = XLSX.utils.sheet_to_json(workbook.Sheets[sheetName], {header: 1});
                        if (roa.length) result[sheetName] = roa;
                    });

                    if (callback)
                    {
                        callback(result);
                    } else
                    {
                        var str = JSON.stringify(result);
                        console.info(str);

                    }

                };
                var f = e.target.files[0];
                if (rABS)
                {
                    reader.readAsBinaryString(f);
                } else
                {
                    reader.readAsArrayBuffer(f);
                }


            });

        }

        var form = $('#' + this.View.containerID + "_form");
        //如果不复位一下，那么如果连续选择同一个文件，change事件是不触发的，
        form[0].reset();

        input.click();

    }

};

export default IExcel;
