/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';
import EventListener from "../core/EventListener.js";

var EventManage = Class.extend({

    constructor: function () {
        this.m_ListenerList = [];
    },

    /**
     *
     * @param listener 需要接收事件的对象
     * @param order    int 触发的顺序，越小，越早触发
     * @param name   侦听者名称
     */
    addListener: function (/*EventListener*/ listener, order, name) {
        order = order || 99;
        name = name || '';
        listener.listenerOrder = order;
        listener.listenerName = name;

        var i, n = this.m_ListenerList.length;
        for (i = 0; i < n; i++)
        {
            var L = this.m_ListenerList[i];
            if (listener.listenerOrder < L.listenerOrder)
            {
                // 如果新加入的接听者的顺序号比较小，那么就插入到这个位置
                this.m_ListenerList.splice(i, 0, listener);
                return;
            }
        }
        // 显然，到这里， listener 的 顺序号是最大的，所以插入到最后。
        this.m_ListenerList.push(listener);
    },

    findListener: function (name) {
        var i, n = this.m_ListenerList.length;
        for (i = 0; i < n; i++)
        {
            var L = this.m_ListenerList[i];
            if (L.listenerName.toLowerCase() == name.toLowerCase()) return L;
        }
        return null;
    },

    removeListener: function (name) {
        var i, n = this.m_ListenerList.length;
        var rc = 0;
        for (i = n - 1; i >= 0; i--)
        {
            var L = this.m_ListenerList[i];
            if (L.listenerName.toLowerCase() == name.toLowerCase())
            {
                this.m_ListenerList.removeAt(i);
                rc++;
            }
        }
        return rc > 0;
    },

    /**
     * 触发事件，如果事件是有返回值的，且定义了参数 returnValueUnEqualToBreak
     * 那么当多个侦听者中只要有一个在事件中的返回值 ！= returnValueUnEqualToBreak时，则立刻回返回值，其它的侦听者不再响应事件
     * 如果不定义此参数，那么所有的侦听者都将执行相应的事件
     * @param eventName
     * @param args    [ ]
     * @param returnValueUnEqualToBreak 当某个接收者执行事件后，返回的值与此不相等时，那么提前终止循环。
     */
    fire: function (eventName, args, returnValueUnEqualToBreak) {

        var i, n = this.m_ListenerList.length;

        var retValue = undefined;

        for (i = 0; i < n; i++)
        {
            var L = this.m_ListenerList[i];
            if (L[eventName] == undefined) continue; //可能没有定义此事件
            retValue = L[eventName].apply(L, args);
            if (returnValueUnEqualToBreak != undefined)
            {
                if (retValue != returnValueUnEqualToBreak) return retValue;
            }
        }

        return retValue || returnValueUnEqualToBreak;

    }


});

export default EventManage;
