/**
 * Created by 三宝爹 on 2017/7/28.
 *
 *
 * 结果集配置
 *
 */


import Class from '../base/Class.js';

 var DataSourceConfig = Class.extend({

    static: {
        SingleRowDataSource: 1,
        MultiRowDataSource: 2,
        AsSingleRowDataSource: 4
    },

    properties: {

        /**
         * @api {name} 只读属性 [属性]name
         * @apiName  name
         * @apiDescription 结果集的名称
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){String} - 结果集的名称
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource(0);
         *  alert( dsc.name);
         *
         */
        "name": {
            get: function () {return this.Name;}
        },

        /**
         * @api {dataStore} 只读属性 [属性]dataStore
         * @apiName  dataStore
         * @apiDescription 结果集对象 ，参看 DataStore 对象的说明
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){DataStore} - 结果集对象
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource(0);
         *  var  ds= dsc.dataStore;
         *  alert( ds.rowCount();
         *
         *
         */
        "dataStore": {
            get: function () { return this.Ds}
        },


        /**
         * @api {dataSourceType} 只读属性 [属性]dataSourceType
         * @apiName  dataSourceType
         * @apiDescription 结果集的类型
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){int} - 结果集对象的类型,可以是如下值
         * <ul>
         *     <li>1</li> : 单行结果集
         *     <li>2</li> : 多行结果集
         *
         *</ul>
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource(0);
         *  if( dsc.dataSourceType==1)  alert("这是一个单行结果集");
         *
         *
         */
        "dataSourceType": {
            get: function () {return this.DataSourceType;}
        },

        /**
         * @api {currentBindRow} 可读可写属性 [属性]currentBindRow
         * @apiName  currentBindRow
         * @apiDescription 结果集在工作本上的当前亮显的行.当读取时，它等效于函数  getCurrentBindRow() ,
         * 当写该属性时，它等效于  setCurrentBindRow(row,false) ,注意第二个为false，表示并不强行触发焦点行变化事件，是否触发该事件要
         * 看参数row与当前焦点行是不是相等，相等则不触发 ，不相等则触发。
         * <ul>
         *     <li>本属性仅当结果集是多行结果集是有意义</li>
         *     <li>从0开始计数</li>
         *     </ul>
         *
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){int} - 当前亮显的行
         * <ul>
         *     <li>1</li> : 单行结果集
         *     <li>2</li> : 多行结果集
         *
         *</ul>
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource('query1');
         *  var row= dsc.currentBindRow;
         *  alert(" 当前亮显的行是" + row);
         *
         *
         */

        "currentBindRow": {
            get: function () {return this.getCurrentBindRow();},
            set: function (row) { this.setCurrentBindRow(row, false);}
        },

        /**
         * @api {DBPoolName} 只读属性 [属性]DBPoolName
         * @apiName  DBPoolName
         * @apiDescription 结果集使用的数据库连接池名称 .
         *
         *
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){String} - 结果集使用的数据库连接池的名称
         *
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource('query1');
         *  var dbpool= dsc.DBPoolName;
         *
         *
         *
         */
        "DBPoolName": {
            get: function () { return this.DBPool;},
            set: function (val) {
                this.DBPool = dbpool;
                this.Ds.setDBPoolName(val);
            }
        },

        "comment": {
            get: function () { return this.Comment;},
            set: function (val) { this.Comment = val;}
        },


        "rowCountEveryPageWhenPrint": {
            get: function () { return this.RowCountEveryPageWhenPrint;},
            set: function (val) { this.RowCountEveryPageWhenPrint = val;}
        },

        "balloonTipEditable": {
            get: function () { return this.BalloonTipEditable; },
            set: function (val) {this.BalloonTipEditable = val }
        },


        /**
         * @api {highlightCurrentRow} 可读可写属性 [属性]highlightCurrentRow
         * @apiName  highlightCurrentRow
         * @apiDescription 是否亮显当前行 .
         *
         *
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){bool} - 结果集是否需要亮显当前行
         * <ul><li>仅对多行结果集有效</ul>
         *     <li>默认是true</li>
         * </ul>
         *
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource('query1');
         *  dsc.highlightCurrentRow =false;
         *
         *
         *
         */
        "highlightCurrentRow": {
            get: function () { return this.HighlightCurrentRow},
            set: function (val) {this.HighlightCurrentRow = val;}

        },

        /**
         * @api {highlightEditableColumn} 可读可写属性 [属性]highlightEditableColumn
         * @apiName  highlightEditableColumn
         * @apiDescription 是否亮显可编辑的单元格 .
         *
         *
         * @apiGroup DataSourceConfig
         * @apiVersion 1.0.0
         * @apiSuccess (属性类型){bool} -  是否亮显可编辑的单元格
         * <ul>
         *     <li>默认是true</li>
         * </ul>
         *
         * @apiExample {js}(示例：)
         * //示例
         *
         *  var  dsc= book.getDataSource('query1');
         *  dsc.highlightEditableColumn =false;
         *
         *
         *
         */
        "highlightEditableColumn": {
            get: function () { return this.m_highlightEditableColumn},
            set: function (val) {this.m_highlightEditableColumn = val;}

        }

    },

    constructor: function (/*String*/ name, /*DataStore*/ ds, /*int*/ dsType) {
        this.RowCountEveryPageWhenPrint = -1;
        this.highlightCurrentRow = true;
        this.CurrentBindRow = -1;
        this.DSEA = null;
        this.BalloonTipEditable = false;
        this.m_highlightEditableColumn=true; //是否亮显可编辑的单元格


        this.Name = name;
        this.Ds = ds;
        this.DataSourceType = dsType;
        this.DBPool = ds.getConnection(); //连接池
        if (ds.rowCount > 0) this.CurrentBindRow = 0;


    },


     /**
      * @api {getCurrentBindRow} 函数   getCurrentBindRow
      *
      * @apiDescription
      * <br><br> 得到结果集当前焦点行号
      *
      * @apiName  getCurrentBindRow
      * @apiGroup DataSourceConfig
      * @apiVersion 1.0.0
      *
      *
      *
      * @apiSuccess (返回值){int} - 返回结果集当前焦点绑定行号
      *
      *
      * @apiExample   {js}示例：
      *
      *  //示例
      *  var row= book.getDataSource('q1').currentBindRow;
      *  var row2= book.getDataSource('q1').getCurrentBindRow(); //与上一行等效
      *
      *
      *
      */
     getCurrentBindRow:function()
     {
         return this.CurrentBindRow;
     },


     /**
      * @api {setCurrentBindRow} 函数   setCurrentBindRow
      *
      * @apiDescription  setCurrentBindRow(row, forceTriggerEvent)
      * <br><br> 设置结果集的当前绑定行
      *
      * @apiName  setCurrentBindRow
      * @apiGroup DataSourceConfig
      * @apiVersion 1.0.0
      *
      * @apiParam {int } row 当前绑定的行号 ，从0开始
      * @apiParam {boolean } forceTriggerEvent [可选参数]默认为true,表示是否强行触发当前绑定行变化事件，当此参数为true时，如果row与
      * 当前绑定行相等，那么也触发焦点行变化事件，否则仅当row与当前焦点行不相等时才触发焦点行变化事件
      *
      *
      *
      *
      * @apiSuccess (返回值){void} - 无返回值
      *
      * @apiExample   {js}示例：
      *
      *  //示例
      *
      *  book.getDataSource("q1").setCurrentBindRow(0);
      *
      *  book.getDataSource("q1").currentBindRow =0 ;  //与上一行等效
      *
      */

    setCurrentBindRow: function (/*int*/ row, /*boolean*/ forceTriggerEvent) {

         //注意，不要加 if( CurrentBindRow==row) return ;
         // 就样可以用 setCurrentBindRow来强制触发事件
         //  增加参数forceTriggerEvent ,因为当在一行上不同列间进行编辑时，会不停触发rowFocusChanged 事件　，严重影响性能


         if (forceTriggerEvent == undefined) forceTriggerEvent = true;
        forceTriggerEvent = forceTriggerEvent || this.CurrentBindRow != row;

        this.CurrentBindRow = row;

        if (!forceTriggerEvent) return;

        var /*DataStoreEventAdapter*/  dsa = this.Ds.EM.findListener(this.Name);
        dsa.repaintAllCells();
        dsa.assumeAllCellsCurrentBindRowOnCellVisibleRectangle();

        this.DSEA.Book.EM.fire("currentBindRowChanged", [this.Name, row]);

    }
    ,


    loadValueFromCellDefineAsDefaultValue: function () {
        var /*DataStoreListener*/  listener = this.Ds.EM.findListener(this.Name);
        if (listener == null) return;

        listener.loadValueFromCellDefineAsDefaultValue();

    }
    ,

    getAllCellsWhichBindTheCol: function (/*string*/  dbcol) {
        return this.DSEA.getAllCellsWhichBindTheCol(dbcol);
    },

     getDataStore:function()
     {
         return this.Ds;
     }

});

export default DataSourceConfig;
