/**
 * Created by zengjun on 2017/5/4.
 */


import Class from '../base/Class.js';

var DBBindConfig = Class.extend({

    properties:
        {
            "dataSourceType": {
                get: function () {
                    return this.dsType;
                },
                set: function (val) { this.dsType = dsType;}
            },
            'dataStore':
                {
                    get: function () { return this.book.getDataSource(this.dataSource).dataStore;}
                }


        },

    constructor: function (book, dataSource, dbCol, dsType) {


        /*String*/
        this.dataSource = dataSource;
        this.DBCol = dbCol;
        this.dsType = dsType;
        this.book = book;

        this.quickFindByCol = "";
        this.quickFindByValue = "";

        if (dbCol.indexOf("$") > 0)
        {
            var t = dbCol.split("[$]");
            if (t.length == 3)
            {
                this.DBCol = t[0];
                this.quickFindByCol = t[1];
                this.quickFindByValue = t[2];
            }
        }

        var /*DataSourceConfig*/    dsc = this.book.getDataSource(this.dataSource);
        if (dsc != null)
        {
            var dst = dsc.dataSourceType;
            //如果是多行数据源的当前行
            if (this.dsType == 4)
            {

                if (dst != 2) this.dsType = 1; //如果不是多行，那么强制改成单行
            }

            if (this.dsType != 4)
            {

                //强制改成与数据源类型一至， 因为可能出现这种操作，在单据编辑界面，复制配置，再到列表界面，
                // 粘贴，这样类型实际上是从单行变成了多行，所以需要在些强制重设置一下
                this.dsType = dst;
            }

        }


    },


    getDataSource: function () {
        return this.dataSource;
    }
    ,
    getDBCol: function () {
        return this.DBCol;
    }


});

export default DBBindConfig;

