/**
 * 修改Sheet的名称
 * Created by zengjun on 2017/5/4.
 */


import Command from './Command.js';

var CMD_SetSheetName = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        this.Scene.put("oldname", this.Sheet.name);
    },

    $execute: function () {
        this.Sheet.$setName(this.Scene.get("newname", ""));
        return true;

    },

    $undo: function () {
        this.Sheet.$setName(this.Scene.get("oldname", ""));
        return true;
    }


});


export default CMD_SetSheetName;
