/**
 * 合并单元格
 * Created by zengjun on 2017/5/4.
 */


import Command from './Command.js';


var CMD_SetProperty = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        // 旧的属性值已经被保存了
    },

    $execute: function () {


        var cell = this.Scene.get("cell");
        var propertyName = this.Scene.get("propertyname", "");
        var propertyValue = this.Scene.get("propertyvalue", null);
        return cell.$setProperty(propertyName, propertyValue);

    },

    $undo: function () {
        var cell = this.Scene.get("cell");
        var propertyName = this.Scene.get("propertyname", "");
        var propertyValue = this.Scene.get("oldpropertyvalue", null);
        return cell.$setProperty(propertyName, propertyValue);

    }


});

export default CMD_SetProperty;
