/**
 * Created by 三宝爹 on 2017/7/13.
 */


import Command from './Command.js';
import CMD_DeleteMultiColumn from './CMD_DeleteMultiColumn.js';
import RedefineBecause from '../core/RedefineBecause.js';


var CMD_InsertMultiColumn = Command.extend({

    constructor: function (sheet, scene, level) {
        this.$uper.constructor(sheet, scene, level);
    },

    $saveScene: function () {
        //need do nothing
    },

    $execute: function () {
        var startCol = this.Scene.get("startcol", 0);
        var endCol = this.Scene.get("endcol", 0);

        var ret = this.Sheet.$insertMultiColumn(startCol, endCol);

        // 如果本命令是第一次执行，那么只需要插入空行就可以了,否则还要还原数据
        if (ret && this.Scene.get("first", true) == false)
        {
            CMD_DeleteMultiColumn.RestoreData(this.Scene, this.Sheet, startCol, endCol);
        }
        //自动更新公式
        var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseInsertColumn, 0, startCol, 0, endCol);
        this.Sheet.Book.RebuildAllDefine(this.Sheet, why);

        return ret;

    },

    $undo: function () {
        var startCol = this.Scene.get("startcol", 0);
        var endCol = this.Scene.get("endcol", 0);

        // 当插入空行后，可能又做了一些操作 ，比如为新加的行设置了属性等
        // 此时Undo 这是删除这个新加的行，但不能直接一删了事，还需要保存新加的行的现在的信息
        CMD_DeleteMultiColumn.SaveScene(this.Scene, this.Sheet, startCol, endCol);
        this.Scene.put("first", false);
        var ret = this.Sheet.$deleteMultiColumn(startCol, endCol);
        //自动更新公式

        if (ret)
        {
            var why = new RedefineBecause(RedefineBecause.RebuildDefineBecauseDeleteColumn, 0, startCol, 0, endCol);
            this.Sheet.Book.RebuildAllDefine(this.Sheet, why);
        }
        return ret;
    }


});

export default CMD_InsertMultiColumn;
