/**
 * Created by 三宝爹 on 2018.09.03
 */

import HTMLBrick from './HTMLBrick.js';
import Tools from '../util/Tools.js';
import WorkBookView from '../core/WorkBookView.js';

var SheetContainer = HTMLBrick.extend({


    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);


        this.type = "SheetContainer";

        this.setConfig(config);

    },

    setConfig: function (config) {
        this.config = config;


        if (this.dom != null)
        {
            this.dom.remove();
            this.dom = null;
            this.invalidate();
        }


    },


    createDOM: function () {
        this.$uper.createDOM.call(this);
        let book = this.pSheet.Book;
        this.$createDOM(book);
        this.pSheet.Book.EM.fire("brickOnload", [this.pSheet,  this]);
    },

    $createDOM: function (book) {
        let that = this;


        this.containerID = Tools.newGUID();


        if (this.config.visible != undefined)
        {
            this.visible = this.config.visible;
        }
        if (this.config.enable != undefined)
        {
            this.enable = this.config.enable;
        }


        this.innerSheet = book.getWorkSheet(this.config.sheetGUID);


        if (this.pSheet)
        {
            //设计模式
            if (this.pSheet.designMode)
            {

                $("<div>" + this.innerSheet.name + "</div>").appendTo(this.dom);
                return;
            }
        }


        //对应的Sheet的tab设置成不可见
        //book.getWorkSheet(this.config.sheetGUID).visible = false;
        //2021.03.24 不能把 Sheet设置成不可见，那样在导出Excel时，会不导出，实际上只需要隐藏Sheet对应的Tab页即可
        book.getWorkSheet(this.config.sheetGUID).setSheetTabVisible( false );



        let sheetView = this.innerSheet.workSheetView;
        //重设父容器，这样，它卷滚后，可以设置相应卷滚条的坐标
        this.innerSheet.pSheetContainer = this;//设置自已的容器 ，参看 WorkSheet.js中的 标记20180903-01


        var scrollBarSize = WorkBookView.scrollBarSize;
        //下面的代码与WorkBookView 中基本一样

        var template = `
            
            <div id="${this.containerID}"  style="position:absolute; 
			                                    left:0; top:0px;height:100%; width:100%">
			   <div class="viewContainser  subSheetViewContainer " 
			                               id=${this.containerID}_sheetViewContainer style="position:absolute; 
			                                    left:0; top:0px;height:100%; width:100%; 
			                                    background-color:transparent;overflow:hidden; ">
            
              <!--用来显示卷滚条   如果 width<18px ,卷滚条也可能出不来 -->
               <div id="${this.containerID}_vScrollBar"  class="vScrollBar" style="position:absolute;
                                              right:0; 
                                              width:${scrollBarSize}px; 
                                              opacity:0.5;
                                              top:0px; 
                                              bottom:${scrollBarSize}px; 
                                              height:auto;
                                              z-index:1;
                                              overflow-y:auto;">
                        <!--  用来控制卷滚条高度  -->              
                        <div id="${this.containerID}_vScrollBar_content" style="background-color:transparent;
                                        width:1px; " ></div>
               </div>
               
              <!--用来显示水平卷滚条  如果 height<18px ,卷滚条也可能出不来 -->
               <div id="${this.containerID}_hScrollBar" class="hScrollBar"  style="position:absolute;
                                              left:0; 
                                              right:0px;
                                              width:auto; 
                                              bottom:0; 
                                              height:${scrollBarSize}px; 
                                              opacity:0.5;
                                              z-index:1;
                                              overflow-x:auto;">
                <!--  用来控制卷滚条高度  ，如果不指定一个高度，那么，hScrollBar的卷滚条出不来-->              
               <div id="${this.containerID}_hScrollBar_content" style="background-color:white;height:20px;"></div>
               </div>
                
            
            </div>
            </div>
            
            `;


        $(this.dom).append(template);


        let viewContainer = $('#' + this.containerID + "_sheetViewContainer");

        viewContainer.append(sheetView.viewContainer);


        //2019.06.05 如果指定了添加到某个容器中（比如Tab的tab页中），那么就把它append到合适的父容器中
        //参看  TabContentBrick.js 中的标记20190605
        if (this.config.appendToContainer)
        {

            $(this.config.appendToContainer).append(this.dom);
        }

        $(sheetView.viewContainer).css("display", "");
        $(sheetView.background).css("display", "");
        $(sheetView.canvas).css("display", "");
        //显示出来


        var vScrollBar = $('#' + this.containerID + '_vScrollBar');
        vScrollBar.scroll(this.onVscroll.bind(this));//注意要强制切换到本View的上下文中执行

        vScrollBar.on('mouseover', function () { vScrollBar.css("opacity", 0.9);});
        vScrollBar.on('mouseout', function () { vScrollBar.css("opacity", 0.5);});


        var hScrollBar = $('#' + this.containerID + '_hScrollBar');
        hScrollBar.scroll(this.onHscroll.bind(this));
        hScrollBar.on('mouseover', function () { hScrollBar.css("opacity", 0.9);});
        hScrollBar.on('mouseout', function () { hScrollBar.css("opacity", 0.5);});

        //resize处理
        $('#' + this.containerID + '_sheetViewContainer').resize(this.resize.bind(this));

        this.vScrollingHandle = 0;
        this.hScrollingHandle = 0;
        this.resize();


    },


    setEnable: function (v) {
        this.Enable = v;


        if (this.dom)
        {
            $(this.dom).attr("disabled", !v);
        }

    },


    ///////////////////////////

    /**
     *
     */
    resize: function () {

        console.info("resize   " + new Date());


        Tools.delayRun("sheetContainer-resize" + Tools.newGUID()    , function () {


            if (!this.innerSheet) return;

            var viewContainer = $('#' + this.containerID + "");
            var w = viewContainer.width();
            var h = viewContainer.height();

            //2020.06.17 当嵌入到的sheet，它又弹出显示时，在关闭时，它出现
            //下面的 width，height==100的情况，这个怎么出来的，不清楚， 先屏蔽
            // 不然在父Shet再次弹出显示时，本Sheet就很小一块
            // TODO  临时这么解决了，等有空再详查，没空就这样用也没问题

            if (w == 100 && h == 100) return;

            let sheetView = this.innerSheet.workSheetView;


            sheetView.viewContainer.style.width = (w) + "px";
            sheetView.viewContainer.style.height = (h ) + "px";


            //背景，坐标上从行头列头处开始，避免行头及列头档住部分背景
            var chh = sheetView.CPM.getColumnHeadHeight();
            var rhw = sheetView.RPM.getRowHeadWidth();
            if( sheetView.background)
            {
                $(sheetView.background).css
                ({
                    width: (w - rhw) + 'px',
                    height: (h - chh) + 'px',
                    "top": `${chh}px`,
                    "left": `${rhw}px`,
                });
            }

            sheetView.canvas.style.width = (w) + "px";
            sheetView.canvas.style.height = (h ) + "px";

            sheetView.canvas.width = w;
            sheetView.canvas.height = h;

            //弹性列宽， 行高的重新计算
            sheetView.reCalcuColumnsWidth();
            sheetView.reCalcuRowsHeight();


            this.resetHScrollBarScrollRange();
            this.resetVScrollBarScrollRange();

            //重新显隐控件
            sheetView.Sheet.bricksShowOrHideWithWorkSheet();

            console.info("repaint after resize");
            sheetView.repaint();
        }.bind(this), 17); //100
    },


    /**
     * 当sheet激活后， 根据sheet 的size,pos 调整卷滚条
     * @constructor
     */
    resetVScrollBarScrollRange: function () {
        var sheet = this.innerSheet;
        if (!sheet) return;

        var scrollBarSize = WorkBookView.scrollBarSize;

        var h = sheet.RPM.getAllRowsHeight();// - sheet.RPM.getFixedRowHeight();
        var vScrollBar = $('#' + this.containerID + '_vScrollBar');
        vScrollBar.css('top', sheet.CPM.getColumnHeadHeight() + "px");


        if (h <= vScrollBar.height() + scrollBarSize)
        {

            vScrollBar.hide();
            sheet.yOffset = 0;
        } else
        {
            var hScrollBar = $('#' + this.containerID + '_hScrollBar');
            $('#' + this.containerID + '_vScrollBar_content').height(h + 1);
            vScrollBar.show();
            this.vScrollTo(sheet.yOffset);
        }


    },

    resetHScrollBarScrollRange: function () {

        var sheet = this.innerSheet;
        if (!sheet) return;

        var scrollBarSize = WorkBookView.scrollBarSize;
        var w = sheet.CPM.getAllColumnsWidth() //- sheet.CPM.getFixedColumnWidth();
        //console.info(" width:" + w);
        var hScrollBar = $('#' + this.containerID + '_hScrollBar');

        hScrollBar.css('left', sheet.RPM.getRowHeadWidth() + "px");
        $('#' + this.containerID + '_hScrollBar_content').width(w);

        if (w <= hScrollBar.width() + scrollBarSize)
        {

            hScrollBar.hide();
            sheet.xOffset = 0;
        } else
        {
            hScrollBar.show();
            this.hScrollTo(sheet.xOffset);
        }


    },

    onVscroll: function () {

        var sheet = this.innerSheet;
        if (!sheet) return;

        if (this.vScrollingHandle != 0)
        {
            clearTimeout(this.vScrollingHandle);
            this.vScrollingHandle = 0;
        }

        //  this.vScrollingHandle = setTimeout(function () {
        var vScrollBar = $('#' + this.containerID + '_vScrollBar');
        var offset = vScrollBar[0].scrollTop;


        sheet.yOffset = offset;

        //  }.bind(this), 10);

    },

    onHscroll: function () {
        var sheet = this.innerSheet;
        if (!sheet) return;

        var hScrollBar = $('#' + this.containerID + '_hScrollBar');
        var offset = hScrollBar[0].scrollLeft;

        sheet.xOffset = offset;


    },


    vScrollTo: function (pos) {

        var vScrollBar = $('#' + this.containerID + '_vScrollBar');
        if (vScrollBar.length == 0) return;
        var offset = vScrollBar[0].scrollTop;
        if (pos == offset) return;
        vScrollBar.scrollTop(pos);

    },

    hScrollTo: function (pos) {
        var hScrollBar = $('#' + this.containerID + '_hScrollBar');
        if (hScrollBar.length == 0) return;
        var offset = hScrollBar[0].scrollLeft;
        if (pos == offset) return;
        hScrollBar.scrollLeft(pos);

    },


    forceCurrentEditControlGiveUpFocus: function () {
        this.innerSheet.View.forceCurrentEditControlGiveUpFocus();

    },

    forceCurrentEditControlFillBack: function () {
        this.innerSheet.View.forceCurrentEditControlFillBack();

    }


});


export default SheetContainer;
