/**
 * Created by 三宝爹 on 2017/12/14.
 */


import BasicBrick from './BasicBrick.js' ;

var HTMLBrick = BasicBrick.extend({

    constructor: function (name, config, x, y, width, height) {

        this.init(name, config, x, y, width, height);

        this.type = "html";

    },

    paint: function (/*boolean */isPrint  /*int*/, /*Graphics2D*/ g, /*Rectangle*/ parentRC) {

        if (this.dom == null) this.createDOM();


        var rc = this.getBounds(parentRC);

        this.dom.css("position", "absolute");

        let x= rc.x;
        let y= rc.y;

        if( this.config.justInTabContainer)
        {
           x=0;
            y=0;
        }

        this.dom.css("left", x + "px");
        this.dom.css("top", y + "px");
        this.dom.css("width", rc.width + "px");
        this.dom.css("height", rc.height + "px");
        this.dom.css("overflow", "hidden");
       // if( this.pSheet.designMode )  this.dom.css("pointer-events", "none");

        this.onSize(rc);

    },

    createDOM: function ( needTriggerOnload) {


        var bookView = this.pSheet.Book.View;

        var html = this.config.html;
        if (!html) html = "<div style='width:100%;height:100%;overflow:hidden;'></div>";
        this.dom = bookView.createDOM(this.DOMName, html);

        var container = $(this.pSheet.View.canvas.parentNode);
        this.dom.appendTo(container);

        let that = this;
        this.dom.click(function () {
                if (that.pSheet.designMode)
                {
                    that.pSheet.setSelection(
                        that.pCell.rowIndex, that.pCell.columnIndex,
                        that.pCell.rowIndex, that.pCell.columnIndex);
                }
                this.blur();

            }
        );

        //2021.05.19 解决在HTML中滚动滚轮时， WorkSheetView不能卷滚
        //2021.05.19 修正 ，在 DBPageBrick.js中可能引发异常
        let needMouseWheel=  this.config.needMouseWheel;
        if( needMouseWheel ==null ) needMouseWheel=false;
        //2021.06.02 增加，如果控件自已不需要鼠标滚轮操作，那么在它上面的鼠标滚轮操作就传递给workSheetView 来处理
        // CKEditor 自已就需要滚轮操作，所以它不能放弃滚轮处理
        if(! needMouseWheel)
        {
            setTimeout(function () {
                try
                {
                    that.dom.bind('mousewheel', that.pSheet.View.mouseWheel.bind(that.pSheet.View));
                } catch (err)
                {
                    console.error(err);
                }
            }, 1000);
        }

        if (this.config.visible != undefined)
        {
            this.visible = this.config.visible;
        }
        if (this.config.enable != undefined)
        {
            this.enable = this.config.enable;
        }

        if(needTriggerOnload==null) needTriggerOnload=true;
        if( needTriggerOnload)  this.pSheet.Book.EM.fire("brickOnload", [this.pSheet,   this]);

    },

    onSize: function (rc) {

    },

    setVisible: function (v) {

        if (this.dom == null) this.createDOM();

        this.Visible = v;

        this.showOrHide(v);
    },

    showOrHide: function (v) {

        if (this.dom == null) this.createDOM();


        if (v && !this.outofScreen())
        {

            this.dom.css("display", "");
            return;
        } else
        {
            this.dom.css("display", "none");
            return;
        }


    },

    showOrHideWithWorkSheet: function () {

        var v = this.visible;
        this.showOrHide(v);

    }

});


export default HTMLBrick ;
