//参看 https://ckeditor.com/docs/ckeditor5/latest/framework/guides/deep-dive/upload-adapter.html#the-anatomy-of-the-adapter
//为 CKEditor 定制图片上传

class CKEditorUploadAdapter {
    constructor(loader, url, pSheet)
    {
        this.loader = loader;
        this.url = url;
        this.pSheet = pSheet;

        this.loader.abort=function(){};
    }

    // Starts the upload process.
    upload()
    {
        return this.loader.file
            .then(file => new Promise((resolve, reject) => {
                const data = new FormData();

                data.append('file', file);
                //允许应用在事件中往data中注入参数，因为提交到的url它可能需要更多的参数，而不仅仅是选择文件
                this.pSheet.Book.EM.fire("buildCKEditorUploadParam", [data]);
                let that = this;
                // Send the request.
                axios.post(that.url, data, {
                    timeout: 300 * 10000,
                    withCredentials: true,

                    onUploadProgress: function (progressEvent) {
                        that.loader.uploadTotal = progressEvent.total;
                        that.loader.uploaded = progressEvent.loaded;
                    }
                }).then(function (res) {
                    //触发文件上传完成事件，比如在单据中，可以刷新附件
                    that.pSheet.Book.EM.fire("afterCKEditorUploadFile", [res]);
                    resolve({default: res.data.url_img});
                }).catch(function (err) {
                    console.error(err.message);
                    resolve(1);
                });
            }));
    }

    // Aborts the upload process.
    abort()
    {
        console.info("上传中止");
    }
}

export default CKEditorUploadAdapter;
